/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.forwarding;

import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import net.centro.rtb.monitoringcenter.metrics.forwarding.MetricProvider;

public class ForwardingReadOnlyCounter
extends Counter {
    private MetricProvider<Counter> metricProvider;

    public ForwardingReadOnlyCounter(final Counter delegate) {
        Preconditions.checkNotNull((Object)delegate);
        this.metricProvider = new MetricProvider<Counter>(){

            @Override
            public Counter get() {
                return delegate;
            }
        };
    }

    public ForwardingReadOnlyCounter(MetricProvider<Counter> metricProvider) {
        Preconditions.checkNotNull(metricProvider);
        this.metricProvider = metricProvider;
    }

    public void inc() {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only counter");
    }

    public void inc(long n) {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only counter");
    }

    public void dec() {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only counter");
    }

    public void dec(long n) {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only counter");
    }

    public long getCount() {
        return this.metricProvider.get().getCount();
    }
}

