/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.forwarding;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.centro.rtb.monitoringcenter.metrics.forwarding.MetricProvider;

public class CompositeForwardingTimer
extends Timer {
    private Timer mainDelegate;
    private MetricProvider<Timer> supplementaryMetricProvider;
    private Clock clock;

    public CompositeForwardingTimer(Timer mainDelegate, MetricProvider<Timer> supplementaryMetricProvider) {
        Preconditions.checkNotNull((Object)mainDelegate);
        Preconditions.checkNotNull(supplementaryMetricProvider);
        this.mainDelegate = mainDelegate;
        this.supplementaryMetricProvider = supplementaryMetricProvider;
        this.clock = Clock.defaultClock();
    }

    public void update(long duration, TimeUnit unit) {
        this.mainDelegate.update(duration, unit);
        this.supplementaryMetricProvider.get().update(duration, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    public Timer.Context time() {
        return super.time();
    }

    public long getCount() {
        return this.mainDelegate.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.mainDelegate.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.mainDelegate.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.mainDelegate.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.mainDelegate.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.mainDelegate.getSnapshot();
    }
}

