/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.forwarding;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.base.Preconditions;
import net.centro.rtb.monitoringcenter.metrics.forwarding.MetricProvider;

public class CompositeForwardingHistogram
extends Histogram {
    private Histogram mainDelegate;
    private MetricProvider<Histogram> supplementaryMetricProvider;

    public CompositeForwardingHistogram(Histogram mainDelegate, MetricProvider<Histogram> supplementaryMetricProvider) {
        super((Reservoir)new ExponentiallyDecayingReservoir());
        Preconditions.checkNotNull((Object)mainDelegate);
        Preconditions.checkNotNull(supplementaryMetricProvider);
        this.mainDelegate = mainDelegate;
        this.supplementaryMetricProvider = supplementaryMetricProvider;
    }

    public Snapshot getSnapshot() {
        return this.mainDelegate.getSnapshot();
    }

    public long getCount() {
        return this.mainDelegate.getCount();
    }

    public void update(long value) {
        this.mainDelegate.update(value);
        this.supplementaryMetricProvider.get().update(value);
    }

    public void update(int value) {
        this.mainDelegate.update(value);
        this.supplementaryMetricProvider.get().update(value);
    }
}

