/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Preconditions;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;

public class C3P0PooledDataSourceMetricSet
implements MetricSet {
    private PooledDataSource pooledDataSource;
    private ComboPooledDataSource comboPooledDataSource;

    public C3P0PooledDataSourceMetricSet(PooledDataSource pooledDataSource) {
        Preconditions.checkNotNull((Object)pooledDataSource);
        this.pooledDataSource = pooledDataSource;
        if (ComboPooledDataSource.class.isInstance(pooledDataSource)) {
            this.comboPooledDataSource = (ComboPooledDataSource)ComboPooledDataSource.class.cast(pooledDataSource);
        }
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> metricsByNames = new HashMap<String, Object>();
        String connectionsNamespace = "connections";
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "currentCount"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumConnectionsAllUsers();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "busy"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumBusyConnectionsAllUsers();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "idle"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumIdleConnectionsAllUsers();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "unclosedOrphaned"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumUnclosedOrphanedConnectionsAllUsers();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "failedCheckouts"), new Gauge<Long>(){

            public Long getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumFailedCheckoutsDefaultUser();
                }
                catch (SQLException ignore) {
                    return -1L;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "failedCheckins"), new Gauge<Long>(){

            public Long getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumFailedCheckinsDefaultUser();
                }
                catch (SQLException ignore) {
                    return -1L;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "failedIdleTests"), new Gauge<Long>(){

            public Long getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumFailedIdleTestsDefaultUser();
                }
                catch (SQLException ignore) {
                    return -1L;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "threadsAwaitingCheckout"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        if (this.comboPooledDataSource != null) {
            metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "max"), new Gauge<Integer>(){

                public Integer getValue() {
                    return C3P0PooledDataSourceMetricSet.this.comboPooledDataSource.getMaxPoolSize();
                }
            });
            metricsByNames.put(MetricNamingUtil.join(connectionsNamespace, "min"), new Gauge<Integer>(){

                public Integer getValue() {
                    return C3P0PooledDataSourceMetricSet.this.comboPooledDataSource.getMinPoolSize();
                }
            });
        }
        String helperThreadPoolNamespace = "helperThreadPool";
        metricsByNames.put(MetricNamingUtil.join(helperThreadPoolNamespace, "size"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getThreadPoolSize();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(helperThreadPoolNamespace, "busyThreads"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getThreadPoolNumActiveThreads();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(helperThreadPoolNamespace, "idleThreads"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getThreadPoolNumIdleThreads();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        metricsByNames.put(MetricNamingUtil.join(helperThreadPoolNamespace, "pendingTasks"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getThreadPoolNumTasksPending();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        String statementCacheNamespace = "statementCache";
        metricsByNames.put(MetricNamingUtil.join(statementCacheNamespace, "size"), new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return C3P0PooledDataSourceMetricSet.this.pooledDataSource.getStatementCacheNumStatementsAllUsers();
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
        });
        if (this.comboPooledDataSource != null) {
            metricsByNames.put(MetricNamingUtil.join(statementCacheNamespace, "maxSize"), new Gauge<Integer>(){

                public Integer getValue() {
                    return C3P0PooledDataSourceMetricSet.this.comboPooledDataSource.getMaxStatements();
                }
            });
        }
        return Collections.unmodifiableMap(metricsByNames);
    }
}

