/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.infos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import net.centro.rtb.monitoringcenter.config.NamingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeInfo {
    private static final Logger logger = LoggerFactory.getLogger(NodeInfo.class);
    private String nodeId;
    private String datacenterName;
    private String nodeGroupName;
    private String publicIpAddress;
    private String loadBalancerIpAddress;

    private NodeInfo() {
    }

    public static NodeInfo create(String datacenterName, String nodeGroupName, String nodeId) {
        Preconditions.checkNotNull((Object)datacenterName);
        Preconditions.checkNotNull((Object)nodeGroupName);
        Preconditions.checkNotNull((Object)nodeId);
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.datacenterName = datacenterName;
        nodeInfo.nodeGroupName = nodeGroupName;
        nodeInfo.nodeId = nodeId;
        nodeInfo.publicIpAddress = NodeInfo.detectPublicIpAddress();
        nodeInfo.loadBalancerIpAddress = NodeInfo.detectLoadBalancerIpAddress();
        return nodeInfo;
    }

    public static NodeInfo create(NamingConfig namingConfig) {
        Preconditions.checkNotNull((Object)namingConfig);
        return NodeInfo.create(namingConfig.getDatacenterName(), namingConfig.getNodeGroupName(), namingConfig.getNodeId());
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public String getLoadBalancerIpAddress() {
        return this.loadBalancerIpAddress;
    }

    private static String detectPublicIpAddress() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.debug("Unable to obtain network interfaces!", (Throwable)e);
            return null;
        }
        for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            boolean isLoopback = false;
            try {
                isLoopback = networkInterface.isLoopback();
            }
            catch (SocketException e) {
                logger.debug("Unable to identify if a network interface is a loopback or not");
            }
            if (isLoopback) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!Inet4Address.class.isInstance(inetAddress) || inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) continue;
                return inetAddress.getHostAddress();
            }
        }
        return null;
    }

    private static String detectLoadBalancerIpAddress() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.debug("Unable to obtain network interfaces!", (Throwable)e);
            return null;
        }
        for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            boolean isLoopback = false;
            try {
                isLoopback = networkInterface.isLoopback();
            }
            catch (SocketException e) {
                logger.debug("Unable to identify if a network interface is a loopback or not");
                continue;
            }
            if (!isLoopback) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress.isLoopbackAddress() || !Inet4Address.class.isInstance(inetAddress)) continue;
                return inetAddress.getHostAddress();
            }
        }
        return null;
    }
}

