/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.PickledGraphite;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.centro.rtb.monitoringcenter.MetricCollector;
import net.centro.rtb.monitoringcenter.MetricCollectorImpl;
import net.centro.rtb.monitoringcenter.NoOpMetricCollector;
import net.centro.rtb.monitoringcenter.config.Configurator;
import net.centro.rtb.monitoringcenter.config.GraphiteReporterConfig;
import net.centro.rtb.monitoringcenter.config.HostAndPort;
import net.centro.rtb.monitoringcenter.config.MetricCollectionConfig;
import net.centro.rtb.monitoringcenter.config.MonitoringCenterConfig;
import net.centro.rtb.monitoringcenter.config.NamingConfig;
import net.centro.rtb.monitoringcenter.infos.AppInfo;
import net.centro.rtb.monitoringcenter.infos.NodeInfo;
import net.centro.rtb.monitoringcenter.infos.SystemInfo;
import net.centro.rtb.monitoringcenter.metrics.system.SystemMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.SystemStatus;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatMetricSet;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatStatus;
import net.centro.rtb.monitoringcenter.util.ConfigFileUtil;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringCenter {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringCenter.class);
    private static final int CONFIG_RELOAD_INTERVAL_IN_SECONDS = 60;
    private static final String HEALTH_CHECK_POSTFIX = "HealthCheck";
    private static final String SYSTEM_METRIC_NAMESPACE = "system";
    private static final String TOMCAT_METRIC_NAMESPACE = "tomcat";
    private static final String DB_METRIC_NAMESPACE = "dbs";
    private static final Set<String> RESERVED_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(MonitoringCenter.SYSTEM_METRIC_NAMESPACE);
            this.add(MonitoringCenter.TOMCAT_METRIC_NAMESPACE);
        }
    });
    private static final SortedMap<String, ? extends Metric> EMPTY_METRIC_MAP = new TreeMap<String, Metric>();
    private static final SortedMap<String, HealthCheck.Result> EMPTY_HEALTHCHECK_MAP = new TreeMap<String, HealthCheck.Result>();
    private static AtomicBoolean configured = new AtomicBoolean(false);
    private static AtomicBoolean shutdown = new AtomicBoolean(false);
    private static String prefix;
    private static MonitoringCenterConfig initialConfig;
    private static MonitoringCenterConfig currentConfig;
    private static ScheduledExecutorService executorService;
    private static MetricRegistry metricRegistry;
    private static GraphiteReporter graphiteReporter;
    private static HealthCheckRegistry healthCheckRegistry;
    private static SystemMetricSet systemMetricSet;
    private static TomcatMetricSet tomcatMetricSet;
    private static SystemInfo systemInfo;
    private static NodeInfo nodeInfo;
    private static AppInfo appInfo;

    private MonitoringCenter() {
    }

    public static void configure(MonitoringCenterConfig config) {
        MonitoringCenter.configure(config, false);
    }

    public static MetricCollector getMetricCollector(Class<?> clazz, String ... namespaces) {
        Preconditions.checkNotNull(clazz, (Object)"class cannot be null");
        return MonitoringCenter.getMetricCollector(clazz.getSimpleName(), namespaces);
    }

    public static MetricCollector getMetricCollector(String mainNamespace, String ... additionalNamespaces) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mainNamespace), (Object)"mainNamespace cannot be blank");
        if (!configured.get()) {
            logger.debug("MonitoringCenter has not been configured. Returning a NoOpMetricCollector.");
            return new NoOpMetricCollector();
        }
        String sanitizedMainNamespace = MetricNamingUtil.sanitize(mainNamespace);
        Preconditions.checkArgument((!RESERVED_NAMESPACES.contains(sanitizedMainNamespace) ? 1 : 0) != 0);
        String collectorNamespace = MetricNamingUtil.join(sanitizedMainNamespace, additionalNamespaces);
        return new MetricCollectorImpl(metricRegistry, initialConfig.getNamingConfig(), collectorNamespace);
    }

    public static MetricCollector getDatabaseMetricCollector(String ... additionalNamespaces) {
        return MonitoringCenter.getMetricCollector(DB_METRIC_NAMESPACE, additionalNamespaces);
    }

    public static SortedMap<String, Counter> getCountersByNames() {
        return MonitoringCenter.getMetricsByNames(false, null, Counter.class);
    }

    public static SortedMap<String, Counter> getCountersByNames(boolean appendPrefix) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, null, Counter.class);
    }

    public static SortedMap<String, Counter> getCountersByNames(boolean appendPrefix, String[] startsWithFilters) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, startsWithFilters, Counter.class);
    }

    public static SortedMap<String, Meter> getMetersByNames() {
        return MonitoringCenter.getMetricsByNames(false, null, Meter.class);
    }

    public static SortedMap<String, Meter> getMetersByNames(boolean appendPrefix) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, null, Meter.class);
    }

    public static SortedMap<String, Meter> getMetersByNames(boolean appendPrefix, String[] startsWithFilters) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, startsWithFilters, Meter.class);
    }

    public static SortedMap<String, Histogram> getHistogramsByNames() {
        return MonitoringCenter.getMetricsByNames(false, null, Histogram.class);
    }

    public static SortedMap<String, Histogram> getHistogramsByNames(boolean appendPrefix) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, null, Histogram.class);
    }

    public static SortedMap<String, Histogram> getHistogramsByNames(boolean appendPrefix, String[] startsWithFilters) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, startsWithFilters, Histogram.class);
    }

    public static SortedMap<String, Timer> getTimersByNames() {
        return MonitoringCenter.getMetricsByNames(false, null, Timer.class);
    }

    public static SortedMap<String, Timer> getTimersByNames(boolean appendPrefix) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, null, Timer.class);
    }

    public static SortedMap<String, Timer> getTimersByNames(boolean appendPrefix, String[] startsWithFilters) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, startsWithFilters, Timer.class);
    }

    public static SortedMap<String, Gauge> getGaugesByNames() {
        return MonitoringCenter.getMetricsByNames(false, null, Gauge.class);
    }

    public static SortedMap<String, Gauge> getGaugesByNames(boolean appendPrefix) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, null, Gauge.class);
    }

    public static SortedMap<String, Gauge> getGaugesByNames(boolean appendPrefix, String[] startsWithFilters) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, startsWithFilters, Gauge.class);
    }

    public static SortedMap<String, Metric> getMetricsByNames() {
        return MonitoringCenter.getMetricsByNames(false, null, null);
    }

    public static SortedMap<String, Metric> getMetricsByNames(boolean appendPrefix) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, null, null);
    }

    public static SortedMap<String, Metric> getMetricsByNames(boolean appendPrefix, String[] startsWithFilters) {
        return MonitoringCenter.getMetricsByNames(appendPrefix, startsWithFilters, null);
    }

    public static void removeAllMetrics() {
        if (!configured.get()) {
            return;
        }
        metricRegistry.removeMatching(MetricFilter.ALL);
    }

    public static void registerHealthCheck(String name, HealthCheck healthCheck) {
        Preconditions.checkNotNull((Object)healthCheck, (Object)"healthCheck cannot be null");
        if (!configured.get()) {
            logger.debug("MonitoringCenter has not been configured. The health check will not be registered.");
            return;
        }
        healthCheckRegistry.register(MonitoringCenter.normalizeHealthCheckName(name), healthCheck);
    }

    public static SortedMap<String, HealthCheck.Result> runHealthChecks() {
        if (!configured.get()) {
            return EMPTY_HEALTHCHECK_MAP;
        }
        return healthCheckRegistry.runHealthChecks();
    }

    public static HealthCheck.Result runHealthCheck(String name) {
        if (!configured.get()) {
            throw new NoSuchElementException("MonitoringCenter has not been initialized. No health checks are available.");
        }
        String normalizedName = MonitoringCenter.normalizeHealthCheckName(name);
        try {
            return healthCheckRegistry.runHealthCheck(normalizedName);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("Health check " + normalizedName + " could not be found.");
        }
    }

    public static void removeAllHealthChecks() {
        if (!configured.get()) {
            return;
        }
        for (String name : healthCheckRegistry.getNames()) {
            healthCheckRegistry.unregister(name);
        }
    }

    public static void removeHealthCheck(String name) {
        if (!configured.get()) {
            return;
        }
        healthCheckRegistry.unregister(MonitoringCenter.normalizeHealthCheckName(name));
    }

    public static SystemStatus getSystemStatus() {
        return systemMetricSet;
    }

    public static TomcatStatus getTomcatStatus() {
        return tomcatMetricSet;
    }

    public static SystemInfo getSystemInfo() {
        return systemInfo;
    }

    public static NodeInfo getNodeInfo() {
        return nodeInfo;
    }

    public static AppInfo getAppInfo() {
        return appInfo;
    }

    public static void shutdown() {
        if (shutdown.getAndSet(true)) {
            return;
        }
        if (executorService != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executorService, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (graphiteReporter != null) {
            GraphiteReporterConfig graphiteReporterConfig;
            MonitoringCenterConfig config = currentConfig;
            if (config != null && config.getMetricReportingConfig() != null && (graphiteReporterConfig = config.getMetricReportingConfig().getGraphiteReporterConfig()) != null && graphiteReporterConfig.isReportOnShutdown()) {
                graphiteReporter.report();
            }
            graphiteReporter.stop();
        }
        if (systemMetricSet != null) {
            systemMetricSet.shutdown();
        }
        if (tomcatMetricSet != null) {
            tomcatMetricSet.shutdown();
        }
    }

    private static <T extends Metric> SortedMap<String, T> getMetricsByNames(boolean appendPrefix, String[] startsWithFilters, Class<T> metricClass) {
        if (!configured.get()) {
            return EMPTY_METRIC_MAP;
        }
        TreeMap<String, Metric> metricsByNames = new TreeMap<String, Metric>();
        for (Map.Entry entry : metricRegistry.getMetrics().entrySet()) {
            if (metricClass != null && !metricClass.isAssignableFrom(((Metric)entry.getValue()).getClass()) || startsWithFilters != null && !MonitoringCenter.matchesStartsWithFilters((String)entry.getKey(), startsWithFilters)) continue;
            String metricName = (appendPrefix ? prefix + "." : "") + (String)entry.getKey();
            metricsByNames.put(metricName, (Metric)entry.getValue());
        }
        return metricsByNames;
    }

    private static synchronized void configure(MonitoringCenterConfig config, boolean internalCall) {
        GraphiteReporterConfig graphiteReporterConfig;
        if (configured.get()) {
            if (internalCall) {
                return;
            }
            throw new IllegalStateException("MonitoringCenter has already been configured!");
        }
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        NamingConfig namingConfig = config.getNamingConfig();
        prefix = namingConfig.getApplicationName() + "." + namingConfig.getDatacenterName() + "." + namingConfig.getNodeGroupName() + "." + namingConfig.getNodeId();
        initialConfig = config;
        currentConfig = config;
        metricRegistry = new MetricRegistry();
        healthCheckRegistry = new HealthCheckRegistry();
        MetricCollectionConfig metricCollectionConfig = config.getMetricCollectionConfig();
        if (metricCollectionConfig != null) {
            if (metricCollectionConfig.isEnableSystemMetrics()) {
                systemMetricSet = new SystemMetricSet();
                metricRegistry.register(SYSTEM_METRIC_NAMESPACE, (Metric)systemMetricSet);
            }
            if (metricCollectionConfig.isEnableTomcatMetrics()) {
                tomcatMetricSet = new TomcatMetricSet();
                metricRegistry.register(TOMCAT_METRIC_NAMESPACE, (Metric)tomcatMetricSet);
            }
        }
        if (config.getMetricReportingConfig() != null && (graphiteReporterConfig = config.getMetricReportingConfig().getGraphiteReporterConfig()) != null && graphiteReporterConfig.isEnableReporter()) {
            MonitoringCenter.initGraphiteReporter(graphiteReporterConfig);
            logger.info("Started GraphiteReporter: {}", (Object)graphiteReporterConfig.toString());
        }
        systemInfo = SystemInfo.create();
        nodeInfo = NodeInfo.create(namingConfig);
        appInfo = AppInfo.create(namingConfig.getApplicationName());
        if (config.getConfigFile() != null && config.getConfigFile().exists()) {
            ConfigFileUtil.createEffectiveConfigFile(config);
            executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("MonitoringCenter-%d").build());
            executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        MonitoringCenter.reloadConfig();
                    }
                    catch (Exception e) {
                        if (InterruptedException.class.isInstance(e)) {
                            Thread.currentThread().interrupt();
                        }
                        logger.error("Uncaught exception occurred while reloading the MonitoringCenter config", (Throwable)e);
                    }
                }
            }, 60L, 60L, TimeUnit.SECONDS);
        }
        logger.info("MonitoringCenter has been configured: {}", (Object)initialConfig.toString());
        configured.set(true);
    }

    protected static void reloadConfig() {
        if (!configured.get() || initialConfig.getConfigFile() == null) {
            return;
        }
        File effectiveConfigFile = new File(ConfigFileUtil.getEffectiveConfigFileFullPath(initialConfig));
        MonitoringCenterConfig newConfig = null;
        try {
            newConfig = Configurator.configFile(effectiveConfigFile).build();
        }
        catch (Exception e) {
            logger.error("Error while reloading MonitoringCenter config from {}", (Object)effectiveConfigFile.toString(), (Object)e);
            if (InterruptedException.class.isInstance(e)) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        MetricCollectionConfig newMetricCollectionConfig = newConfig.getMetricCollectionConfig();
        if (newMetricCollectionConfig != null) {
            MetricCollectionConfig oldMetricCollectionConfig = currentConfig.getMetricCollectionConfig();
            if (newMetricCollectionConfig.isEnableSystemMetrics()) {
                if (oldMetricCollectionConfig == null || !oldMetricCollectionConfig.isEnableSystemMetrics()) {
                    systemMetricSet = new SystemMetricSet();
                    metricRegistry.register(SYSTEM_METRIC_NAMESPACE, (Metric)systemMetricSet);
                }
            } else if (oldMetricCollectionConfig != null && oldMetricCollectionConfig.isEnableSystemMetrics() && systemMetricSet != null) {
                metricRegistry.removeMatching(new MetricFilter(){

                    public boolean matches(String name, Metric metric) {
                        return name.startsWith("system.");
                    }
                });
                systemMetricSet.shutdown();
                systemMetricSet = null;
            }
            if (newMetricCollectionConfig.isEnableTomcatMetrics()) {
                if (oldMetricCollectionConfig == null || !oldMetricCollectionConfig.isEnableTomcatMetrics()) {
                    tomcatMetricSet = new TomcatMetricSet();
                    metricRegistry.register(TOMCAT_METRIC_NAMESPACE, (Metric)tomcatMetricSet);
                }
            } else if (oldMetricCollectionConfig != null && oldMetricCollectionConfig.isEnableTomcatMetrics() && tomcatMetricSet != null) {
                metricRegistry.removeMatching(new MetricFilter(){

                    public boolean matches(String name, Metric metric) {
                        return name.startsWith("tomcat.");
                    }
                });
                tomcatMetricSet.shutdown();
                tomcatMetricSet = null;
            }
        }
        GraphiteReporterConfig oldGraphiteReporterConfig = null;
        if (currentConfig.getMetricReportingConfig() != null) {
            oldGraphiteReporterConfig = currentConfig.getMetricReportingConfig().getGraphiteReporterConfig();
        }
        GraphiteReporterConfig newGraphiteReporterConfig = null;
        if (newConfig.getMetricReportingConfig() != null) {
            newGraphiteReporterConfig = newConfig.getMetricReportingConfig().getGraphiteReporterConfig();
        }
        if (graphiteReporter != null && oldGraphiteReporterConfig != null && oldGraphiteReporterConfig.isEnableReporter()) {
            if (newGraphiteReporterConfig == null || !newGraphiteReporterConfig.equals(oldGraphiteReporterConfig)) {
                graphiteReporter.stop();
                graphiteReporter = null;
                if (newGraphiteReporterConfig != null && newGraphiteReporterConfig.isEnableReporter()) {
                    MonitoringCenter.initGraphiteReporter(newGraphiteReporterConfig);
                    logger.info("GraphiteReporter has been updated: {}", (Object)newGraphiteReporterConfig.toString());
                } else {
                    logger.info("GraphiteReporter has been turned off");
                }
            }
        } else if (newGraphiteReporterConfig != null && newGraphiteReporterConfig.isEnableReporter()) {
            MonitoringCenter.initGraphiteReporter(newGraphiteReporterConfig);
            logger.info("Started GraphiteReporter: {}", (Object)newGraphiteReporterConfig.toString());
        }
        currentConfig = newConfig;
    }

    private static void initGraphiteReporter(final GraphiteReporterConfig graphiteReporterConfig) {
        HostAndPort hostAndPort = graphiteReporterConfig.getAddress();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort());
        PickledGraphite graphiteSender = graphiteReporterConfig.isEnableBatching() ? new PickledGraphite(inetSocketAddress) : new Graphite(inetSocketAddress);
        graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MICROSECONDS).filter(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                boolean passedWhitelist = false;
                passedWhitelist = graphiteReporterConfig.getStartsWithFilters().isEmpty() ? true : MonitoringCenter.matchesStartsWithFilters(name, graphiteReporterConfig.getStartsWithFilters().toArray(new String[0]));
                if (!passedWhitelist) {
                    return false;
                }
                if (graphiteReporterConfig.getBlockedStartsWithFilters().isEmpty()) {
                    return true;
                }
                return !MonitoringCenter.matchesStartsWithFilters(name, graphiteReporterConfig.getBlockedStartsWithFilters().toArray(new String[0]));
            }
        }).build((GraphiteSender)graphiteSender);
        graphiteReporter.start(graphiteReporterConfig.getReportingIntervalInSeconds(), TimeUnit.SECONDS);
    }

    private static String normalizeHealthCheckName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name cannot be blank");
        String sanitizedName = MetricNamingUtil.sanitize(name);
        if (initialConfig.getNamingConfig() != null && initialConfig.getNamingConfig().isAppendTypeToHealthCheckNames() && !sanitizedName.endsWith(HEALTH_CHECK_POSTFIX)) {
            sanitizedName = sanitizedName + HEALTH_CHECK_POSTFIX;
        }
        return sanitizedName;
    }

    private static boolean matchesStartsWithFilters(String name, String[] startsWithFilters) {
        if (startsWithFilters == null || startsWithFilters.length == 0) {
            return true;
        }
        for (String startsWithFilter : startsWithFilters) {
            if (!MonitoringCenter.matchesStartsWithFilter(name, startsWithFilter)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesStartsWithFilter(String name, String startsWithFilter) {
        if ((startsWithFilter = StringUtils.trimToNull((String)startsWithFilter)) == null) {
            return true;
        }
        if (startsWithFilter.indexOf(42) == -1) {
            return name.startsWith(startsWithFilter);
        }
        if (!startsWithFilter.endsWith("*")) {
            startsWithFilter = startsWithFilter + "*";
        }
        String regex = ("\\Q" + startsWithFilter + "\\E").replace("*", "\\E.*\\Q");
        return name.matches(regex);
    }
}

