/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.forwarding;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.centro.rtb.monitoringcenter.metrics.forwarding.MetricProvider;

public class ForwardingReadOnlyTimer
extends Timer {
    private MetricProvider<Timer> metricProvider;

    public ForwardingReadOnlyTimer(final Timer delegate) {
        Preconditions.checkNotNull((Object)delegate);
        this.metricProvider = new MetricProvider<Timer>(){

            @Override
            public Timer get() {
                return delegate;
            }
        };
    }

    public ForwardingReadOnlyTimer(MetricProvider<Timer> metricProvider) {
        Preconditions.checkNotNull(metricProvider);
        this.metricProvider = metricProvider;
    }

    public void update(long duration, TimeUnit unit) {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only timer");
    }

    public <T> T time(Callable<T> event) throws Exception {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only timer");
    }

    public Timer.Context time() {
        throw new UnsupportedOperationException("Operation is not allowed for a read-only timer");
    }

    public long getCount() {
        return this.metricProvider.get().getCount();
    }

    public double getFifteenMinuteRate() {
        return this.metricProvider.get().getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.metricProvider.get().getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.metricProvider.get().getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.metricProvider.get().getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.metricProvider.get().getSnapshot();
    }
}

