/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.tomcat;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatExecutorStatus;
import net.centro.rtb.monitoringcenter.util.JmxUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
class TomcatExecutorMetricSet
implements MetricSet,
TomcatExecutorStatus {
    private String name;
    private Gauge<Integer> currentPoolSizeGauge;
    private Gauge<Integer> maxPoolSizeGauge;
    private Gauge<Integer> busyThreadsGauge;
    private Gauge<Integer> queueSizeGauge;
    private Gauge<Integer> queueCapacityGauge;
    private Map<String, Metric> metricsByNames;

    TomcatExecutorMetricSet(ObjectName executorObjectName) {
        Preconditions.checkNotNull((Object)executorObjectName);
        this.name = executorObjectName.getKeyProperty("name");
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        this.currentPoolSizeGauge = JmxUtil.getJmxAttributeAsGauge(executorObjectName, "poolSize", Integer.class, 0);
        if (this.currentPoolSizeGauge != null) {
            metricsByNames.put("currentPoolSize", (Metric)this.currentPoolSizeGauge);
        }
        this.maxPoolSizeGauge = JmxUtil.getJmxAttributeAsGauge(executorObjectName, "maxThreads", Integer.class, 0);
        if (this.maxPoolSizeGauge != null) {
            metricsByNames.put("maxPoolSize", (Metric)this.maxPoolSizeGauge);
        }
        this.busyThreadsGauge = JmxUtil.getJmxAttributeAsGauge(executorObjectName, "activeCount", Integer.class, 0);
        if (this.busyThreadsGauge != null) {
            metricsByNames.put("busyThreads", (Metric)this.busyThreadsGauge);
        }
        this.queueSizeGauge = JmxUtil.getJmxAttributeAsGauge(executorObjectName, "queueSize", Integer.class, 0);
        if (this.queueSizeGauge != null) {
            metricsByNames.put("queueSize", (Metric)this.queueSizeGauge);
        }
        this.queueCapacityGauge = JmxUtil.getJmxAttributeAsGauge(executorObjectName, "maxQueueSize", Integer.class, 0);
        if (this.queueCapacityGauge != null) {
            metricsByNames.put("queueCapacity", (Metric)this.queueCapacityGauge);
        }
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getCurrentPoolSizeGauge() {
        return this.currentPoolSizeGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getMaxPoolSizeGauge() {
        return this.maxPoolSizeGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getBusyThreadsGauge() {
        return this.busyThreadsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getQueueSizeGauge() {
        return this.queueSizeGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getQueueCapacityGauge() {
        return this.queueCapacityGauge;
    }
}

