/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.centro.rtb.monitoringcenter.metrics.system.SystemStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.JvmMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.JvmStatus;
import net.centro.rtb.monitoringcenter.metrics.system.os.OperatingSystemMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.os.OperatingSystemStatus;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class SystemMetricSet
implements MetricSet,
SystemStatus {
    private OperatingSystemMetricSet operatingSystemMetricSet;
    private JvmMetricSet jvmMetricSet;
    private Map<String, Metric> metricsByNames;
    private AtomicBoolean shutdown;

    public SystemMetricSet() {
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        this.operatingSystemMetricSet = new OperatingSystemMetricSet();
        metricsByNames.put("os", (Metric)this.operatingSystemMetricSet);
        this.jvmMetricSet = new JvmMetricSet();
        metricsByNames.put("jvm", (Metric)this.jvmMetricSet);
        this.metricsByNames = metricsByNames;
        this.shutdown = new AtomicBoolean(false);
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public OperatingSystemStatus getOperatingSystemStatus() {
        return this.operatingSystemMetricSet;
    }

    @Override
    @JsonProperty
    public JvmStatus getJvmStatus() {
        return this.jvmMetricSet;
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.operatingSystemMetricSet.shutdown();
        this.jvmMetricSet.shutdown();
    }
}

