/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryUsageProvider;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryUsageStatus;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
class JvmMemoryUsageMetricSet
implements MetricSet,
MemoryUsageStatus {
    private Gauge<Long> initialSizeInBytesGauge;
    private Gauge<Long> usedMemoryInBytesGauge;
    private Gauge<Long> maxAvailableMemoryInBytesGauge;
    private Gauge<Long> committedMemoryInBytesGauge;
    private Gauge<Double> usedMemoryPercentageGauge;
    private Map<String, Metric> metricsByNames;

    JvmMemoryUsageMetricSet(final MemoryUsageProvider memoryUsageProvider) {
        Preconditions.checkNotNull((Object)memoryUsageProvider);
        MemoryUsage memoryUsage = memoryUsageProvider.get();
        Preconditions.checkNotNull((Object)memoryUsage);
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        if (memoryUsage.getInit() >= 0L) {
            this.initialSizeInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return memoryUsageProvider.get().getInit();
                }
            };
            metricsByNames.put("initialInBytes", (Metric)this.initialSizeInBytesGauge);
        }
        this.usedMemoryInBytesGauge = new Gauge<Long>(){

            public Long getValue() {
                return memoryUsageProvider.get().getUsed();
            }
        };
        metricsByNames.put("usedInBytes", (Metric)this.usedMemoryInBytesGauge);
        if (memoryUsage.getMax() >= 0L) {
            this.maxAvailableMemoryInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return memoryUsageProvider.get().getMax();
                }
            };
            metricsByNames.put("maxAvailableInBytes", (Metric)this.maxAvailableMemoryInBytesGauge);
        }
        this.committedMemoryInBytesGauge = new Gauge<Long>(){

            public Long getValue() {
                return memoryUsageProvider.get().getCommitted();
            }
        };
        metricsByNames.put("committedInBytes", (Metric)this.committedMemoryInBytesGauge);
        this.usedMemoryPercentageGauge = new Gauge<Double>(){

            public Double getValue() {
                MemoryUsage memoryUsage = memoryUsageProvider.get();
                long max = memoryUsage.getMax() > 0L ? memoryUsage.getMax() : memoryUsage.getCommitted();
                return Double.valueOf(memoryUsage.getUsed()) / (double)max * 100.0;
            }
        };
        metricsByNames.put("usedPercentage", (Metric)this.usedMemoryPercentageGauge);
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public Gauge<Long> getInitialSizeInBytesGauge() {
        return this.initialSizeInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getUsedMemoryInBytesGauge() {
        return this.usedMemoryInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getMaxAvailableMemoryInBytesGauge() {
        return this.maxAvailableMemoryInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getCommittedMemoryInBytesGauge() {
        return this.committedMemoryInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getUsedMemoryPercentageGauge() {
        return this.usedMemoryPercentageGauge;
    }
}

