/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.JvmMemoryUsageMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryPoolStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryUsageProvider;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryUsageStatus;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;

class JvmMemoryMetricSet
implements MetricSet {
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
    private MemoryUsageStatus totalMemoryUsageStatus;
    private MemoryUsageStatus heapMemoryUsageStatus;
    private MemoryUsageStatus nonHeapMemoryUsageStatus;
    private List<MemoryPoolStatus> memoryPoolStatuses;
    private Map<String, Metric> metricsByNames;

    JvmMemoryMetricSet() {
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        String totalNamespace = "total";
        Gauge<Long> totalUsedMemoryInBytesGauge = new Gauge<Long>(){

            public Long getValue() {
                return JvmMemoryMetricSet.this.memoryMXBean.getHeapMemoryUsage().getUsed() + JvmMemoryMetricSet.this.memoryMXBean.getNonHeapMemoryUsage().getUsed();
            }
        };
        metricsByNames.put(MetricNamingUtil.join(totalNamespace, "usedInBytes"), (Metric)totalUsedMemoryInBytesGauge);
        Gauge<Long> totalCommittedMemoryInBytesGauge = new Gauge<Long>(){

            public Long getValue() {
                return JvmMemoryMetricSet.this.memoryMXBean.getHeapMemoryUsage().getCommitted() + JvmMemoryMetricSet.this.memoryMXBean.getNonHeapMemoryUsage().getCommitted();
            }
        };
        metricsByNames.put(MetricNamingUtil.join(totalNamespace, "committedInBytes"), (Metric)totalCommittedMemoryInBytesGauge);
        this.totalMemoryUsageStatus = new MemoryUsageStatus((Gauge)totalUsedMemoryInBytesGauge, (Gauge)totalCommittedMemoryInBytesGauge){
            final /* synthetic */ Gauge val$totalUsedMemoryInBytesGauge;
            final /* synthetic */ Gauge val$totalCommittedMemoryInBytesGauge;
            {
                this.val$totalUsedMemoryInBytesGauge = gauge;
                this.val$totalCommittedMemoryInBytesGauge = gauge2;
            }

            @Override
            public Gauge<Long> getInitialSizeInBytesGauge() {
                return null;
            }

            @Override
            public Gauge<Long> getUsedMemoryInBytesGauge() {
                return this.val$totalUsedMemoryInBytesGauge;
            }

            @Override
            public Gauge<Long> getMaxAvailableMemoryInBytesGauge() {
                return null;
            }

            @Override
            public Gauge<Long> getCommittedMemoryInBytesGauge() {
                return this.val$totalCommittedMemoryInBytesGauge;
            }

            @Override
            public Gauge<Double> getUsedMemoryPercentageGauge() {
                return null;
            }
        };
        JvmMemoryUsageMetricSet heapMemoryUsageMetricSet = new JvmMemoryUsageMetricSet(new MemoryUsageProvider(){

            @Override
            public MemoryUsage get() {
                return JvmMemoryMetricSet.this.memoryMXBean.getHeapMemoryUsage();
            }
        });
        metricsByNames.put("heap", (Metric)heapMemoryUsageMetricSet);
        this.heapMemoryUsageStatus = heapMemoryUsageMetricSet;
        JvmMemoryUsageMetricSet nonHeapMemoryUsageMetricSet = new JvmMemoryUsageMetricSet(new MemoryUsageProvider(){

            @Override
            public MemoryUsage get() {
                return JvmMemoryMetricSet.this.memoryMXBean.getNonHeapMemoryUsage();
            }
        });
        metricsByNames.put("nonHeap", (Metric)nonHeapMemoryUsageMetricSet);
        this.nonHeapMemoryUsageStatus = nonHeapMemoryUsageMetricSet;
        ArrayList<MemoryPoolStatus> memoryPoolStatuses = new ArrayList<MemoryPoolStatus>();
        for (final MemoryPoolMXBean pool : this.memoryPoolMXBeans) {
            Gauge<Long> usedAfterGcInBytesGauge;
            final String memoryPoolName = pool.getName();
            String poolNamespace = MetricNamingUtil.join("pools", MetricNamingUtil.sanitize(memoryPoolName));
            final JvmMemoryUsageMetricSet memoryUsageMetricSet = new JvmMemoryUsageMetricSet(new MemoryUsageProvider(){

                @Override
                public MemoryUsage get() {
                    return pool.getUsage();
                }
            });
            metricsByNames.put(poolNamespace, (Metric)memoryUsageMetricSet);
            if (pool.getCollectionUsage() != null) {
                usedAfterGcInBytesGauge = new Gauge<Long>(){

                    public Long getValue() {
                        return pool.getCollectionUsage().getUsed();
                    }
                };
                metricsByNames.put(MetricNamingUtil.join(poolNamespace, "usedAfterGcInBytes"), (Metric)usedAfterGcInBytesGauge);
            } else {
                usedAfterGcInBytesGauge = null;
            }
            memoryPoolStatuses.add(new MemoryPoolStatus((Gauge)usedAfterGcInBytesGauge){
                final /* synthetic */ Gauge val$usedAfterGcInBytesGauge;
                {
                    this.val$usedAfterGcInBytesGauge = gauge;
                }

                @Override
                public String getName() {
                    return memoryPoolName;
                }

                @Override
                public MemoryUsageStatus getMemoryUsageStatus() {
                    return memoryUsageMetricSet;
                }

                @Override
                public Gauge<Long> getUsedAfterGcInBytesGauge() {
                    return this.val$usedAfterGcInBytesGauge;
                }
            });
        }
        this.memoryPoolStatuses = memoryPoolStatuses;
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    public MemoryUsageStatus getTotalMemoryUsageStatus() {
        return this.totalMemoryUsageStatus;
    }

    public MemoryUsageStatus getHeapMemoryUsageStatus() {
        return this.heapMemoryUsageStatus;
    }

    public MemoryUsageStatus getNonHeapMemoryUsageStatus() {
        return this.nonHeapMemoryUsageStatus;
    }

    public List<MemoryPoolStatus> getMemoryPoolStatuses() {
        return Collections.unmodifiableList(this.memoryPoolStatuses);
    }
}

