/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.BufferPoolStatus;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
class BufferPoolMetricSet
implements MetricSet {
    private List<BufferPoolMXBean> bufferPoolMXBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    private List<BufferPoolStatus> bufferPoolStatuses;
    private Map<String, Metric> metricsByNames;

    BufferPoolMetricSet() {
        ArrayList<BufferPoolStatus> bufferPoolStatuses = new ArrayList<BufferPoolStatus>();
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        for (final BufferPoolMXBean bufferPoolMXBean : this.bufferPoolMXBeans) {
            Gauge<Long> usedMemoryInBytesGauge;
            final String bufferPoolName = bufferPoolMXBean.getName();
            Gauge<Long> sizeGauge = new Gauge<Long>(){

                public Long getValue() {
                    return bufferPoolMXBean.getCount();
                }
            };
            metricsByNames.put(MetricNamingUtil.join(bufferPoolName, "size"), (Metric)sizeGauge);
            Gauge<Long> totalCapacityInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return bufferPoolMXBean.getTotalCapacity();
                }
            };
            metricsByNames.put(MetricNamingUtil.join(bufferPoolName, "totalCapacityInBytes"), (Metric)totalCapacityInBytesGauge);
            if (bufferPoolMXBean.getMemoryUsed() >= 0L) {
                usedMemoryInBytesGauge = new Gauge<Long>(){

                    public Long getValue() {
                        return bufferPoolMXBean.getMemoryUsed();
                    }
                };
                metricsByNames.put(MetricNamingUtil.join(bufferPoolName, "usedMemoryInBytes"), (Metric)usedMemoryInBytesGauge);
            } else {
                usedMemoryInBytesGauge = null;
            }
            bufferPoolStatuses.add(new BufferPoolStatus((Gauge)sizeGauge, (Gauge)totalCapacityInBytesGauge, (Gauge)usedMemoryInBytesGauge){
                final /* synthetic */ Gauge val$sizeGauge;
                final /* synthetic */ Gauge val$totalCapacityInBytesGauge;
                final /* synthetic */ Gauge val$usedMemoryInBytesGauge;
                {
                    this.val$sizeGauge = gauge;
                    this.val$totalCapacityInBytesGauge = gauge2;
                    this.val$usedMemoryInBytesGauge = gauge3;
                }

                @Override
                public String getName() {
                    return bufferPoolName;
                }

                @Override
                public Gauge<Long> getSizeGauge() {
                    return this.val$sizeGauge;
                }

                @Override
                public Gauge<Long> getTotalCapacityInBytesGauge() {
                    return this.val$totalCapacityInBytesGauge;
                }

                @Override
                public Gauge<Long> getUsedMemoryInBytesGauge() {
                    return this.val$usedMemoryInBytesGauge;
                }
            });
        }
        this.bufferPoolStatuses = bufferPoolStatuses;
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @JsonProperty
    List<BufferPoolStatus> getBufferPoolStatuses() {
        return Collections.unmodifiableList(this.bufferPoolStatuses);
    }
}

