/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.centro.rtb.monitoringcenter.config.GraphiteReporterConfig;
import net.centro.rtb.monitoringcenter.config.HostAndPort;
import net.centro.rtb.monitoringcenter.config.MetricCollectionConfig;
import net.centro.rtb.monitoringcenter.config.MetricNamePostfixPolicy;
import net.centro.rtb.monitoringcenter.config.MetricReportingConfig;
import net.centro.rtb.monitoringcenter.config.MonitoringCenterConfig;
import net.centro.rtb.monitoringcenter.config.NamingConfig;
import net.centro.rtb.monitoringcenter.config.dto.GraphiteReporterConfigDto;
import net.centro.rtb.monitoringcenter.config.dto.MetricCollectionConfigDto;
import net.centro.rtb.monitoringcenter.config.dto.MetricNamePostfixPolicyDto;
import net.centro.rtb.monitoringcenter.config.dto.MetricReportingConfigDto;
import net.centro.rtb.monitoringcenter.config.dto.MonitoringCenterConfigDto;
import net.centro.rtb.monitoringcenter.config.dto.NamingConfigDto;
import net.centro.rtb.monitoringcenter.util.ConfigException;

public class ConfigFileUtil {
    private static final String EFFECTIVE_CONFIG_FILE_NAME_TEMPLATE = "monitoringCenter-%s-current.yaml";
    private static ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    private ConfigFileUtil() {
    }

    public static void createEffectiveConfigFile(MonitoringCenterConfig config) {
        MetricReportingConfig metricReportingConfig;
        MetricCollectionConfig metricCollectionConfig;
        MonitoringCenterConfigDto configDto = new MonitoringCenterConfigDto();
        NamingConfig namingConfig = config.getNamingConfig();
        if (namingConfig != null) {
            NamingConfigDto namingConfigDto = new NamingConfigDto();
            namingConfigDto.setApplicationName(namingConfig.getApplicationName());
            namingConfigDto.setDatacenterName(namingConfig.getDatacenterName());
            namingConfigDto.setNodeGroupName(namingConfig.getNodeGroupName());
            namingConfigDto.setNodeId(namingConfig.getNodeId());
            namingConfigDto.setMetricNamePostfixPolicy(ConfigFileUtil.convertMetricNamePostfixPolicyToDto(namingConfig.getMetricNamePostfixPolicy()));
            namingConfigDto.setAppendTypeToHealthCheckNames(namingConfig.getAppendTypeToHealthCheckNames());
            configDto.setNamingConfig(namingConfigDto);
        }
        if ((metricCollectionConfig = config.getMetricCollectionConfig()) != null) {
            MetricCollectionConfigDto metricCollectionConfigDto = new MetricCollectionConfigDto();
            metricCollectionConfigDto.setEnableSystemMetrics(metricCollectionConfig.getEnableSystemMetrics());
            metricCollectionConfigDto.setEnableTomcatMetrics(metricCollectionConfig.getEnableTomcatMetrics());
            configDto.setMetricCollectionConfig(metricCollectionConfigDto);
        }
        if ((metricReportingConfig = config.getMetricReportingConfig()) != null) {
            MetricReportingConfigDto metricReportingConfigDto = new MetricReportingConfigDto();
            GraphiteReporterConfig graphiteReporterConfig = metricReportingConfig.getGraphiteReporterConfig();
            if (graphiteReporterConfig != null) {
                GraphiteReporterConfigDto graphiteReporterConfigDto = new GraphiteReporterConfigDto();
                graphiteReporterConfigDto.setEnableReporter(graphiteReporterConfig.getEnableReporter());
                graphiteReporterConfigDto.setAddress(graphiteReporterConfig.getAddress());
                graphiteReporterConfigDto.setEnableBatching(graphiteReporterConfig.getEnableBatching());
                graphiteReporterConfigDto.setReportingIntervalInSeconds(graphiteReporterConfig.getReportingIntervalInSeconds());
                graphiteReporterConfigDto.setStartsWithFilters(graphiteReporterConfig.getStartsWithFilters());
                graphiteReporterConfigDto.setBlockedStartsWithFilters(graphiteReporterConfig.getBlockedStartsWithFilters());
                metricReportingConfigDto.setGraphiteReporterConfig(graphiteReporterConfigDto);
            }
            configDto.setMetricReportingConfig(metricReportingConfigDto);
        }
        String effectiveConfigFileFullPath = ConfigFileUtil.getEffectiveConfigFileFullPath(config);
        try {
            objectMapper.writeValue(new File(effectiveConfigFileFullPath), (Object)configDto);
        }
        catch (IOException e) {
            throw new ConfigException("Could not create the effective config file: " + effectiveConfigFileFullPath, e);
        }
    }

    public static String getEffectiveConfigFileFullPath(MonitoringCenterConfig config) {
        String directory = config.getConfigFile().getParent();
        String fileName = String.format(EFFECTIVE_CONFIG_FILE_NAME_TEMPLATE, config.getNamingConfig() != null ? config.getNamingConfig().getApplicationName() : null);
        return directory + "/" + fileName;
    }

    public static void fillConfigBuilderFromFile(File configFile, MonitoringCenterConfig.Builder configBuilder) {
        MonitoringCenterConfigDto configFromFile = null;
        if (configFile != null && configFile.exists()) {
            try {
                configFromFile = (MonitoringCenterConfigDto)objectMapper.readValue(configFile, MonitoringCenterConfigDto.class);
            }
            catch (IOException e) {
                throw new ConfigException("Could not process config file: " + configFile.toString(), e);
            }
        }
        if (configFromFile != null) {
            GraphiteReporterConfigDto graphiteReporterConfigFromFile;
            MetricReportingConfigDto reportingConfigFromFile;
            MetricCollectionConfigDto collectionConfigFromFile;
            NamingConfigDto namingConfigFromFile = configFromFile.getNamingConfig();
            if (namingConfigFromFile != null) {
                if (namingConfigFromFile.getApplicationName() != null) {
                    configBuilder.applicationName(namingConfigFromFile.getApplicationName());
                }
                configBuilder.datacenterName(namingConfigFromFile.getDatacenterName());
                configBuilder.nodeGroupName(namingConfigFromFile.getNodeGroupName());
                configBuilder.nodeId(namingConfigFromFile.getNodeId());
                if (namingConfigFromFile.getMetricNamePostfixPolicy() != null && namingConfigFromFile.getMetricNamePostfixPolicy() != MetricNamePostfixPolicyDto.UNKNOWN) {
                    configBuilder.metricNamePostfixPolicy(ConfigFileUtil.convertMetricNamePostfixPolicyToEntity(namingConfigFromFile.getMetricNamePostfixPolicy()));
                }
                if (namingConfigFromFile.getAppendTypeToHealthCheckNames() != null) {
                    configBuilder.appendTypeToHealthCheckNames(namingConfigFromFile.getAppendTypeToHealthCheckNames());
                }
            }
            if ((collectionConfigFromFile = configFromFile.getMetricCollectionConfig()) != null) {
                if (collectionConfigFromFile.getEnableSystemMetrics() != null) {
                    configBuilder.enableSystemMetrics(collectionConfigFromFile.getEnableSystemMetrics());
                }
                if (collectionConfigFromFile.getEnableTomcatMetrics() != null) {
                    configBuilder.enableTomcatMetrics(collectionConfigFromFile.getEnableTomcatMetrics());
                }
            }
            if ((reportingConfigFromFile = configFromFile.getMetricReportingConfig()) != null && (graphiteReporterConfigFromFile = reportingConfigFromFile.getGraphiteReporterConfig()) != null) {
                HostAndPort address;
                GraphiteReporterConfig.Builder graphiteReporterConfigBuilder = GraphiteReporterConfig.builder();
                if (graphiteReporterConfigFromFile.getEnableReporter() != null) {
                    graphiteReporterConfigBuilder.enableReporter(graphiteReporterConfigFromFile.getEnableReporter());
                }
                if (graphiteReporterConfigFromFile.getEnableBatching() != null) {
                    graphiteReporterConfigBuilder.enableBatching(graphiteReporterConfigFromFile.getEnableBatching());
                }
                if (graphiteReporterConfigFromFile.getReportingIntervalInSeconds() != null) {
                    graphiteReporterConfigBuilder.reportingInterval(graphiteReporterConfigFromFile.getReportingIntervalInSeconds(), TimeUnit.SECONDS);
                }
                if ((address = graphiteReporterConfigFromFile.getAddress()) != null) {
                    graphiteReporterConfigBuilder.address(address.getHost(), address.getPort());
                }
                if (graphiteReporterConfigFromFile.getStartsWithFilters() != null) {
                    graphiteReporterConfigBuilder.startsWithFilters(graphiteReporterConfigFromFile.getStartsWithFilters());
                }
                if (graphiteReporterConfigFromFile.getBlockedStartsWithFilters() != null) {
                    graphiteReporterConfigBuilder.blockedStartsWithFilters(graphiteReporterConfigFromFile.getBlockedStartsWithFilters());
                }
                configBuilder.graphiteReporterConfig(graphiteReporterConfigBuilder.build());
            }
        }
    }

    private static MetricNamePostfixPolicyDto convertMetricNamePostfixPolicyToDto(MetricNamePostfixPolicy entity) {
        if (entity == MetricNamePostfixPolicy.ADD_ALL_TYPES) {
            return MetricNamePostfixPolicyDto.ADD_ALL_TYPES;
        }
        if (entity == MetricNamePostfixPolicy.ADD_COMPOSITE_TYPES) {
            return MetricNamePostfixPolicyDto.ADD_COMPOSITE_TYPES;
        }
        if (entity == MetricNamePostfixPolicy.OFF) {
            return MetricNamePostfixPolicyDto.OFF;
        }
        return MetricNamePostfixPolicyDto.UNKNOWN;
    }

    private static MetricNamePostfixPolicy convertMetricNamePostfixPolicyToEntity(MetricNamePostfixPolicyDto dto) {
        if (dto == MetricNamePostfixPolicyDto.ADD_ALL_TYPES) {
            return MetricNamePostfixPolicy.ADD_ALL_TYPES;
        }
        if (dto == MetricNamePostfixPolicyDto.ADD_COMPOSITE_TYPES) {
            return MetricNamePostfixPolicy.ADD_COMPOSITE_TYPES;
        }
        if (dto == MetricNamePostfixPolicyDto.OFF) {
            return MetricNamePostfixPolicy.OFF;
        }
        return null;
    }
}

