/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.tomcat;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatConnectorMetricSet;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatConnectorStatus;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatExecutorMetricSet;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatExecutorStatus;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatStatus;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class TomcatMetricSet
implements MetricSet,
TomcatStatus {
    private static final Logger logger = LoggerFactory.getLogger(TomcatMetricSet.class);
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private Map<String, Metric> metricsByNames;
    private ScheduledExecutorService executorService;
    private List<TomcatExecutorStatus> executorStatuses;
    private List<TomcatConnectorStatus> connectorStatuses;
    private AtomicBoolean shutdown;

    public TomcatMetricSet() {
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        ArrayList<TomcatExecutorStatus> executorStatuses = new ArrayList<TomcatExecutorStatus>();
        Set<ObjectName> executorObjectNames = null;
        try {
            executorObjectNames = this.mBeanServer.queryNames(new ObjectName("Catalina:type=Executor,*"), null);
        }
        catch (MalformedObjectNameException e) {
            logger.debug("Invalid ObjectName defined for the Tomcat's Executor MxBean", (Throwable)e);
        }
        if (executorObjectNames != null && !executorObjectNames.isEmpty()) {
            for (ObjectName executorObjectName : executorObjectNames) {
                TomcatExecutorMetricSet executorMetricSet = new TomcatExecutorMetricSet(executorObjectName);
                if (!executorMetricSet.getMetrics().isEmpty()) {
                    metricsByNames.put(MetricNamingUtil.join("executors", executorMetricSet.getName()), (Metric)executorMetricSet);
                }
                executorStatuses.add(executorMetricSet);
            }
        }
        this.executorStatuses = executorStatuses;
        final ArrayList<TomcatConnectorMetricSet> connectorMetricSets = new ArrayList<TomcatConnectorMetricSet>();
        ArrayList<TomcatConnectorStatus> connectorStatuses = new ArrayList<TomcatConnectorStatus>();
        Set<ObjectName> threadPoolObjectNames = null;
        try {
            threadPoolObjectNames = this.mBeanServer.queryNames(new ObjectName("Catalina:type=ThreadPool,*"), null);
        }
        catch (MalformedObjectNameException e) {
            logger.debug("Invalid ObjectName defined for the Tomcat's ThreadPool MxBean", (Throwable)e);
        }
        if (threadPoolObjectNames != null && !threadPoolObjectNames.isEmpty()) {
            for (ObjectName threadPoolObjectName : threadPoolObjectNames) {
                TomcatConnectorMetricSet connectorMetricSet = new TomcatConnectorMetricSet(threadPoolObjectName);
                if (!connectorMetricSet.getMetrics().isEmpty()) {
                    metricsByNames.put(MetricNamingUtil.join("connectors", connectorMetricSet.getName()), (Metric)connectorMetricSet);
                    connectorMetricSets.add(connectorMetricSet);
                }
                connectorStatuses.add(connectorMetricSet);
            }
        }
        this.connectorStatuses = connectorStatuses;
        if (!connectorMetricSets.isEmpty()) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TomcatMetricSet-%d").build());
            this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (TomcatConnectorMetricSet connectorMetricSet : connectorMetricSets) {
                        try {
                            connectorMetricSet.updateQps();
                        }
                        catch (Exception e) {
                            logger.debug("Error while updating QPS for connector {}", (Object)connectorMetricSet.getName(), (Object)e);
                        }
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
        this.metricsByNames = metricsByNames;
        this.shutdown = new AtomicBoolean(false);
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public List<TomcatExecutorStatus> getExecutorStatuses() {
        return Collections.unmodifiableList(this.executorStatuses);
    }

    @Override
    @JsonProperty
    public List<TomcatConnectorStatus> getConnectorStatuses() {
        return Collections.unmodifiableList(this.connectorStatuses);
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        if (this.executorService != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

