/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.forwarding;

import com.codahale.metrics.Meter;
import com.google.common.base.Preconditions;
import net.centro.rtb.monitoringcenter.metrics.forwarding.MetricProvider;

public class CompositeForwardingMeter
extends Meter {
    private Meter mainDelegate;
    private MetricProvider<Meter> supplementaryMetricProvider;

    public CompositeForwardingMeter(Meter mainDelegate, MetricProvider<Meter> supplementaryMetricProvider) {
        Preconditions.checkNotNull((Object)mainDelegate);
        Preconditions.checkNotNull(supplementaryMetricProvider);
        this.mainDelegate = mainDelegate;
        this.supplementaryMetricProvider = supplementaryMetricProvider;
    }

    public double getOneMinuteRate() {
        return this.mainDelegate.getOneMinuteRate();
    }

    public double getMeanRate() {
        return this.mainDelegate.getMeanRate();
    }

    public double getFiveMinuteRate() {
        return this.mainDelegate.getFiveMinuteRate();
    }

    public double getFifteenMinuteRate() {
        return this.mainDelegate.getFifteenMinuteRate();
    }

    public long getCount() {
        return this.mainDelegate.getCount();
    }

    public void mark(long n) {
        this.mainDelegate.mark(n);
        this.supplementaryMetricProvider.get().mark(n);
    }

    public void mark() {
        this.mainDelegate.mark();
        this.supplementaryMetricProvider.get().mark();
    }
}

