/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.forwarding;

import com.codahale.metrics.Counter;
import com.google.common.base.Preconditions;
import net.centro.rtb.monitoringcenter.metrics.forwarding.MetricProvider;

public class CompositeForwardingCounter
extends Counter {
    private Counter mainDelegate;
    private MetricProvider<Counter> supplementaryMetricProvider;

    public CompositeForwardingCounter(Counter mainDelegate, MetricProvider<Counter> supplementaryMetricProvider) {
        Preconditions.checkNotNull((Object)mainDelegate);
        Preconditions.checkNotNull(supplementaryMetricProvider);
        this.mainDelegate = mainDelegate;
        this.supplementaryMetricProvider = supplementaryMetricProvider;
    }

    public void inc() {
        this.mainDelegate.inc();
        this.supplementaryMetricProvider.get().inc();
    }

    public void inc(long n) {
        this.mainDelegate.inc(n);
        this.supplementaryMetricProvider.get().inc(n);
    }

    public void dec() {
        this.mainDelegate.dec();
        this.supplementaryMetricProvider.get().dec();
    }

    public void dec(long n) {
        this.mainDelegate.dec(n);
        this.supplementaryMetricProvider.get().dec(n);
    }

    public long getCount() {
        return this.mainDelegate.getCount();
    }
}

