/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.infos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatingSystemInfo {
    private static final Logger logger = LoggerFactory.getLogger(OperatingSystemInfo.class);
    private static final List<Pattern> LINUX_DISTRIBUTION_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("PRETTY_NAME=\"(.+)\""), Pattern.compile("DISTRIB_DESCRIPTION=\"(.+)\"")));
    private String name;
    private String version;
    private String distributionName;
    private String architecture;
    private int numberOfLogicalProcessors;
    private long physicalMemorySizeInBytes;
    private long swapSpaceSizeInBytes;
    private Map<String, Long> diskSpaceInBytesByRootPaths;

    private OperatingSystemInfo() {
    }

    public static OperatingSystemInfo create() {
        OperatingSystemInfo operatingSystemInfo = new OperatingSystemInfo();
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        operatingSystemInfo.name = operatingSystemMXBean.getName();
        operatingSystemInfo.version = operatingSystemMXBean.getVersion();
        if (SystemUtils.IS_OS_LINUX) {
            operatingSystemInfo.distributionName = OperatingSystemInfo.resolveLinuxDistributionName();
        }
        operatingSystemInfo.architecture = operatingSystemMXBean.getArch();
        operatingSystemInfo.numberOfLogicalProcessors = operatingSystemMXBean.getAvailableProcessors();
        if (OperatingSystemMXBean.class.isAssignableFrom(operatingSystemMXBean.getClass())) {
            OperatingSystemMXBean sunOsMxBean = (OperatingSystemMXBean)OperatingSystemMXBean.class.cast(operatingSystemMXBean);
            operatingSystemInfo.physicalMemorySizeInBytes = sunOsMxBean.getTotalPhysicalMemorySize();
            operatingSystemInfo.swapSpaceSizeInBytes = sunOsMxBean.getTotalSwapSpaceSize();
        }
        HashMap<String, Long> diskSpaceInBytesByRootPaths = new HashMap<String, Long>();
        for (File rootFile : File.listRoots()) {
            diskSpaceInBytesByRootPaths.put(rootFile.getAbsolutePath(), rootFile.getTotalSpace());
        }
        operatingSystemInfo.diskSpaceInBytesByRootPaths = diskSpaceInBytesByRootPaths;
        return operatingSystemInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public int getNumberOfLogicalProcessors() {
        return this.numberOfLogicalProcessors;
    }

    public long getPhysicalMemorySizeInBytes() {
        return this.physicalMemorySizeInBytes;
    }

    public long getSwapSpaceSizeInBytes() {
        return this.swapSpaceSizeInBytes;
    }

    public Map<String, Long> getDiskSpaceInBytesByRootPaths() {
        return Collections.unmodifiableMap(this.diskSpaceInBytesByRootPaths);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resolveLinuxDistributionName() {
        File etcDirectory = new File("/etc/");
        if (!etcDirectory.exists()) return null;
        if (!etcDirectory.isDirectory()) return null;
        File[] releaseFiles = etcDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith("-release");
            }
        });
        if (releaseFiles == null) return null;
        File[] fileArray = releaseFiles;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    for (Pattern pattern : LINUX_DISTRIBUTION_PATTERNS) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String string = matcher.group(1);
                        return string;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Error while reading a Linux release file: {}", (Object)file.getAbsolutePath(), (Object)e);
            }
            ++n2;
        }
        return null;
    }
}

