/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URL;
import net.centro.rtb.monitoringcenter.config.MonitoringCenterConfig;
import net.centro.rtb.monitoringcenter.util.ConfigException;
import net.centro.rtb.monitoringcenter.util.ConfigFileUtil;

public class Configurator {
    public static final String DEFAULT_CONFIG_FILE_NAME = "monitoringCenter.yaml";

    public static MonitoringCenterConfig.Builder configFile(File configFile) {
        Preconditions.checkNotNull((Object)configFile, (Object)"configFile cannot be null");
        Preconditions.checkArgument((boolean)configFile.exists(), (Object)("configFile " + configFile.toString() + " does not exist"));
        MonitoringCenterConfig.Builder configBuilder = MonitoringCenterConfig.builder(configFile);
        ConfigFileUtil.fillConfigBuilderFromFile(configFile, configBuilder);
        return configBuilder;
    }

    public static MonitoringCenterConfig.Builder noConfigFile() {
        return MonitoringCenterConfig.builder();
    }

    public static MonitoringCenterConfig.Builder defaultConfigFile() {
        URL configFileResource = Configurator.class.getClassLoader().getResource(DEFAULT_CONFIG_FILE_NAME);
        if (configFileResource == null) {
            throw new ConfigException("Default config file monitoringCenter.yaml was not found on the classpath");
        }
        File defaultConfigFile = new File(configFileResource.getFile());
        return Configurator.configFile(defaultConfigFile);
    }
}

