/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.mchange.v2.c3p0.PooledDataSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.sql.DataSource;
import net.centro.rtb.monitoringcenter.MetricCollector;
import net.centro.rtb.monitoringcenter.config.MetricNamePostfixPolicy;
import net.centro.rtb.monitoringcenter.config.NamingConfig;
import net.centro.rtb.monitoringcenter.metrics.C3P0PooledDataSourceMetricSet;
import net.centro.rtb.monitoringcenter.metrics.GuavaCacheMetricSet;
import net.centro.rtb.monitoringcenter.metrics.instrumented.InstrumentedDataSource;
import net.centro.rtb.monitoringcenter.metrics.instrumented.InstrumentedExecutorService;
import net.centro.rtb.monitoringcenter.metrics.instrumented.InstrumentedScheduledExecutorService;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;
import org.apache.commons.lang3.StringUtils;

class MetricCollectorImpl
implements MetricCollector {
    private static final String COUNTER_POSTFIX = "Counter";
    private static final String TIMER_POSTFIX = "Timer";
    private static final String METER_POSTFIX = "Meter";
    private static final String HISTOGRAM_POSTFIX = "Histogram";
    private static final String GAUGE_POSTFIX = "Gauge";
    private static final Set<String> COMPOSITE_TYPE_POSTFIXES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(MetricCollectorImpl.TIMER_POSTFIX);
            this.add(MetricCollectorImpl.METER_POSTFIX);
            this.add(MetricCollectorImpl.HISTOGRAM_POSTFIX);
        }
    });
    private MetricRegistry metricRegistry;
    private NamingConfig namingConfig;
    private String collectorNamespace;

    MetricCollectorImpl(MetricRegistry metricRegistry, NamingConfig namingConfig, String collectorNamespace) {
        Preconditions.checkNotNull((Object)metricRegistry);
        Preconditions.checkNotNull((Object)namingConfig);
        Preconditions.checkNotNull((Object)collectorNamespace);
        this.metricRegistry = metricRegistry;
        this.namingConfig = namingConfig;
        this.collectorNamespace = collectorNamespace;
    }

    @Override
    public Counter getCounter(String topLevelName, String ... additionalNames) {
        return this.metricRegistry.counter(this.buildFullName(topLevelName, additionalNames, COUNTER_POSTFIX));
    }

    @Override
    public Timer getTimer(String topLevelName, String ... additionalNames) {
        return this.metricRegistry.timer(this.buildFullName(topLevelName, additionalNames, TIMER_POSTFIX));
    }

    @Override
    public Meter getMeter(String topLevelName, String ... additionalNames) {
        return this.metricRegistry.meter(this.buildFullName(topLevelName, additionalNames, METER_POSTFIX));
    }

    @Override
    public Histogram getHistogram(String topLevelName, String ... additionalNames) {
        return this.metricRegistry.histogram(this.buildFullName(topLevelName, additionalNames, HISTOGRAM_POSTFIX));
    }

    @Override
    public <T> void registerGauge(Gauge<T> gauge, String topLevelName, String ... additionalNames) {
        Preconditions.checkNotNull(gauge, (Object)"gauge cannot be null");
        this.metricRegistry.register(this.buildFullName(topLevelName, additionalNames, GAUGE_POSTFIX), gauge);
    }

    @Override
    public void registerMetric(Metric metric, String topLevelName, String ... additionalNames) {
        Preconditions.checkNotNull((Object)metric, (Object)"metric cannot be null");
        if (MetricSet.class.isAssignableFrom(metric.getClass())) {
            if (StringUtils.isNotBlank((CharSequence)topLevelName)) {
                this.registerMetricSet((MetricSet)MetricSet.class.cast(metric), MetricNamingUtil.join(topLevelName, additionalNames));
            } else {
                this.registerMetricSet((MetricSet)MetricSet.class.cast(metric), new String[0]);
            }
        } else {
            this.metricRegistry.register(this.buildFullName(topLevelName, additionalNames, this.getPostfixForMetric(metric)), metric);
        }
    }

    @Override
    public void registerMetricSet(MetricSet metricSet, String ... names) {
        Preconditions.checkNotNull((Object)metricSet, (Object)"metricSet cannot be null");
        String namespace = null;
        if (names != null && names.length > 0) {
            namespace = this.buildFullName(names[0], Arrays.copyOfRange(names, 1, names.length), null);
        }
        this.registerMetricSetImpl(metricSet, namespace);
    }

    @Override
    public void removeAll() {
        this.metricRegistry.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return name.startsWith(MetricCollectorImpl.this.collectorNamespace + ".");
            }
        });
    }

    @Override
    public void removeMetric(Metric metric, String topLevelName, String ... additionalNames) {
        Preconditions.checkNotNull((Object)metric, (Object)"metric cannot be null");
        if (MetricSet.class.isAssignableFrom(metric.getClass())) {
            if (StringUtils.isNotBlank((CharSequence)topLevelName)) {
                this.removeMetricSet((MetricSet)MetricSet.class.cast(metric), MetricNamingUtil.join(topLevelName, additionalNames));
            } else {
                this.removeMetricSet((MetricSet)MetricSet.class.cast(metric), new String[0]);
            }
        } else {
            this.metricRegistry.remove(this.buildFullName(topLevelName, additionalNames, this.getPostfixForMetric(metric)));
        }
    }

    @Override
    public void removeMetricSet(MetricSet metricSet, String ... names) {
        Preconditions.checkNotNull((Object)metricSet, (Object)"metricSet cannot be null");
        String namespace = null;
        if (names != null && names.length > 0) {
            namespace = this.buildFullName(names[0], Arrays.copyOfRange(names, 1, names.length), null);
        }
        this.removeMetricSetImpl(metricSet, namespace);
    }

    @Override
    public void replaceMetric(Metric metric, String topLevelName, String ... additionalNames) {
        this.removeMetric(metric, topLevelName, additionalNames);
        this.registerMetric(metric, topLevelName, additionalNames);
    }

    @Override
    public void registerCollection(final Collection<?> collection, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(collection, "collection", topLevelName);
        String queueNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        this.registerGauge(new Gauge<Integer>(){

            public Integer getValue() {
                return collection.size();
            }
        }, MetricNamingUtil.join(queueNamespace, "size"), new String[0]);
    }

    @Override
    public void registerMap(final Map<?, ?> map, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(map, "map", topLevelName);
        String queueNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        this.registerGauge(new Gauge<Integer>(){

            public Integer getValue() {
                return map.size();
            }
        }, MetricNamingUtil.join(queueNamespace, "size"), new String[0]);
    }

    @Override
    public void registerGuavaCache(Cache<?, ?> cache, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(cache, "cache", topLevelName);
        this.registerMetricSet(new GuavaCacheMetricSet(cache), MetricNamingUtil.join(topLevelName, additionalNames));
    }

    @Override
    public void registerC3P0DataSource(PooledDataSource pooledDataSource, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(pooledDataSource, "pooledDataSource", topLevelName);
        String dataSourceNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        this.registerMetricSet(new C3P0PooledDataSourceMetricSet(pooledDataSource), dataSourceNamespace);
    }

    @Override
    public <T> BlockingQueue<T> instrumentBlockingQueue(final BlockingQueue<T> blockingQueue, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(blockingQueue, "blockingQueue", topLevelName);
        String queueNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        this.registerGauge(new Gauge<Integer>(){

            public Integer getValue() {
                return blockingQueue.size();
            }
        }, MetricNamingUtil.join(queueNamespace, "size"), new String[0]);
        this.registerGauge(new Gauge<Integer>(){

            public Integer getValue() {
                return blockingQueue.remainingCapacity();
            }
        }, MetricNamingUtil.join(queueNamespace, "remainingCapacity"), new String[0]);
        return blockingQueue;
    }

    @Override
    public ExecutorService instrumentExecutorService(ExecutorService executorService, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(executorService, "executorService", topLevelName);
        String executorServiceNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        return new InstrumentedExecutorService(executorService, this, executorServiceNamespace);
    }

    @Override
    public ScheduledExecutorService instrumentScheduledExecutorService(ScheduledExecutorService scheduledExecutorService, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(scheduledExecutorService, "scheduledExecutorService", topLevelName);
        String executorServiceNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        return new InstrumentedScheduledExecutorService(scheduledExecutorService, this, executorServiceNamespace);
    }

    @Override
    public DataSource instrumentDataSource(DataSource dataSource, String topLevelName, String ... additionalNames) {
        this.validateInstrumentationInputParams(dataSource, "dataSource", topLevelName);
        String dataSourceNamespace = MetricNamingUtil.join(topLevelName, additionalNames);
        return new InstrumentedDataSource(dataSource, this, dataSourceNamespace);
    }

    private void registerMetricSetImpl(MetricSet metricSet, String namespace) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() == null) continue;
            if (MetricSet.class.isInstance(entry.getValue())) {
                MetricSet innerMetricSet = (MetricSet)MetricSet.class.cast(entry.getValue());
                if (namespace == null) {
                    this.registerMetricSet(innerMetricSet, (String)entry.getKey());
                    continue;
                }
                this.registerMetricSetImpl(innerMetricSet, MetricNamingUtil.join(namespace, (String)entry.getKey()));
                continue;
            }
            String name = null;
            name = namespace == null ? (String)entry.getKey() : MetricNamingUtil.join(namespace, (String)entry.getKey());
            name = this.addPostfixIfNeeded(name, this.getPostfixForMetric((Metric)entry.getValue()));
            this.metricRegistry.register(name, (Metric)entry.getValue());
        }
    }

    private void removeMetricSetImpl(MetricSet metricSet, String namespace) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() == null) continue;
            if (MetricSet.class.isInstance(entry.getValue())) {
                MetricSet innerMetricSet = (MetricSet)MetricSet.class.cast(entry.getValue());
                if (namespace == null) {
                    this.removeMetricSet(innerMetricSet, (String)entry.getKey());
                    continue;
                }
                this.removeMetricSetImpl(innerMetricSet, MetricNamingUtil.join(namespace, (String)entry.getKey()));
                continue;
            }
            String name = null;
            name = namespace == null ? (String)entry.getKey() : MetricNamingUtil.join(namespace, (String)entry.getKey());
            name = this.addPostfixIfNeeded(name, this.getPostfixForMetric((Metric)entry.getValue()));
            this.metricRegistry.remove(name);
        }
    }

    private void validateInstrumentationInputParams(Object target, String targetName, String name) {
        Preconditions.checkNotNull((Object)target, (Object)(targetName + " cannot be null"));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name cannot be blank");
    }

    private String buildFullName(String name, String[] additionalNames, String postfix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name cannot be blank");
        String metricName = MetricNamingUtil.join(this.collectorNamespace, name);
        if (additionalNames != null && additionalNames.length > 0) {
            metricName = MetricNamingUtil.join(metricName, additionalNames);
        }
        metricName = this.addPostfixIfNeeded(metricName, postfix);
        return metricName;
    }

    private String addPostfixIfNeeded(String metricName, String postfix) {
        MetricNamePostfixPolicy postfixPolicy;
        if (postfix != null && !metricName.endsWith(postfix) && ((postfixPolicy = this.namingConfig.getMetricNamePostfixPolicy()) == MetricNamePostfixPolicy.ADD_ALL_TYPES || postfixPolicy == MetricNamePostfixPolicy.ADD_COMPOSITE_TYPES && COMPOSITE_TYPE_POSTFIXES.contains(postfix))) {
            metricName = metricName + postfix;
        }
        return metricName;
    }

    private String getPostfixForMetric(Metric metric) {
        Preconditions.checkNotNull((Object)metric);
        Class<?> metricClass = metric.getClass();
        if (Counter.class.isAssignableFrom(metricClass)) {
            return COUNTER_POSTFIX;
        }
        if (Gauge.class.isAssignableFrom(metricClass)) {
            return GAUGE_POSTFIX;
        }
        if (Timer.class.isAssignableFrom(metricClass)) {
            return TIMER_POSTFIX;
        }
        if (Meter.class.isAssignableFrom(metricClass)) {
            return METER_POSTFIX;
        }
        if (Histogram.class.isAssignableFrom(metricClass)) {
            return HISTOGRAM_POSTFIX;
        }
        return null;
    }
}

