/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MetricNamingUtil {
    private static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile("[^\\w-\\.]+");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[\\.]+");
    public static final String REPLACEMENT_CHAR = "-";
    public static final String SEPARATOR = ".";

    private MetricNamingUtil() {
    }

    public static String sanitize(String valueStr) {
        return MetricNamingUtil.sanitizeImpl(valueStr, false);
    }

    public static String join(String[] nameParts) {
        Preconditions.checkNotNull((Object)nameParts, (Object)"nameParts cannot be null");
        Preconditions.checkArgument((nameParts.length > 0 ? 1 : 0) != 0, (Object)"At least one namePart must be provided!");
        return MetricNamingUtil.join(nameParts[0], Arrays.copyOfRange(nameParts, 1, nameParts.length));
    }

    public static String join(String topLevelName, String ... additionalNames) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topLevelName), (Object)"At least one name must be provided!");
        if (additionalNames == null || additionalNames.length == 0) {
            return MetricNamingUtil.sanitizeImpl(topLevelName, true);
        }
        StringBuilder stringBuilder = new StringBuilder().append(topLevelName).append(SEPARATOR);
        for (int i = 0; i < additionalNames.length; ++i) {
            stringBuilder.append(MetricNamingUtil.sanitizeImpl(additionalNames[i], true));
            if (i >= additionalNames.length - 1) continue;
            stringBuilder.append(SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private static String sanitizeImpl(String valueStr, boolean allowSeparator) {
        if (valueStr == null) {
            return null;
        }
        valueStr = valueStr.trim();
        valueStr = ILLEGAL_CHAR_PATTERN.matcher(valueStr).replaceAll(REPLACEMENT_CHAR);
        if (!allowSeparator) {
            valueStr = SEPARATOR_PATTERN.matcher(valueStr).replaceAll(REPLACEMENT_CHAR);
        }
        if (valueStr.startsWith(REPLACEMENT_CHAR) && valueStr.length() > 1) {
            valueStr = valueStr.substring(1);
        }
        if (valueStr.endsWith(REPLACEMENT_CHAR) && valueStr.length() > 1) {
            valueStr = valueStr.substring(0, valueStr.length() - 1);
        }
        return valueStr;
    }
}

