/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.infos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import net.centro.rtb.monitoringcenter.config.NamingConfig;
import net.centro.rtb.monitoringcenter.util.NodeInfoUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeInfo {
    private String nodeId;
    private String datacenterName;
    private String nodeGroupName;
    private String publicIpAddress;

    private NodeInfo() {
    }

    public static NodeInfo create(String datacenterName, String nodeGroupName, String nodeId) {
        Preconditions.checkNotNull((Object)datacenterName);
        Preconditions.checkNotNull((Object)nodeGroupName);
        Preconditions.checkNotNull((Object)nodeId);
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.datacenterName = datacenterName;
        nodeInfo.nodeGroupName = nodeGroupName;
        nodeInfo.nodeId = nodeId;
        nodeInfo.publicIpAddress = NodeInfoUtil.detectPublicIpAddress();
        return nodeInfo;
    }

    public static NodeInfo create(NamingConfig namingConfig) {
        Preconditions.checkNotNull((Object)namingConfig);
        return NodeInfo.create(namingConfig.getDatacenterName(), namingConfig.getNodeGroupName(), namingConfig.getNodeId());
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }
}

