/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.tomcat;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatConnectorStatus;
import net.centro.rtb.monitoringcenter.util.JmxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
class TomcatConnectorMetricSet
implements MetricSet,
TomcatConnectorStatus {
    private static final Logger logger = LoggerFactory.getLogger(TomcatConnectorStatus.class);
    private String name;
    private Integer port;
    private boolean isInternalPort;
    private boolean isSecure;
    private boolean isAjp;
    private int previousRequestCount;
    private AtomicInteger qpsHolder;
    private Gauge<Integer> currentPoolSizeGauge;
    private Gauge<Integer> maxPoolSizeGauge;
    private Gauge<Integer> busyThreadsGauge;
    private Gauge<Long> activeConnectionsGauge;
    private Gauge<Integer> maxConnectionsGauge;
    private Gauge<Integer> totalRequestsGauge;
    private Gauge<Integer> errorsGauge;
    private Gauge<Integer> qpsGauge;
    private Gauge<Long> receivedBytesGauge;
    private Gauge<Long> sentBytesGauge;
    private Map<String, Metric> metricsByNames;

    TomcatConnectorMetricSet(ObjectName threadPoolObjectName) {
        Preconditions.checkNotNull((Object)threadPoolObjectName);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.name = threadPoolObjectName.getKeyProperty("name");
        this.port = JmxUtil.getJmxAttribute(threadPoolObjectName, "port", Integer.class, null);
        Set<ObjectName> connectorObjectNames = null;
        try {
            connectorObjectNames = mBeanServer.queryNames(new ObjectName("Catalina:type=Connector,port=" + this.port), null);
        }
        catch (MalformedObjectNameException e) {
            logger.debug("Invalid ObjectName defined for the Tomcat's Connector MxBean for the {} thread pool", (Object)this.name, (Object)e);
        }
        if (connectorObjectNames != null && !connectorObjectNames.isEmpty()) {
            ObjectName connectorObjectName = (ObjectName)connectorObjectNames.iterator().next();
            String internalPortStr = JmxUtil.getJmxAttribute(connectorObjectName, "internalPort", String.class, Boolean.FALSE.toString());
            this.isInternalPort = Boolean.TRUE.toString().equalsIgnoreCase(internalPortStr);
        }
        this.isSecure = JmxUtil.getJmxAttribute(threadPoolObjectName, "sSLEnabled", Boolean.class, Boolean.FALSE);
        this.isAjp = TomcatConnectorMetricSet.isAjpFromName(this.name);
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        this.currentPoolSizeGauge = JmxUtil.getJmxAttributeAsGauge(threadPoolObjectName, "currentThreadCount", Integer.class, 0);
        if (this.currentPoolSizeGauge != null) {
            metricsByNames.put("currentPoolSize", (Metric)this.currentPoolSizeGauge);
        }
        this.maxPoolSizeGauge = JmxUtil.getJmxAttributeAsGauge(threadPoolObjectName, "maxThreads", Integer.class, 0);
        if (this.maxPoolSizeGauge != null) {
            metricsByNames.put("maxPoolSize", (Metric)this.maxPoolSizeGauge);
        }
        this.busyThreadsGauge = JmxUtil.getJmxAttributeAsGauge(threadPoolObjectName, "currentThreadsBusy", Integer.class, 0);
        if (this.busyThreadsGauge != null) {
            metricsByNames.put("busyThreads", (Metric)this.busyThreadsGauge);
        }
        this.activeConnectionsGauge = JmxUtil.getJmxAttributeAsGauge(threadPoolObjectName, "connectionCount", Long.class, 0L);
        if (this.activeConnectionsGauge != null) {
            metricsByNames.put("activeConnections", (Metric)this.activeConnectionsGauge);
        }
        this.maxConnectionsGauge = JmxUtil.getJmxAttributeAsGauge(threadPoolObjectName, "maxConnections", Integer.class, 0);
        if (this.maxConnectionsGauge != null) {
            metricsByNames.put("maxConnections", (Metric)this.maxConnectionsGauge);
        }
        Set<ObjectName> globalRequestProcessorObjectNames = null;
        try {
            globalRequestProcessorObjectNames = mBeanServer.queryNames(new ObjectName("Catalina:type=GlobalRequestProcessor,name=" + this.name), null);
        }
        catch (MalformedObjectNameException e) {
            logger.debug("Invalid ObjectName defined for the Tomcat's GlobalRequestProcessor MxBean for the {} thread pool", (Object)this.name, (Object)e);
        }
        if (globalRequestProcessorObjectNames != null && !globalRequestProcessorObjectNames.isEmpty()) {
            ObjectName globalRequestProcessorObjectName = (ObjectName)globalRequestProcessorObjectNames.iterator().next();
            this.totalRequestsGauge = JmxUtil.getJmxAttributeAsGauge(globalRequestProcessorObjectName, "requestCount", Integer.class, 0);
            if (this.totalRequestsGauge != null) {
                metricsByNames.put("totalRequests", (Metric)this.totalRequestsGauge);
                this.qpsHolder = new AtomicInteger();
                this.previousRequestCount = (Integer)this.totalRequestsGauge.getValue();
                this.qpsGauge = new Gauge<Integer>(){

                    public Integer getValue() {
                        return TomcatConnectorMetricSet.this.qpsHolder.get();
                    }
                };
                metricsByNames.put("qps", (Metric)this.qpsGauge);
            }
            this.errorsGauge = JmxUtil.getJmxAttributeAsGauge(globalRequestProcessorObjectName, "errorCount", Integer.class, 0);
            if (this.errorsGauge != null) {
                metricsByNames.put("errors", (Metric)this.errorsGauge);
            }
            this.receivedBytesGauge = JmxUtil.getJmxAttributeAsGauge(globalRequestProcessorObjectName, "bytesReceived", Long.class, 0L);
            if (this.receivedBytesGauge != null) {
                metricsByNames.put("receivedBytes", (Metric)this.receivedBytesGauge);
            }
            this.sentBytesGauge = JmxUtil.getJmxAttributeAsGauge(globalRequestProcessorObjectName, "bytesSent", Long.class, 0L);
            if (this.sentBytesGauge != null) {
                metricsByNames.put("sentBytes", (Metric)this.sentBytesGauge);
            }
        }
        this.metricsByNames = metricsByNames;
    }

    void updateQps() {
        if (this.totalRequestsGauge == null) {
            return;
        }
        int currentRequestCount = (Integer)this.totalRequestsGauge.getValue();
        this.qpsHolder.set(currentRequestCount - this.previousRequestCount);
        this.previousRequestCount = currentRequestCount;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty
    public boolean isInternalPort() {
        return this.isInternalPort;
    }

    @Override
    @JsonProperty
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    @JsonProperty
    public boolean isAjp() {
        return this.isAjp;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getCurrentPoolSizeGauge() {
        return this.currentPoolSizeGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getMaxPoolSizeGauge() {
        return this.maxPoolSizeGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getBusyThreadsGauge() {
        return this.busyThreadsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getActiveConnectionsGauge() {
        return this.activeConnectionsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getMaxConnectionsGauge() {
        return this.maxConnectionsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getTotalRequestsGauge() {
        return this.totalRequestsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getErrorsGauge() {
        return this.errorsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getQpsGauge() {
        return this.qpsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getReceivedBytesGauge() {
        return this.receivedBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getSentBytesGauge() {
        return this.sentBytesGauge;
    }

    private static boolean isAjpFromName(String connectorName) {
        if (connectorName == null) {
            return false;
        }
        return connectorName.startsWith("jk-") || connectorName.startsWith("\"jk-") || connectorName.startsWith("ajp-bio-") || connectorName.startsWith("\"ajp-bio-");
    }
}

