/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.config;

import java.util.Collections;
import java.util.Set;

public class JmxReporterConfig {
    private boolean enableReporter;
    private Set<String> startsWithFilters;
    private Set<String> blockedStartsWithFilters;

    private JmxReporterConfig(Builder builder) {
        this.enableReporter = builder.enableReporter;
        this.startsWithFilters = Collections.unmodifiableSet(builder.startsWithFilters);
        this.blockedStartsWithFilters = Collections.unmodifiableSet(builder.blockedStartsWithFilters);
    }

    public boolean isEnableReporter() {
        return this.enableReporter;
    }

    public Set<String> getStartsWithFilters() {
        return this.startsWithFilters;
    }

    public Set<String> getBlockedStartsWithFilters() {
        return this.blockedStartsWithFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmxReporterConfig that = (JmxReporterConfig)o;
        if (this.enableReporter != that.enableReporter) {
            return false;
        }
        if (this.startsWithFilters != null ? !this.startsWithFilters.equals(that.startsWithFilters) : that.startsWithFilters != null) {
            return false;
        }
        return this.blockedStartsWithFilters != null ? this.blockedStartsWithFilters.equals(that.blockedStartsWithFilters) : that.blockedStartsWithFilters == null;
    }

    public int hashCode() {
        int result = this.enableReporter ? 1 : 0;
        result = 31 * result + (this.startsWithFilters != null ? this.startsWithFilters.hashCode() : 0);
        result = 31 * result + (this.blockedStartsWithFilters != null ? this.blockedStartsWithFilters.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JmxReporterConfig{");
        sb.append("enableReporter=").append(this.enableReporter);
        sb.append(", startsWithFilters=").append(this.startsWithFilters);
        sb.append(", blockedStartsWithFilters=").append(this.blockedStartsWithFilters);
        sb.append('}');
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enableReporter = true;
        private Set<String> startsWithFilters = Collections.emptySet();
        private Set<String> blockedStartsWithFilters = Collections.emptySet();

        public Builder enableReporter(boolean enableReporter) {
            this.enableReporter = enableReporter;
            return this;
        }

        public Builder startsWithFilters(Set<String> startsWithFilters) {
            this.startsWithFilters = startsWithFilters == null ? Collections.emptySet() : startsWithFilters;
            return this;
        }

        public Builder blockedStartsWithFilters(Set<String> blockedStartsWithFilters) {
            this.blockedStartsWithFilters = blockedStartsWithFilters == null ? Collections.emptySet() : blockedStartsWithFilters;
            return this;
        }

        public JmxReporterConfig build() {
            return new JmxReporterConfig(this);
        }
    }
}

