/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;

public class GuavaCacheMetricSet
implements MetricSet {
    private Cache<?, ?> cache;

    public GuavaCacheMetricSet(Cache<?, ?> cache) {
        Preconditions.checkNotNull(cache);
        this.cache = cache;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> metricsByNames = new HashMap<String, Object>();
        metricsByNames.put("size", new Gauge<Long>(){

            public Long getValue() {
                return GuavaCacheMetricSet.this.cache.size();
            }
        });
        metricsByNames.put("hits", new Gauge<Long>(){

            public Long getValue() {
                return GuavaCacheMetricSet.this.cache.stats().hitCount();
            }
        });
        metricsByNames.put("misses", new Gauge<Long>(){

            public Long getValue() {
                return GuavaCacheMetricSet.this.cache.stats().missCount();
            }
        });
        metricsByNames.put("evictions", new Gauge<Long>(){

            public Long getValue() {
                return GuavaCacheMetricSet.this.cache.stats().evictionCount();
            }
        });
        String loadingNamespace = "loading";
        metricsByNames.put(MetricNamingUtil.join(loadingNamespace, "successful"), new Gauge<Long>(){

            public Long getValue() {
                return GuavaCacheMetricSet.this.cache.stats().loadSuccessCount();
            }
        });
        metricsByNames.put(MetricNamingUtil.join(loadingNamespace, "exceptions"), new Gauge<Long>(){

            public Long getValue() {
                return GuavaCacheMetricSet.this.cache.stats().loadExceptionCount();
            }
        });
        metricsByNames.put(MetricNamingUtil.join(loadingNamespace, "averageLoadingTimeInNanos"), new Gauge<Double>(){

            public Double getValue() {
                return GuavaCacheMetricSet.this.cache.stats().averageLoadPenalty();
            }
        });
        return Collections.unmodifiableMap(metricsByNames);
    }
}

