/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostAndPort {
    private String host;
    private int port;

    public HostAndPort(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new IllegalArgumentException("host cannot be blank");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.host = host.trim();
        this.port = port;
    }

    public static HostAndPort fromString(String hostAndPortStr) {
        if (hostAndPortStr == null) {
            throw new NullPointerException("hostAndPortStr cannot be null");
        }
        if (hostAndPortStr.trim().isEmpty()) {
            throw new IllegalArgumentException("hostAndPortStr cannot be blank");
        }
        String[] hostAndPortStrParts = hostAndPortStr.split(":");
        if (hostAndPortStrParts.length == 2) {
            String host = hostAndPortStrParts[0].trim();
            String portStr = hostAndPortStrParts[1].trim();
            Integer port = null;
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Port cannot be parsed from " + portStr, e);
            }
            return new HostAndPort(host, port);
        }
        throw new IllegalArgumentException("Invalid format: " + hostAndPortStr + ". Expected host:port.");
    }

    public static HostAndPort of(String host, int port) {
        return new HostAndPort(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HostAndPort{");
        sb.append("host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return !(this.host == null ? that.host != null : !this.host.equals(that.host));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

