/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.os;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.centro.rtb.monitoringcenter.metrics.system.os.NetworkInterfaceStatus;
import net.centro.rtb.monitoringcenter.metrics.system.os.OperatingSystemStatus;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class OperatingSystemMetricSet
implements MetricSet,
OperatingSystemStatus {
    private static final Logger logger = LoggerFactory.getLogger(OperatingSystemMetricSet.class);
    private OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private File rootFilePath = new File("/");
    private ScheduledExecutorService ioWaitUpdaterExecutorService;
    private ScheduledExecutorService networkInterfaceUsageUpdaterExecutorService;
    private AtomicReference<Double> ioWaitPercentageHolder;
    private AtomicReference<Map<String, NetworkInterfaceUsage>> networkInterfaceUsageByNetworkInterfaceNameHolder;
    private Gauge<Integer> availableLogicalProcessorsGauge;
    private Gauge<Double> systemLoadAverageGauge;
    private Gauge<Double> systemLoadAveragePerLogicalProcessorGauge;
    private Gauge<Double> jvmCpuBusyPercentageGauge;
    private Gauge<Double> systemCpuBusyPercentageGauge;
    private Gauge<Long> committedVirtualMemorySizeInBytesGauge;
    private Gauge<Long> totalPhysicalMemorySizeInBytesGauge;
    private Gauge<Long> freePhysicalMemorySizeInBytesGauge;
    private Gauge<Double> usedPhysicalMemoryPercentageGauge;
    private Gauge<Long> totalSwapSpaceSizeInBytesGauge;
    private Gauge<Long> freeSwapSpaceSizeInBytesGauge;
    private Gauge<Double> usedSwapSpacePercentageGauge;
    private Gauge<Long> maxFileDescriptorsGauge;
    private Gauge<Long> openFileDescriptorsGauge;
    private Gauge<Double> usedFileDescriptorsPercentageGauge;
    private Gauge<Long> totalDiskSpaceInBytesGauge;
    private Gauge<Long> freeDiskSpaceInBytesGauge;
    private Gauge<Double> usedDiskSpacePercentageGauge;
    private Gauge<Double> ioWaitPercentageGauge;
    private List<NetworkInterfaceStatus> networkInterfaceStatuses;
    private Map<String, Metric> metricsByNames;
    private AtomicBoolean shutdown;

    public OperatingSystemMetricSet() {
        Map<String, NetworkInterfaceUsage> networkInterfaceUsageByNetworkInterfaceName;
        Double ioWaitPercentage = OperatingSystemMetricSet.fetchIoWaitPercentage();
        if (ioWaitPercentage != null) {
            this.ioWaitPercentageHolder = new AtomicReference<Double>(ioWaitPercentage);
            this.ioWaitUpdaterExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("OperatingSystemMetricSet-IOWaitUpdater-%d").build());
            this.ioWaitUpdaterExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Double ioWaitPercentage = OperatingSystemMetricSet.fetchIoWaitPercentage();
                    if (ioWaitPercentage != null) {
                        OperatingSystemMetricSet.this.ioWaitPercentageHolder.set(ioWaitPercentage);
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
        if ((networkInterfaceUsageByNetworkInterfaceName = this.fetchNetworkInterfaceUsage()) != null) {
            this.networkInterfaceUsageByNetworkInterfaceNameHolder = new AtomicReference<Map<String, NetworkInterfaceUsage>>(networkInterfaceUsageByNetworkInterfaceName);
            this.networkInterfaceUsageUpdaterExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("OperatingSystemMetricSet-NICUsageUpdater-%d").build());
            this.networkInterfaceUsageUpdaterExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Map networkInterfaceUsageByNetworkInterfaceName = OperatingSystemMetricSet.this.fetchNetworkInterfaceUsage();
                    if (networkInterfaceUsageByNetworkInterfaceName != null) {
                        OperatingSystemMetricSet.this.networkInterfaceUsageByNetworkInterfaceNameHolder.set(networkInterfaceUsageByNetworkInterfaceName);
                    }
                }
            }, 10L, 10L, TimeUnit.SECONDS);
        }
        this.metricsByNames = new HashMap<String, Metric>();
        this.availableLogicalProcessorsGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getAvailableProcessors();
            }
        };
        this.metricsByNames.put("availableLogicalProcessors", (Metric)this.availableLogicalProcessorsGauge);
        if (this.operatingSystemMXBean.getSystemLoadAverage() >= 0.0) {
            this.systemLoadAverageGauge = new Gauge<Double>(){

                public Double getValue() {
                    return OperatingSystemMetricSet.this.operatingSystemMXBean.getSystemLoadAverage();
                }
            };
            this.metricsByNames.put("systemLoadAverage", (Metric)this.systemLoadAverageGauge);
            this.systemLoadAveragePerLogicalProcessorGauge = new Gauge<Double>(){

                public Double getValue() {
                    return OperatingSystemMetricSet.this.operatingSystemMXBean.getSystemLoadAverage() / (double)OperatingSystemMetricSet.this.operatingSystemMXBean.getAvailableProcessors();
                }
            };
            this.metricsByNames.put("systemLoadAveragePerLogicalProcessor", (Metric)this.systemLoadAveragePerLogicalProcessorGauge);
        }
        if (com.sun.management.OperatingSystemMXBean.class.isAssignableFrom(this.operatingSystemMXBean.getClass())) {
            final com.sun.management.OperatingSystemMXBean sunOsMxBean = (com.sun.management.OperatingSystemMXBean)com.sun.management.OperatingSystemMXBean.class.cast(this.operatingSystemMXBean);
            if (sunOsMxBean.getProcessCpuLoad() >= 0.0) {
                this.jvmCpuBusyPercentageGauge = new Gauge<Double>(){

                    public Double getValue() {
                        return sunOsMxBean.getProcessCpuLoad() * 100.0;
                    }
                };
                this.metricsByNames.put("jvmCpuBusyPercentage", (Metric)this.jvmCpuBusyPercentageGauge);
            }
            if (sunOsMxBean.getSystemCpuLoad() >= 0.0) {
                this.systemCpuBusyPercentageGauge = new Gauge<Double>(){

                    public Double getValue() {
                        return sunOsMxBean.getSystemCpuLoad() * 100.0;
                    }
                };
                this.metricsByNames.put("systemCpuBusyPercentage", (Metric)this.systemCpuBusyPercentageGauge);
            }
            if (sunOsMxBean.getCommittedVirtualMemorySize() >= 0L) {
                this.committedVirtualMemorySizeInBytesGauge = new Gauge<Long>(){

                    public Long getValue() {
                        return sunOsMxBean.getCommittedVirtualMemorySize();
                    }
                };
                this.metricsByNames.put("committedVirtualMemorySizeInBytes", (Metric)this.committedVirtualMemorySizeInBytesGauge);
            }
            String physicalMemoryNamespace = "physicalMemory";
            this.totalPhysicalMemorySizeInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return sunOsMxBean.getTotalPhysicalMemorySize();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(physicalMemoryNamespace, "totalInBytes"), (Metric)this.totalPhysicalMemorySizeInBytesGauge);
            this.freePhysicalMemorySizeInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return sunOsMxBean.getFreePhysicalMemorySize();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(physicalMemoryNamespace, "freeInBytes"), (Metric)this.freePhysicalMemorySizeInBytesGauge);
            this.usedPhysicalMemoryPercentageGauge = new Gauge<Double>(){

                public Double getValue() {
                    long totalPhysicalMemorySize = sunOsMxBean.getTotalPhysicalMemorySize();
                    if (totalPhysicalMemorySize == 0L) {
                        return 0.0;
                    }
                    long usedPhysicalMemorySize = totalPhysicalMemorySize - sunOsMxBean.getFreePhysicalMemorySize();
                    return Double.valueOf(usedPhysicalMemorySize) / (double)totalPhysicalMemorySize * 100.0;
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(physicalMemoryNamespace, "usedPercentage"), (Metric)this.usedPhysicalMemoryPercentageGauge);
            String swapSpaceNamespace = "swapSpace";
            this.totalSwapSpaceSizeInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return sunOsMxBean.getTotalSwapSpaceSize();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(swapSpaceNamespace, "totalInBytes"), (Metric)this.totalSwapSpaceSizeInBytesGauge);
            this.freeSwapSpaceSizeInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return sunOsMxBean.getFreeSwapSpaceSize();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(swapSpaceNamespace, "freeInBytes"), (Metric)this.freeSwapSpaceSizeInBytesGauge);
            this.usedSwapSpacePercentageGauge = new Gauge<Double>(){

                public Double getValue() {
                    long totalSwapSpaceSize = sunOsMxBean.getTotalSwapSpaceSize();
                    if (totalSwapSpaceSize == 0L) {
                        return 0.0;
                    }
                    long usedSwapSpaceSize = totalSwapSpaceSize - sunOsMxBean.getFreeSwapSpaceSize();
                    return Double.valueOf(usedSwapSpaceSize) / (double)totalSwapSpaceSize * 100.0;
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(swapSpaceNamespace, "usedPercentage"), (Metric)this.usedSwapSpacePercentageGauge);
        }
        String fileDescriptorsNamespace = "fileDescriptors";
        if (UnixOperatingSystemMXBean.class.isAssignableFrom(this.operatingSystemMXBean.getClass())) {
            final UnixOperatingSystemMXBean unixOsMxBean = (UnixOperatingSystemMXBean)UnixOperatingSystemMXBean.class.cast(this.operatingSystemMXBean);
            this.maxFileDescriptorsGauge = new Gauge<Long>(){

                public Long getValue() {
                    return unixOsMxBean.getMaxFileDescriptorCount();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(fileDescriptorsNamespace, "max"), (Metric)this.maxFileDescriptorsGauge);
            this.openFileDescriptorsGauge = new Gauge<Long>(){

                public Long getValue() {
                    return unixOsMxBean.getOpenFileDescriptorCount();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(fileDescriptorsNamespace, "open"), (Metric)this.openFileDescriptorsGauge);
            this.usedFileDescriptorsPercentageGauge = new Gauge<Double>(){

                public Double getValue() {
                    long maxFileDescriptors = unixOsMxBean.getMaxFileDescriptorCount();
                    if (maxFileDescriptors == 0L) {
                        return 0.0;
                    }
                    return Double.valueOf(unixOsMxBean.getOpenFileDescriptorCount()) / (double)maxFileDescriptors * 100.0;
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(fileDescriptorsNamespace, "usedPercentage"), (Metric)this.usedFileDescriptorsPercentageGauge);
        }
        String diskSpaceNamespace = "diskSpace";
        if (this.rootFilePath.getTotalSpace() > 0L) {
            this.totalDiskSpaceInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return OperatingSystemMetricSet.this.rootFilePath.getTotalSpace();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(diskSpaceNamespace, "totalInBytes"), (Metric)this.totalDiskSpaceInBytesGauge);
            this.freeDiskSpaceInBytesGauge = new Gauge<Long>(){

                public Long getValue() {
                    return OperatingSystemMetricSet.this.rootFilePath.getFreeSpace();
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(diskSpaceNamespace, "freeInBytes"), (Metric)this.freeDiskSpaceInBytesGauge);
            this.usedDiskSpacePercentageGauge = new Gauge<Double>(){

                public Double getValue() {
                    long totalDiskSpace = OperatingSystemMetricSet.this.rootFilePath.getTotalSpace();
                    if (totalDiskSpace == 0L) {
                        return 0.0;
                    }
                    long usedDiskSpace = totalDiskSpace - OperatingSystemMetricSet.this.rootFilePath.getFreeSpace();
                    return Double.valueOf(usedDiskSpace) / (double)totalDiskSpace * 100.0;
                }
            };
            this.metricsByNames.put(MetricNamingUtil.join(diskSpaceNamespace, "usedPercentage"), (Metric)this.usedDiskSpacePercentageGauge);
        }
        if (this.ioWaitPercentageHolder != null) {
            this.ioWaitPercentageGauge = new Gauge<Double>(){

                public Double getValue() {
                    return (Double)OperatingSystemMetricSet.this.ioWaitPercentageHolder.get();
                }
            };
            this.metricsByNames.put("ioWaitPercentage", (Metric)this.ioWaitPercentageGauge);
        }
        ArrayList<NetworkInterfaceStatus> networkInterfaceStatuses = new ArrayList<NetworkInterfaceStatus>();
        if (networkInterfaceUsageByNetworkInterfaceName != null) {
            for (final String name : networkInterfaceUsageByNetworkInterfaceName.keySet()) {
                String networkInterfaceNamespace = MetricNamingUtil.join("networkInterfaces", MetricNamingUtil.sanitize(name));
                Gauge<Long> receivedBytesPerSecondGauge = new Gauge<Long>(){

                    public Long getValue() {
                        NetworkInterfaceUsage networkInterfaceUsage;
                        Map networkInterfaceUsageByNetworkInterfaceName = (Map)OperatingSystemMetricSet.this.networkInterfaceUsageByNetworkInterfaceNameHolder.get();
                        if (networkInterfaceUsageByNetworkInterfaceName != null && (networkInterfaceUsage = (NetworkInterfaceUsage)networkInterfaceUsageByNetworkInterfaceName.get(name)) != null) {
                            return networkInterfaceUsage.receivedBytesPerSecond;
                        }
                        return 0L;
                    }
                };
                this.metricsByNames.put(MetricNamingUtil.join(networkInterfaceNamespace, "receivedBytesPerSecond"), (Metric)receivedBytesPerSecondGauge);
                Gauge<Long> transmittedBytesPerSecondGauge = new Gauge<Long>(){

                    public Long getValue() {
                        NetworkInterfaceUsage networkInterfaceUsage;
                        Map networkInterfaceUsageByNetworkInterfaceName = (Map)OperatingSystemMetricSet.this.networkInterfaceUsageByNetworkInterfaceNameHolder.get();
                        if (networkInterfaceUsageByNetworkInterfaceName != null && (networkInterfaceUsage = (NetworkInterfaceUsage)networkInterfaceUsageByNetworkInterfaceName.get(name)) != null) {
                            return networkInterfaceUsage.transmittedBytesPerSecond;
                        }
                        return 0L;
                    }
                };
                this.metricsByNames.put(MetricNamingUtil.join(networkInterfaceNamespace, "transmittedBytesPerSecond"), (Metric)transmittedBytesPerSecondGauge);
                networkInterfaceStatuses.add(new NetworkInterfaceStatus((Gauge)receivedBytesPerSecondGauge, (Gauge)transmittedBytesPerSecondGauge){
                    final /* synthetic */ Gauge val$receivedBytesPerSecondGauge;
                    final /* synthetic */ Gauge val$transmittedBytesPerSecondGauge;
                    {
                        this.val$receivedBytesPerSecondGauge = gauge;
                        this.val$transmittedBytesPerSecondGauge = gauge2;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public Gauge<Long> getReceivedBytesPerSecondGauge() {
                        return this.val$receivedBytesPerSecondGauge;
                    }

                    @Override
                    public Gauge<Long> getTransmittedBytesPerSecondGauge() {
                        return this.val$transmittedBytesPerSecondGauge;
                    }
                });
            }
        }
        this.networkInterfaceStatuses = networkInterfaceStatuses;
        this.shutdown = new AtomicBoolean(false);
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getAvailableLogicalProcessorsGauge() {
        return this.availableLogicalProcessorsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getSystemLoadAverageGauge() {
        return this.systemLoadAverageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getSystemLoadAveragePerLogicalProcessorGauge() {
        return this.systemLoadAveragePerLogicalProcessorGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getJvmCpuBusyPercentageGauge() {
        return this.jvmCpuBusyPercentageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getSystemCpuBusyPercentageGauge() {
        return this.systemCpuBusyPercentageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getCommittedVirtualMemorySizeInBytesGauge() {
        return this.committedVirtualMemorySizeInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getTotalPhysicalMemorySizeInBytesGauge() {
        return this.totalPhysicalMemorySizeInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getFreePhysicalMemorySizeInBytesGauge() {
        return this.freePhysicalMemorySizeInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getUsedPhysicalMemoryPercentageGauge() {
        return this.usedPhysicalMemoryPercentageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getTotalSwapSpaceSizeInBytesGauge() {
        return this.totalSwapSpaceSizeInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getFreeSwapSpaceSizeInBytesGauge() {
        return this.freeSwapSpaceSizeInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getUsedSwapSpacePercentageGauge() {
        return this.usedSwapSpacePercentageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getMaxFileDescriptorsGauge() {
        return this.maxFileDescriptorsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getOpenFileDescriptorsGauge() {
        return this.openFileDescriptorsGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getUsedFileDescriptorsPercentageGauge() {
        return this.usedFileDescriptorsPercentageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getTotalDiskSpaceInBytesGauge() {
        return this.totalDiskSpaceInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Long> getFreeDiskSpaceInBytesGauge() {
        return this.freeDiskSpaceInBytesGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getUsedDiskSpacePercentageGauge() {
        return this.usedDiskSpacePercentageGauge;
    }

    @Override
    @JsonProperty
    public Gauge<Double> getIoWaitPercentageGauge() {
        return this.ioWaitPercentageGauge;
    }

    @Override
    @JsonProperty
    public List<NetworkInterfaceStatus> getNetworkInterfaceStatuses() {
        return Collections.unmodifiableList(this.networkInterfaceStatuses);
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        if (this.ioWaitUpdaterExecutorService != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.ioWaitUpdaterExecutorService, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (this.networkInterfaceUsageUpdaterExecutorService != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.networkInterfaceUsageUpdaterExecutorService, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private static Double fetchIoWaitPercentage() {
        block11: {
            if (!SystemUtils.IS_OS_LINUX) {
                return null;
            }
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", "iostat -c 1 2 | awk '/^ /{print $4}'"});
                BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                BufferedReader resultStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
                ArrayList<String> outputLines = new ArrayList<String>();
                String line = null;
                while ((line = resultStream.readLine()) != null) {
                    outputLines.add(line);
                }
                boolean error = false;
                while (errorStream.readLine() != null) {
                    error = true;
                }
                errorStream.close();
                resultStream.close();
                try {
                    int result = process.waitFor();
                    if (result != 0) {
                        logger.debug("iostat failed with return code {}", (Object)result);
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("iostat was interrupted");
                }
                if (!error && outputLines.size() == 2) {
                    String iowaitPercentStr = (String)outputLines.get(outputLines.size() - 1);
                    try {
                        return Double.parseDouble(iowaitPercentStr);
                    }
                    catch (NumberFormatException e) {
                        logger.debug("Error parsing iowait value from {}", (Object)iowaitPercentStr);
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Exception occurred while executing iostat command", (Throwable)e);
                if (!InterruptedException.class.isInstance(e)) break block11;
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    private Map<String, NetworkInterfaceUsage> fetchNetworkInterfaceUsage() {
        block14: {
            if (!SystemUtils.IS_OS_LINUX) {
                return null;
            }
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", "sar -n DEV 1 2 | awk 'BEGIN{OFS=\",\"}/^Average/ && $2 !~ /^IFACE/{print $2,$5,$6}'"});
                BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                BufferedReader resultStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
                ArrayList<String> outputLines = new ArrayList<String>();
                String line = null;
                while ((line = resultStream.readLine()) != null) {
                    outputLines.add(line);
                }
                boolean error = false;
                while (errorStream.readLine() != null) {
                    error = true;
                }
                errorStream.close();
                resultStream.close();
                try {
                    int result = process.waitFor();
                    if (result != 0) {
                        logger.debug("sar failed with return code {}", (Object)result);
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("sar was interrupted");
                }
                if (error || outputLines.size() <= 0) break block14;
                HashMap<String, NetworkInterfaceUsage> networkInterfaceUsageByNetworkInterfaceName = new HashMap<String, NetworkInterfaceUsage>();
                for (String outputLine : outputLines) {
                    String[] outputLineSplit = outputLine.split(",");
                    if (outputLineSplit.length != 3) {
                        logger.debug("Unexpected output line for network interface usage: {}", (Object)outputLine);
                        continue;
                    }
                    String name = StringUtils.trimToNull((String)outputLineSplit[0]);
                    if (name == null) continue;
                    String receivedKilobytesPerSecondStr = outputLineSplit[1];
                    double receivedKilobytesPerSecond = 0.0;
                    try {
                        receivedKilobytesPerSecond = Double.parseDouble(receivedKilobytesPerSecondStr.trim());
                    }
                    catch (NumberFormatException e) {
                        logger.debug("Error parsing receivedKilobytesPerSecond from {}", (Object)receivedKilobytesPerSecondStr);
                        continue;
                    }
                    String transmittedKilobytesPerSecondStr = outputLineSplit[2];
                    double transmittedKilobytesPerSecond = 0.0;
                    try {
                        transmittedKilobytesPerSecond = Double.parseDouble(transmittedKilobytesPerSecondStr.trim());
                    }
                    catch (NumberFormatException e) {
                        logger.debug("Error parsing transmittedKilobytesPerSecond from {}", (Object)transmittedKilobytesPerSecondStr);
                        continue;
                    }
                    long receivedBytesPerSecond = (long)(receivedKilobytesPerSecond * 1024.0);
                    long transmittedBytesPerSecond = (long)(transmittedKilobytesPerSecond * 1024.0);
                    networkInterfaceUsageByNetworkInterfaceName.put(name, new NetworkInterfaceUsage(receivedBytesPerSecond, transmittedBytesPerSecond));
                }
                return networkInterfaceUsageByNetworkInterfaceName.isEmpty() ? null : networkInterfaceUsageByNetworkInterfaceName;
            }
            catch (Exception e) {
                logger.debug("Exception occurred while executing sar command", (Throwable)e);
                if (!InterruptedException.class.isInstance(e)) break block14;
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    private static class NetworkInterfaceUsage {
        private final long receivedBytesPerSecond;
        private final long transmittedBytesPerSecond;

        public NetworkInterfaceUsage(long receivedBytesPerSecond, long transmittedBytesPerSecond) {
            this.receivedBytesPerSecond = receivedBytesPerSecond;
            this.transmittedBytesPerSecond = transmittedBytesPerSecond;
        }
    }
}

