/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.instrumented;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.centro.rtb.monitoringcenter.MetricCollector;

public class InstrumentedScheduledExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;
    private final Meter submittedMeter;
    private final Counter runningCounter;
    private final Meter completedMeter;
    private final Timer durationTimer;
    private final Meter scheduledOneOffTaskMeter;
    private final Meter scheduledRepetitiveTaskMeter;
    private final Counter scheduledOverrunCounter;
    private final Histogram durationAsPercentOfPeriodHistogram;

    public InstrumentedScheduledExecutorService(ScheduledExecutorService delegate, MetricCollector metricCollector, String name) {
        this.delegate = delegate;
        this.submittedMeter = metricCollector.getMeter(name, "submittedMeter");
        this.runningCounter = metricCollector.getCounter(name, "running");
        this.completedMeter = metricCollector.getMeter(name, "completedMeter");
        this.durationTimer = metricCollector.getTimer(name, "durationTimer");
        this.scheduledOneOffTaskMeter = metricCollector.getMeter(name, "scheduled.oneOffTaskMeter");
        this.scheduledRepetitiveTaskMeter = metricCollector.getMeter(name, "scheduled.repetitiveTaskMeter");
        this.scheduledOverrunCounter = metricCollector.getCounter(name, "scheduled.overrun");
        this.durationAsPercentOfPeriodHistogram = metricCollector.getHistogram(name, "scheduled.durationAsPercentOfPeriodHistogram");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.scheduledOneOffTaskMeter.mark();
        return this.delegate.schedule(new InstrumentedRunnable(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.scheduledOneOffTaskMeter.mark();
        return this.delegate.schedule(new InstrumentedCallable<V>(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.scheduledRepetitiveTaskMeter.mark();
        return this.delegate.scheduleAtFixedRate(new InstrumentedPeriodicRunnable(command, period, unit), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.scheduledRepetitiveTaskMeter.mark();
        return this.delegate.scheduleAtFixedRate(new InstrumentedRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.submittedMeter.mark();
        return this.delegate.submit(new InstrumentedCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.submittedMeter.mark();
        return this.delegate.submit(new InstrumentedRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.submittedMeter.mark();
        return this.delegate.submit(new InstrumentedRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAll(instrumented);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAll(instrumented, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAny(instrumented);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        return this.delegate.invokeAny(instrumented, timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> instrument(Collection<? extends Callable<T>> tasks) {
        ArrayList<InstrumentedCallable<T>> instrumented = new ArrayList<InstrumentedCallable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            instrumented.add(new InstrumentedCallable<T>(task));
        }
        return instrumented;
    }

    @Override
    public void execute(Runnable command) {
        this.submittedMeter.mark();
        this.delegate.execute(new InstrumentedRunnable(command));
    }

    private class InstrumentedCallable<T>
    implements Callable<T> {
        private final Callable<T> task;

        InstrumentedCallable(Callable<T> task) {
            this.task = task;
        }

        @Override
        public T call() throws Exception {
            InstrumentedScheduledExecutorService.this.runningCounter.inc();
            Timer.Context context = InstrumentedScheduledExecutorService.this.durationTimer.time();
            try {
                T t = this.task.call();
                return t;
            }
            finally {
                context.stop();
                InstrumentedScheduledExecutorService.this.runningCounter.dec();
                InstrumentedScheduledExecutorService.this.completedMeter.mark();
            }
        }
    }

    private class InstrumentedPeriodicRunnable
    implements Runnable {
        private final Runnable command;
        private final long periodInNanos;

        InstrumentedPeriodicRunnable(Runnable command, long period, TimeUnit unit) {
            this.command = command;
            this.periodInNanos = unit.toNanos(period);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstrumentedScheduledExecutorService.this.runningCounter.inc();
            Timer.Context context = InstrumentedScheduledExecutorService.this.durationTimer.time();
            try {
                this.command.run();
            }
            finally {
                long elapsed = context.stop();
                InstrumentedScheduledExecutorService.this.runningCounter.dec();
                InstrumentedScheduledExecutorService.this.completedMeter.mark();
                if (elapsed > this.periodInNanos) {
                    InstrumentedScheduledExecutorService.this.scheduledOverrunCounter.inc();
                }
                InstrumentedScheduledExecutorService.this.durationAsPercentOfPeriodHistogram.update(100L * elapsed / this.periodInNanos);
            }
        }
    }

    private class InstrumentedRunnable
    implements Runnable {
        private final Runnable command;

        InstrumentedRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            InstrumentedScheduledExecutorService.this.runningCounter.inc();
            Timer.Context context = InstrumentedScheduledExecutorService.this.durationTimer.time();
            try {
                this.command.run();
            }
            finally {
                context.stop();
                InstrumentedScheduledExecutorService.this.runningCounter.dec();
                InstrumentedScheduledExecutorService.this.completedMeter.mark();
            }
        }
    }
}

