/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.infos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppInfo {
    private static final Logger logger = LoggerFactory.getLogger(AppInfo.class);
    private static final String BUILD_INFO_PROPERTIES_FILE = "/buildInfo.properties";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private String applicationName;
    private String applicationVersion;
    private Date buildTimestamp;
    private String buildUsername;
    private String branchName;
    private String commitId;
    private String commitMessage;
    private Date commitTimestamp;
    private String commitAuthor;

    private AppInfo() {
    }

    public static AppInfo create(String applicationName) {
        Preconditions.checkNotNull((Object)applicationName);
        AppInfo appInfo = new AppInfo();
        appInfo.applicationName = applicationName;
        Properties properties = new Properties();
        try {
            properties.load(AppInfo.class.getResourceAsStream(BUILD_INFO_PROPERTIES_FILE));
        }
        catch (Exception e) {
            logger.debug("Error loading the buildInfo file from the classpath: {}", (Object)BUILD_INFO_PROPERTIES_FILE, (Object)e);
            if (InterruptedException.class.isInstance(e)) {
                Thread.currentThread().interrupt();
            }
            return appInfo;
        }
        appInfo.applicationVersion = StringUtils.trimToNull((String)properties.getProperty("build.version"));
        appInfo.buildTimestamp = AppInfo.parseDate(properties.getProperty("build.timestamp"));
        appInfo.buildUsername = StringUtils.trimToNull((String)properties.getProperty("build.username"));
        appInfo.branchName = StringUtils.trimToNull((String)properties.getProperty("vcs.branch"));
        appInfo.commitId = StringUtils.trimToNull((String)properties.getProperty("vcs.commit.id"));
        appInfo.commitMessage = StringUtils.trimToNull((String)properties.getProperty("vcs.commit.message"));
        appInfo.commitTimestamp = AppInfo.parseDate(properties.getProperty("vcs.commit.timestamp"));
        appInfo.commitAuthor = StringUtils.trimToNull((String)properties.getProperty("vcs.commit.author"));
        return appInfo;
    }

    private static Date parseDate(String dateString) {
        if (dateString != null) {
            try {
                return DATE_FORMAT.parse(dateString);
            }
            catch (ParseException e) {
                logger.debug("Could not parse date from {}", (Object)dateString, (Object)e);
            }
        }
        return null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public Date getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getBuildUsername() {
        return this.buildUsername;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public Date getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public String getCommitAuthor() {
        return this.commitAuthor;
    }
}

