/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.config;

import java.io.File;
import net.centro.rtb.monitoringcenter.config.GraphiteReporterConfig;
import net.centro.rtb.monitoringcenter.config.JmxReporterConfig;
import net.centro.rtb.monitoringcenter.config.MetricCollectionConfig;
import net.centro.rtb.monitoringcenter.config.MetricNamePostfixPolicy;
import net.centro.rtb.monitoringcenter.config.MetricReportingConfig;
import net.centro.rtb.monitoringcenter.config.NamingConfig;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;
import org.apache.commons.lang3.StringUtils;

public class MonitoringCenterConfig {
    private File configFile;
    private NamingConfig namingConfig;
    private MetricCollectionConfig metricCollectionConfig;
    private MetricReportingConfig metricReportingConfig;

    private MonitoringCenterConfig(Builder builder) {
        this.configFile = builder.configFile;
        this.namingConfig = new NamingConfig(builder.applicationName, builder.datacenterName, builder.nodeGroupName, builder.nodeId, builder.metricNamePostfixPolicy, builder.appendTypeToHealthCheckNames);
        this.metricCollectionConfig = new MetricCollectionConfig(builder.enableSystemMetrics, builder.enableTomcatMetrics);
        this.metricReportingConfig = new MetricReportingConfig(builder.graphiteReporterConfig, builder.jmxReporterConfig);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public NamingConfig getNamingConfig() {
        return this.namingConfig;
    }

    public MetricCollectionConfig getMetricCollectionConfig() {
        return this.metricCollectionConfig;
    }

    public MetricReportingConfig getMetricReportingConfig() {
        return this.metricReportingConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MonitoringCenterConfig{");
        sb.append("namingConfig=").append(this.namingConfig);
        sb.append(", metricCollectionConfig=").append(this.metricCollectionConfig);
        sb.append(", metricReportingConfig=").append(this.metricReportingConfig);
        sb.append('}');
        return sb.toString();
    }

    protected static Builder builder() {
        return new Builder(null);
    }

    protected static Builder builder(File configFile) {
        return new Builder(configFile);
    }

    public static class Builder {
        public static final String DC_ENV_VARIABLE_NAME = "METRICS_DATACENTER";
        public static final String NODE_GROUP_ENV_VARIABLE_NAME = "METRICS_NODE_GROUP";
        public static final String NODE_ID_ENV_VARIABLE_NAME = "METRICS_NODE_ID";
        public static final String NONE = "none";
        private String applicationName;
        private String datacenterName;
        private String nodeGroupName;
        private String nodeId;
        private MetricNamePostfixPolicy metricNamePostfixPolicy;
        private Boolean appendTypeToHealthCheckNames;
        private boolean enableSystemMetrics;
        private boolean enableTomcatMetrics;
        private GraphiteReporterConfig graphiteReporterConfig;
        private JmxReporterConfig jmxReporterConfig;
        private File configFile;

        private Builder(File configFile) {
            this.configFile = configFile;
            this.datacenterName = (String)StringUtils.defaultIfBlank((CharSequence)MetricNamingUtil.sanitize(System.getenv(DC_ENV_VARIABLE_NAME)), (CharSequence)NONE);
            this.nodeGroupName = (String)StringUtils.defaultIfBlank((CharSequence)MetricNamingUtil.sanitize(System.getenv(NODE_GROUP_ENV_VARIABLE_NAME)), (CharSequence)NONE);
            this.nodeId = (String)StringUtils.defaultIfBlank((CharSequence)MetricNamingUtil.sanitize(System.getenv(NODE_ID_ENV_VARIABLE_NAME)), (CharSequence)NONE);
            this.metricNamePostfixPolicy = MetricNamePostfixPolicy.ADD_COMPOSITE_TYPES;
            this.appendTypeToHealthCheckNames = false;
            this.enableSystemMetrics = false;
            this.enableTomcatMetrics = false;
        }

        public Builder applicationName(String applicationName) {
            if (StringUtils.isBlank((CharSequence)applicationName)) {
                throw new IllegalArgumentException("applicationName cannot be blank");
            }
            this.applicationName = MetricNamingUtil.sanitize(applicationName);
            return this;
        }

        public Builder datacenterName(String datacenterName) {
            this.datacenterName = (String)StringUtils.defaultIfBlank((CharSequence)MetricNamingUtil.sanitize(datacenterName), (CharSequence)this.datacenterName);
            return this;
        }

        public Builder nodeGroupName(String nodeGroupName) {
            this.nodeGroupName = (String)StringUtils.defaultIfBlank((CharSequence)MetricNamingUtil.sanitize(nodeGroupName), (CharSequence)this.nodeGroupName);
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = (String)StringUtils.defaultIfBlank((CharSequence)MetricNamingUtil.sanitize(nodeId), (CharSequence)this.nodeId);
            return this;
        }

        public Builder metricNamePostfixPolicy(MetricNamePostfixPolicy metricNamePostfixPolicy) {
            if (metricNamePostfixPolicy == null) {
                metricNamePostfixPolicy = MetricNamePostfixPolicy.ADD_COMPOSITE_TYPES;
            }
            this.metricNamePostfixPolicy = metricNamePostfixPolicy;
            return this;
        }

        public Builder appendTypeToHealthCheckNames(boolean appendTypeToHealthCheckNames) {
            this.appendTypeToHealthCheckNames = appendTypeToHealthCheckNames;
            return this;
        }

        public Builder enableSystemMetrics(boolean enableSystemMetrics) {
            this.enableSystemMetrics = enableSystemMetrics;
            return this;
        }

        public Builder enableTomcatMetrics(boolean enableTomcatMetrics) {
            this.enableTomcatMetrics = enableTomcatMetrics;
            return this;
        }

        public Builder graphiteReporterConfig(GraphiteReporterConfig graphiteReporterConfig) {
            this.graphiteReporterConfig = graphiteReporterConfig;
            return this;
        }

        public Builder jmxReporterConfig(JmxReporterConfig jmxReporterConfig) {
            this.jmxReporterConfig = jmxReporterConfig;
            return this;
        }

        public MonitoringCenterConfig build() {
            if (this.applicationName == null) {
                throw new IllegalStateException("applicationName cannot be blank");
            }
            return new MonitoringCenterConfig(this);
        }
    }
}

