/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.util;

import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatConnectorStatus;
import net.centro.rtb.monitoringcenter.metrics.tomcat.TomcatStatus;

public class TomcatStatusUtil {
    private TomcatStatusUtil() {
    }

    public static TomcatConnectorStatus getInternalHttpsConnectorStatus(TomcatStatus tomcatStatus) {
        return TomcatStatusUtil.getConnectorStatusImpl(tomcatStatus, true, true);
    }

    public static TomcatConnectorStatus getInternalHttpConnectorStatus(TomcatStatus tomcatStatus) {
        return TomcatStatusUtil.getConnectorStatusImpl(tomcatStatus, true, false);
    }

    public static TomcatConnectorStatus getHttpsConnectorStatus(TomcatStatus tomcatStatus) {
        return TomcatStatusUtil.getConnectorStatusImpl(tomcatStatus, false, true);
    }

    public static TomcatConnectorStatus getHttpConnectorStatus(TomcatStatus tomcatStatus) {
        return TomcatStatusUtil.getConnectorStatusImpl(tomcatStatus, false, false);
    }

    private static TomcatConnectorStatus getConnectorStatusImpl(TomcatStatus tomcatStatus, boolean isInternalPort, boolean isSecure) {
        if (tomcatStatus == null || tomcatStatus.getConnectorStatuses() == null) {
            return null;
        }
        for (TomcatConnectorStatus connectorStatus : tomcatStatus.getConnectorStatuses()) {
            if (connectorStatus.isInternalPort() != isInternalPort || connectorStatus.isSecure() != isSecure) continue;
            return connectorStatus;
        }
        return null;
    }
}

