/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;

public class GraphiteMetricFormatter {
    private double rateFactor;
    private double durationFactor;

    public GraphiteMetricFormatter(TimeUnit rateUnit, TimeUnit durationUnit) {
        Preconditions.checkNotNull((Object)((Object)rateUnit));
        Preconditions.checkNotNull((Object)((Object)durationUnit));
        this.rateFactor = rateUnit.toSeconds(1L);
        this.durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
    }

    public String format(SortedMap<String, Metric> metricsByNames) {
        Preconditions.checkNotNull(metricsByNames);
        long timestamp = System.nanoTime() / 1000L;
        StringBuilder outputBuilder = new StringBuilder();
        for (Map.Entry<String, Metric> entry : metricsByNames.entrySet()) {
            String metricOutput = null;
            if (Counter.class.isInstance(entry.getValue())) {
                metricOutput = this.formatCounter(entry.getKey(), (Counter)Counter.class.cast(entry.getValue()), timestamp);
            } else if (Gauge.class.isInstance(entry.getValue())) {
                metricOutput = this.formatGauge(entry.getKey(), (Gauge)Gauge.class.cast(entry.getValue()), timestamp);
            } else if (Timer.class.isInstance(entry.getValue())) {
                metricOutput = this.formatTimer(entry.getKey(), (Timer)Timer.class.cast(entry.getValue()), timestamp);
            } else if (Meter.class.isInstance(entry.getValue())) {
                metricOutput = this.formatMetered(entry.getKey(), (Metered)Meter.class.cast(entry.getValue()), timestamp);
            } else if (Histogram.class.isInstance(entry.getValue())) {
                metricOutput = this.formatHistogram(entry.getKey(), (Histogram)Histogram.class.cast(entry.getValue()), timestamp);
            }
            if (metricOutput == null) continue;
            outputBuilder.append(metricOutput);
        }
        return outputBuilder.toString();
    }

    private String formatCounter(String name, Counter counter, long timestamp) {
        return this.formatLine(MetricNamingUtil.join(name, "count"), counter.getCount(), timestamp);
    }

    private String formatGauge(String name, Gauge gauge, long timestamp) {
        String value = this.format(gauge.getValue());
        if (value != null) {
            return this.formatLine(name, value, timestamp);
        }
        return null;
    }

    private String formatTimer(String name, Timer timer, long timestamp) {
        Snapshot snapshot = timer.getSnapshot();
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(this.formatMetered(name, (Metered)timer, timestamp));
        outputBuilder.append(this.formatSamplingSnapshot(name, snapshot, timestamp, true));
        return outputBuilder.toString();
    }

    private String formatMetered(String name, Metered meter, long timestamp) {
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "count"), meter.getCount(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "m1_rate"), this.convertRate(meter.getOneMinuteRate()), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "m5_rate"), this.convertRate(meter.getFiveMinuteRate()), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "m15_rate"), this.convertRate(meter.getFifteenMinuteRate()), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "mean_rate"), this.convertRate(meter.getMeanRate()), timestamp));
        return outputBuilder.toString();
    }

    private String formatHistogram(String name, Histogram histogram, long timestamp) {
        Snapshot snapshot = histogram.getSnapshot();
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "count"), histogram.getCount(), timestamp));
        outputBuilder.append(this.formatSamplingSnapshot(name, snapshot, timestamp, false));
        return outputBuilder.toString();
    }

    private String formatSamplingSnapshot(String name, Snapshot snapshot, long timestamp, boolean convertValuesToDurations) {
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "max"), convertValuesToDurations ? this.convertDuration(snapshot.getMax()) : (double)snapshot.getMax(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "mean"), convertValuesToDurations ? this.convertDuration(snapshot.getMean()) : snapshot.getMean(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "min"), convertValuesToDurations ? this.convertDuration(snapshot.getMin()) : (double)snapshot.getMin(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "stddev"), convertValuesToDurations ? this.convertDuration(snapshot.getStdDev()) : snapshot.getStdDev(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "p50"), convertValuesToDurations ? this.convertDuration(snapshot.getMedian()) : snapshot.getMedian(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "p75"), convertValuesToDurations ? this.convertDuration(snapshot.get75thPercentile()) : snapshot.get75thPercentile(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "p95"), convertValuesToDurations ? this.convertDuration(snapshot.get95thPercentile()) : snapshot.get95thPercentile(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "p98"), convertValuesToDurations ? this.convertDuration(snapshot.get98thPercentile()) : snapshot.get98thPercentile(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "p99"), convertValuesToDurations ? this.convertDuration(snapshot.get99thPercentile()) : snapshot.get99thPercentile(), timestamp));
        outputBuilder.append(this.formatLine(MetricNamingUtil.join(name, "p999"), convertValuesToDurations ? this.convertDuration(snapshot.get999thPercentile()) : snapshot.get999thPercentile(), timestamp));
        return outputBuilder.toString();
    }

    private String formatLine(String name, Object value, long timestamp) {
        return name + " " + (value instanceof String ? value : this.format(value)) + " " + Long.valueOf(timestamp) + "\n";
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return null;
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    private double convertDuration(double duration) {
        return duration * this.durationFactor;
    }

    private double convertRate(double rate) {
        return rate * this.rateFactor;
    }
}

