/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ClassLoadingMetricSet
implements MetricSet {
    private ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private Gauge<Long> totalLoadedClassesGauge;
    private Gauge<Long> unloadedClassesGauge;
    private Gauge<Integer> currentlyLoadedClassesGauge;
    private Map<String, Metric> metricsByNames;

    ClassLoadingMetricSet() {
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        this.totalLoadedClassesGauge = new Gauge<Long>(){

            public Long getValue() {
                return ClassLoadingMetricSet.this.classLoadingMXBean.getTotalLoadedClassCount();
            }
        };
        metricsByNames.put("totalLoaded", (Metric)this.totalLoadedClassesGauge);
        this.unloadedClassesGauge = new Gauge<Long>(){

            public Long getValue() {
                return ClassLoadingMetricSet.this.classLoadingMXBean.getUnloadedClassCount();
            }
        };
        metricsByNames.put("unloaded", (Metric)this.unloadedClassesGauge);
        this.currentlyLoadedClassesGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return ClassLoadingMetricSet.this.classLoadingMXBean.getLoadedClassCount();
            }
        };
        metricsByNames.put("currentlyLoaded", (Metric)this.currentlyLoadedClassesGauge);
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    Gauge<Long> getTotalLoadedClassesGauge() {
        return this.totalLoadedClassesGauge;
    }

    Gauge<Long> getUnloadedClassesGauge() {
        return this.unloadedClassesGauge;
    }

    Gauge<Integer> getCurrentlyLoadedClassesGauge() {
        return this.currentlyLoadedClassesGauge;
    }
}

