/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.instrumented;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.centro.rtb.monitoringcenter.MetricCollector;

public class InstrumentedExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    private final Meter submittedMeter;
    private final Counter runningCounter;
    private final Meter completedMeter;
    private final Timer durationTimer;
    private final Meter rejectedMeter;

    public InstrumentedExecutorService(ExecutorService delegate, MetricCollector metricCollector, String name) {
        this.delegate = delegate;
        this.submittedMeter = metricCollector.getMeter(name, "submittedMeter");
        this.runningCounter = metricCollector.getCounter(name, "running");
        this.completedMeter = metricCollector.getMeter(name, "completedMeter");
        this.durationTimer = metricCollector.getTimer(name, "durationTimer");
        this.rejectedMeter = metricCollector.getMeter(name, "rejectedMeter");
    }

    @Override
    public void execute(Runnable runnable) {
        this.submittedMeter.mark();
        try {
            this.delegate.execute(new InstrumentedRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        this.submittedMeter.mark();
        try {
            return this.delegate.submit(new InstrumentedRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result) {
        this.submittedMeter.mark();
        try {
            return this.delegate.submit(new InstrumentedRunnable(runnable), result);
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.submittedMeter.mark();
        try {
            return this.delegate.submit(new InstrumentedCallable<T>(task));
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAll(instrumented);
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAll(instrumented, timeout, unit);
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAny(instrumented);
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.submittedMeter.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAny(instrumented, timeout, unit);
        }
        catch (RejectedExecutionException e) {
            this.rejectedMeter.mark();
            throw e;
        }
    }

    private <T> Collection<? extends Callable<T>> instrument(Collection<? extends Callable<T>> tasks) {
        ArrayList<InstrumentedCallable<T>> instrumented = new ArrayList<InstrumentedCallable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            instrumented.add(new InstrumentedCallable<T>(task));
        }
        return instrumented;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    private class InstrumentedCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;

        InstrumentedCallable(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            InstrumentedExecutorService.this.runningCounter.inc();
            Timer.Context context = InstrumentedExecutorService.this.durationTimer.time();
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                context.stop();
                InstrumentedExecutorService.this.runningCounter.dec();
                InstrumentedExecutorService.this.completedMeter.mark();
            }
        }
    }

    private class InstrumentedRunnable
    implements Runnable {
        private final Runnable task;

        InstrumentedRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            InstrumentedExecutorService.this.runningCounter.inc();
            Timer.Context context = InstrumentedExecutorService.this.durationTimer.time();
            try {
                this.task.run();
            }
            finally {
                context.stop();
                InstrumentedExecutorService.this.runningCounter.dec();
                InstrumentedExecutorService.this.completedMeter.mark();
            }
        }
    }
}

