/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.infos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.SystemUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JvmInfo {
    private String specVersion;
    private String classVersion;
    private String jreVersion;
    private String jreVendor;
    private String vmName;
    private String vmVendor;
    private String vmVersion;
    private List<String> inputArguments;
    private Date startedTimestamp;
    private String defaultTimeZone;
    private String defaultCharset;

    private JvmInfo() {
    }

    public static JvmInfo create() {
        JvmInfo jvmInfo = new JvmInfo();
        jvmInfo.specVersion = SystemUtils.JAVA_SPECIFICATION_VERSION;
        jvmInfo.classVersion = SystemUtils.JAVA_CLASS_VERSION;
        jvmInfo.jreVersion = SystemUtils.JAVA_VERSION;
        jvmInfo.jreVendor = SystemUtils.JAVA_VENDOR;
        jvmInfo.vmName = SystemUtils.JAVA_VM_NAME;
        jvmInfo.vmVendor = SystemUtils.JAVA_VM_VENDOR;
        jvmInfo.vmVersion = SystemUtils.JAVA_VM_VERSION;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        jvmInfo.inputArguments = new ArrayList<String>(runtimeMXBean.getInputArguments());
        jvmInfo.startedTimestamp = new Date(runtimeMXBean.getStartTime());
        jvmInfo.defaultTimeZone = TimeZone.getDefault().getID();
        jvmInfo.defaultCharset = Charset.defaultCharset().displayName();
        return jvmInfo;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getClassVersion() {
        return this.classVersion;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getJreVendor() {
        return this.jreVendor;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public List<String> getInputArguments() {
        return Collections.unmodifiableList(this.inputArguments);
    }

    public Date getStartedTimestamp() {
        return this.startedTimestamp;
    }

    public String getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }
}

