/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.config;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.centro.rtb.monitoringcenter.config.HostAndPort;

public class GraphiteReporterConfig {
    private boolean enableReporter;
    private HostAndPort address;
    private long reportingIntervalInSeconds;
    private boolean enableBatching;
    private boolean reportOnShutdown;
    private Set<String> startsWithFilters;
    private Set<String> blockedStartsWithFilters;

    private GraphiteReporterConfig(Builder builder) {
        this.enableReporter = builder.enableReporter;
        this.address = builder.address;
        this.reportingIntervalInSeconds = builder.reportingIntervalInSeconds;
        this.enableBatching = builder.enableBatching;
        this.reportOnShutdown = builder.reportOnShutdown;
        this.startsWithFilters = Collections.unmodifiableSet(builder.startsWithFilters);
        this.blockedStartsWithFilters = Collections.unmodifiableSet(builder.blockedStartsWithFilters);
    }

    public boolean isEnableReporter() {
        return this.enableReporter;
    }

    public HostAndPort getAddress() {
        return this.address;
    }

    public long getReportingIntervalInSeconds() {
        return this.reportingIntervalInSeconds;
    }

    public boolean isEnableBatching() {
        return this.enableBatching;
    }

    public boolean isReportOnShutdown() {
        return this.reportOnShutdown;
    }

    public Set<String> getStartsWithFilters() {
        return this.startsWithFilters;
    }

    public Set<String> getBlockedStartsWithFilters() {
        return this.blockedStartsWithFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphiteReporterConfig that = (GraphiteReporterConfig)o;
        if (this.enableReporter != that.enableReporter) {
            return false;
        }
        if (this.reportingIntervalInSeconds != that.reportingIntervalInSeconds) {
            return false;
        }
        if (this.enableBatching != that.enableBatching) {
            return false;
        }
        if (this.reportOnShutdown != that.reportOnShutdown) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.startsWithFilters != null ? !this.startsWithFilters.equals(that.startsWithFilters) : that.startsWithFilters != null) {
            return false;
        }
        return this.blockedStartsWithFilters != null ? this.blockedStartsWithFilters.equals(that.blockedStartsWithFilters) : that.blockedStartsWithFilters == null;
    }

    public int hashCode() {
        int result = this.enableReporter ? 1 : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (int)(this.reportingIntervalInSeconds ^ this.reportingIntervalInSeconds >>> 32);
        result = 31 * result + (this.enableBatching ? 1 : 0);
        result = 31 * result + (this.reportOnShutdown ? 1 : 0);
        result = 31 * result + (this.startsWithFilters != null ? this.startsWithFilters.hashCode() : 0);
        result = 31 * result + (this.blockedStartsWithFilters != null ? this.blockedStartsWithFilters.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GraphiteReporterConfig{");
        sb.append("enableReporter=").append(this.enableReporter);
        sb.append(", address=").append(this.address);
        sb.append(", reportingIntervalInSeconds=").append(this.reportingIntervalInSeconds);
        sb.append(", enableBatching=").append(this.enableBatching);
        sb.append(", reportOnShutdown=").append(this.reportOnShutdown);
        sb.append(", startsWithFilters=").append(this.startsWithFilters);
        sb.append(", blockedStartsWithFilters=").append(this.blockedStartsWithFilters);
        sb.append('}');
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final long DEFAULT_REPORTING_INTERVAL_IN_SECONDS = TimeUnit.MINUTES.toSeconds(1L);
        private boolean enableReporter = true;
        private HostAndPort address;
        private long reportingIntervalInSeconds = DEFAULT_REPORTING_INTERVAL_IN_SECONDS;
        private boolean enableBatching = true;
        private boolean reportOnShutdown = true;
        private Set<String> startsWithFilters = Collections.emptySet();
        private Set<String> blockedStartsWithFilters = Collections.emptySet();

        public Builder enableReporter(boolean enableReporter) {
            this.enableReporter = enableReporter;
            return this;
        }

        public Builder address(String host, int port) {
            this.address = HostAndPort.of(host, port);
            return this;
        }

        public Builder reportingInterval(long period, TimeUnit timeUnit) {
            if (period <= 0L) {
                throw new IllegalArgumentException("period must be positive");
            }
            if (timeUnit == null) {
                throw new IllegalArgumentException("timeUnit cannot be null");
            }
            this.reportingIntervalInSeconds = timeUnit.toSeconds(period);
            return this;
        }

        public Builder enableBatching(boolean enableBatching) {
            this.enableBatching = enableBatching;
            return this;
        }

        public Builder reportOnShutdown(boolean reportOnShutdown) {
            this.reportOnShutdown = reportOnShutdown;
            return this;
        }

        public Builder startsWithFilters(Set<String> startsWithFilters) {
            this.startsWithFilters = startsWithFilters == null ? Collections.emptySet() : startsWithFilters;
            return this;
        }

        public Builder blockedStartsWithFilters(Set<String> blockedStartsWithFilters) {
            this.blockedStartsWithFilters = blockedStartsWithFilters == null ? Collections.emptySet() : blockedStartsWithFilters;
            return this;
        }

        public GraphiteReporterConfig build() {
            if (this.address == null) {
                throw new IllegalStateException("address must be set");
            }
            return new GraphiteReporterConfig(this);
        }
    }
}

