/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter;

import com.codahale.metrics.Metric;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.json.HealthCheckModule;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.ThreadDump;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.centro.rtb.monitoringcenter.MonitoringCenter;
import net.centro.rtb.monitoringcenter.infos.ServerInfo;
import net.centro.rtb.monitoringcenter.util.GraphiteMetricFormatter;
import org.apache.commons.lang3.StringUtils;

public class MonitoringCenterServlet
extends HttpServlet {
    private static final String DEFAULT_CREDENTIALS = "monitoringCenter:d3faUlt~P4Ssw0rD";
    private static final String DISABLE_AUTHORIZATION_INIT_PARAM = "disableAuthorization";
    private static final String USERNAME_INIT_PARAM = "username";
    private static final String PASSWORD_INIT_PARAM = "password";
    private static final String PATH_METRICS = "/metrics";
    private static final String PATH_HEALTHCHECKS = "/healthChecks";
    private static final String PATH_PING = "/ping";
    private static final String PATH_THREADDUMP = "/threadDump";
    private static final String PATH_SYSTEM_INFO = "/systemInfo";
    private static final String PATH_NODE_INFO = "/nodeInfo";
    private static final String PATH_SERVER_INFO = "/serverInfo";
    private static final String PATH_APP_INFO = "/appInfo";
    public static final List<EndpointDescription> ENDPOINT_DESCRIPTIONS = Collections.unmodifiableList(new ArrayList<EndpointDescription>(){
        {
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_METRICS, "Retrieves current readings from registered metrics.").queryParam("format", "Serialization format. Supported formats are JSON (\"json\") and Graphite-ready string (\"graphite\"). By default, JSON will be served.").queryParam("startsWithFilter", "Filters to be applied to metric names. A filter can include multiple wildcards, expressed as \"*\". Multiple filters can be specified; at least one filter must match for a metric to be included in the response. The filters are applied to the actual metric name, with no regard to the node-specific prefix. By default, all registered metrics will be returned.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Only applies to JSON. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed.").queryParam("appendPrefix", "Indicates whether to append the node-specific prefix to metric names or not. Boolean values must be specified as \"true\" or \"false\". By default, the prefix will not be appended."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_HEALTHCHECKS, "Runs all registered health checks and returns their results as JSON.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed."));
            this.add(new EndpointDescription("/healthChecks/{healthCheckName}", "Runs a health check represented by {healthCheckName} and returns its result as JSON.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_PING, "\"Pings\" the node. The expected output is \"pong\"."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_THREADDUMP, "Generates a Java thread dump and returns its output as text."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_SYSTEM_INFO, "Retrieves system information, which consists of operating system and JVM data points.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_NODE_INFO, "Retrieves node information, including node nomenclature and networking set-up.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_SERVER_INFO, "Retrieves HTTP server information.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed."));
            this.add(new EndpointDescription(MonitoringCenterServlet.PATH_APP_INFO, "Retrieves app information, including build-related data points.").queryParam("prettyPrint", "Indicates whether to nicely format the output or not. Boolean values must be specified as \"true\" or \"false\". By default, the output will not be pretty printed."));
        }
    });
    private static final String FORMAT_GRAPHITE = "graphite";
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String PING_RESPONSE = "pong";
    private ObjectMapper objectMapper;
    private GraphiteMetricFormatter graphiteMetricFormatter;
    private ThreadDump threadDumpGenerator;
    private String encodedCredentials;
    private ServerInfo serverInfo;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        boolean disableAuthorization = Boolean.TRUE.toString().equalsIgnoreCase(servletConfig.getInitParameter(DISABLE_AUTHORIZATION_INIT_PARAM));
        if (!disableAuthorization) {
            String credentials = null;
            String username = servletConfig.getInitParameter(USERNAME_INIT_PARAM);
            String password = servletConfig.getInitParameter(PASSWORD_INIT_PARAM);
            credentials = StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) ? username.trim() + ":" + password.trim() : DEFAULT_CREDENTIALS;
            this.encodedCredentials = BaseEncoding.base64().encode(credentials.getBytes());
        }
        this.objectMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MICROSECONDS, false)).registerModule((Module)new HealthCheckModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL).setTimeZone(TimeZone.getDefault()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z"));
        this.graphiteMetricFormatter = new GraphiteMetricFormatter(TimeUnit.SECONDS, TimeUnit.MICROSECONDS);
        try {
            this.threadDumpGenerator = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (NoClassDefFoundError credentials) {
            // empty catch block
        }
        ServletContext servletContext = servletConfig.getServletContext();
        String servletSpecVersion = servletContext.getMajorVersion() + "." + servletContext.getMinorVersion();
        this.serverInfo = ServerInfo.create(servletContext.getServerInfo(), servletSpecVersion);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Expires", "Tue, 11 Oct 1977 12:34:56 GMT");
        if (!this.checkAuthorization(httpServletRequest)) {
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"Centro Monitoring Center\"");
            httpServletResponse.setStatus(401);
            return;
        }
        String path = httpServletRequest.getPathInfo();
        if (path == null || path.equals("/")) {
            this.handlePathDescriptions(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_METRICS)) {
            this.handleMetrics(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_HEALTHCHECKS)) {
            this.handleHealthChecks(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_PING)) {
            this.handlePing(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_THREADDUMP)) {
            this.handleThreadDump(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_SYSTEM_INFO)) {
            this.handleSystemInfo(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_NODE_INFO)) {
            this.handleNodeInfo(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_SERVER_INFO)) {
            this.handleServerInfo(httpServletRequest, httpServletResponse);
        } else if (path.startsWith(PATH_APP_INFO)) {
            this.handleAppInfo(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(404);
        }
    }

    private void handlePathDescriptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.writeAsJson(httpServletRequest, httpServletResponse, ENDPOINT_DESCRIPTIONS);
    }

    private void handleMetrics(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String format = StringUtils.trimToNull((String)httpServletRequest.getParameter("format"));
        String[] startsWithFilters = httpServletRequest.getParameterValues("startsWithFilter");
        if (FORMAT_GRAPHITE.equalsIgnoreCase(format)) {
            httpServletResponse.setContentType(CONTENT_TYPE_TEXT_PLAIN);
            try (PrintWriter printWriter = httpServletResponse.getWriter();){
                SortedMap<String, Metric> metricsByNames = MonitoringCenter.getMetricsByNames(true, startsWithFilters);
                printWriter.write(this.graphiteMetricFormatter.format(metricsByNames));
            }
        } else {
            boolean appendPrefix = Boolean.TRUE.toString().equalsIgnoreCase(StringUtils.trimToNull((String)httpServletRequest.getParameter("appendPrefix")));
            LinkedHashMap<String, SortedMap<String, Object>> responseMap = new LinkedHashMap<String, SortedMap<String, Object>>();
            responseMap.put("gauges", MonitoringCenter.getGaugesByNames(appendPrefix, startsWithFilters));
            responseMap.put("counters", MonitoringCenter.getCountersByNames(appendPrefix, startsWithFilters));
            responseMap.put("histograms", MonitoringCenter.getHistogramsByNames(appendPrefix, startsWithFilters));
            responseMap.put("meters", MonitoringCenter.getMetersByNames(appendPrefix, startsWithFilters));
            responseMap.put("timers", MonitoringCenter.getTimersByNames(appendPrefix, startsWithFilters));
            this.writeAsJson(httpServletRequest, httpServletResponse, responseMap);
        }
    }

    private void handleHealthChecks(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String noLeadingSlash;
        int indexOfSlash;
        String healthCheckName = null;
        String path = httpServletRequest.getPathInfo();
        if (StringUtils.isNotBlank((CharSequence)path) && (indexOfSlash = (noLeadingSlash = path.substring(1)).indexOf("/")) != -1) {
            healthCheckName = noLeadingSlash.substring(indexOfSlash + 1);
        }
        if (StringUtils.isNotBlank(healthCheckName)) {
            try {
                HealthCheck.Result result = MonitoringCenter.runHealthCheck(healthCheckName);
                this.writeAsJson(httpServletRequest, httpServletResponse, result);
            }
            catch (NoSuchElementException e) {
                httpServletResponse.sendError(404);
                return;
            }
        } else {
            SortedMap<String, HealthCheck.Result> healthCheckResultsByNames = MonitoringCenter.runHealthChecks();
            this.writeAsJson(httpServletRequest, httpServletResponse, healthCheckResultsByNames);
        }
    }

    private void handlePing(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType(CONTENT_TYPE_TEXT_PLAIN);
        try (PrintWriter writer = httpServletResponse.getWriter();){
            writer.println(PING_RESPONSE);
        }
    }

    private void handleThreadDump(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType(CONTENT_TYPE_TEXT_PLAIN);
        if (this.threadDumpGenerator == null) {
            try (PrintWriter writer = httpServletResponse.getWriter();){
                writer.println("Thread dump generation is not supported on this node.");
            }
        }
        try (ServletOutputStream output = httpServletResponse.getOutputStream();){
            this.threadDumpGenerator.dump((OutputStream)output);
        }
    }

    private void handleSystemInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.writeAsJson(httpServletRequest, httpServletResponse, MonitoringCenter.getSystemInfo());
    }

    private void handleNodeInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.writeAsJson(httpServletRequest, httpServletResponse, MonitoringCenter.getNodeInfo());
    }

    private void handleAppInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.writeAsJson(httpServletRequest, httpServletResponse, MonitoringCenter.getAppInfo());
    }

    private void handleServerInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.writeAsJson(httpServletRequest, httpServletResponse, this.serverInfo);
    }

    private void writeAsJson(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        boolean prettyPrint = Boolean.TRUE.toString().equalsIgnoreCase(StringUtils.trimToNull((String)httpServletRequest.getParameter("prettyPrint")));
        httpServletResponse.setContentType(CONTENT_TYPE_APPLICATION_JSON);
        try (ServletOutputStream output = httpServletResponse.getOutputStream();){
            if (prettyPrint) {
                this.objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)output, object);
            } else {
                this.objectMapper.writeValue((OutputStream)output, object);
            }
        }
    }

    private boolean checkAuthorization(HttpServletRequest httpServletRequest) {
        int indexOfSpace;
        if (this.encodedCredentials == null) {
            return true;
        }
        String basicAuthHeader = httpServletRequest.getHeader("Authorization");
        if (basicAuthHeader != null && basicAuthHeader.toUpperCase().startsWith("BASIC") && (indexOfSpace = basicAuthHeader.indexOf(32)) > 0) {
            String credentials = basicAuthHeader.substring(indexOfSpace).trim();
            return this.encodedCredentials.equals(credentials);
        }
        return false;
    }

    public static class EndpointDescription {
        @JsonProperty
        private final String path;
        @JsonProperty
        private final String description;
        @JsonProperty
        private Map<String, String> queryParams;

        private EndpointDescription(String path, String description) {
            this.path = path;
            this.description = description;
        }

        private EndpointDescription queryParam(String queryParamName, String description) {
            if (this.queryParams == null) {
                this.queryParams = new HashMap<String, String>();
            }
            this.queryParams.put(queryParamName, description);
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, String> getQueryParams() {
            if (this.queryParams != null) {
                return Collections.unmodifiableMap(this.queryParams);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("EndpointDescription{");
            sb.append("path='").append(this.path).append('\'');
            sb.append(", description='").append(this.description).append('\'');
            sb.append(", queryParams=").append(this.queryParams);
            sb.append('}');
            return sb.toString();
        }
    }
}

