/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.search.engines;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.cassite.search.Content;
import net.cassite.search.Engine;
import net.cassite.search.Method;
import net.cassite.search.Request;
import net.cassite.search.Result;
import net.cassite.search.Title;
import net.cassite.search.Url;
import net.cassite.search.Utils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class SogouEngine
implements Engine {
    private static final String BASE_URL = "https://www.sogou.com/web?query=";
    private boolean allowEmptyTitle = false;
    private boolean allowEmptyContent = false;
    private boolean allowEmptyLink = false;
    private boolean allowEmptyCite = true;

    public SogouEngine allowEmptyTitle(boolean allowEmptyTitle) {
        this.allowEmptyTitle = allowEmptyTitle;
        return this;
    }

    public SogouEngine allowEmptyContent(boolean allowEmptyContent) {
        this.allowEmptyContent = allowEmptyContent;
        return this;
    }

    public SogouEngine setAllowEmptyLink(boolean allowEmptyLink) {
        this.allowEmptyLink = allowEmptyLink;
        return this;
    }

    public SogouEngine allowEmptyDomain(boolean allowEmptyCite) {
        this.allowEmptyCite = allowEmptyCite;
        return this;
    }

    @Override
    public String buildURL(Request request) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String s : request.getKeywords()) {
            sb.append(s).append(" ");
        }
        if (request.getSite() != null) {
            sb.append("site:").append(request.getSite()).append(" ");
        }
        return BASE_URL + URLEncoder.encode(sb.toString().trim(), "UTF-8") + "&page=" + (request.getPage() + 1);
    }

    @Override
    public Method method() {
        return Method.GET;
    }

    @Override
    public List<Result> extract(Document document) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        Elements elems = document.select("#main>div>.results").first().children();
        for (Element e : elems) {
            Element cite_elem;
            StringBuilder sb;
            Element content_elem;
            StringBuilder sb2;
            Element title_elem;
            String title = "";
            LinkedHashMap<Integer, String> title_keywords = new LinkedHashMap<Integer, String>();
            String content = "";
            LinkedHashMap<Integer, String> content_keywords = new LinkedHashMap<Integer, String>();
            String link = "";
            String cite = "";
            if (e.classNames().contains("vrwrap")) {
                title_elem = e.select(".vrTitle>a").first();
                if (title_elem != null) {
                    link = title_elem.attr("href").trim();
                    sb2 = new StringBuilder();
                    SogouEngine.parseHtmlIntoResult(title_elem.childNodes(), sb2, title_keywords);
                    title = sb2.toString().trim();
                }
                if ((content_elem = e.select(".strBox>.str_info_div>p").first()) == null) {
                    content_elem = e.select(".strBox>.str_info_div>.str-text-info").first();
                }
                if (content_elem != null) {
                    sb = new StringBuilder();
                    SogouEngine.parseHtmlIntoResult(content_elem.childNodes(), sb, content_keywords);
                    content = sb.toString().trim();
                }
                if ((cite_elem = e.select(".strBox>.str_info_div>.fb>cite").first()) != null) {
                    cite = Utils.replaceHtmlEscape(cite_elem.html().replaceAll("<[^<]*>", "").trim());
                }
            } else if (e.classNames().contains("rb")) {
                title_elem = e.select("h3>a").first();
                if (title_elem != null) {
                    link = title_elem.attr("href").trim();
                    sb2 = new StringBuilder();
                    SogouEngine.parseHtmlIntoResult(title_elem.childNodes(), sb2, title_keywords);
                    title = sb2.toString().trim();
                }
                if ((content_elem = e.select(".ft").first()) != null) {
                    sb = new StringBuilder();
                    SogouEngine.parseHtmlIntoResult(content_elem.childNodes(), sb, content_keywords);
                    content = sb.toString().trim();
                }
                if ((cite_elem = e.select(".fb>cite").first()) != null) {
                    cite = Utils.replaceHtmlEscape(cite_elem.html().replaceAll("<[^<]*>", "").trim());
                }
            }
            if (title.isEmpty() && !this.allowEmptyTitle || content.isEmpty() && !this.allowEmptyContent || link.isEmpty() && !this.allowEmptyLink || cite.isEmpty() && !this.allowEmptyCite) continue;
            Result result = new Result();
            Content con = new Content();
            con.setContent(content);
            con.getKeywords().putAll(content_keywords);
            result.setContent(con);
            Title tit = new Title();
            tit.setTitle(title);
            tit.getKeyWord().putAll(title_keywords);
            result.setTitle(tit);
            Url u = new Url();
            u.setCite(cite);
            u.setLink(link);
            result.setUrl(u);
            results.add(result);
        }
        return results;
    }

    @Override
    public String UA() {
        return "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4";
    }

    private static void parseHtmlIntoResult(List<Node> nodes, StringBuilder sb, Map<Integer, String> keywords) {
        for (Node child : nodes) {
            if (child instanceof TextNode) {
                sb.append(Utils.replaceHtmlEscape(((TextNode)child).text()));
                continue;
            }
            if (!(child instanceof Element)) continue;
            if (child.nodeName().equals("em")) {
                String keyword = Utils.replaceHtmlEscape(((Element)child).html().replaceAll("<[^<]*>", "").trim());
                keywords.put(sb.length(), keyword);
                sb.append(keyword);
                continue;
            }
            SogouEngine.parseHtmlIntoResult(child.childNodes(), sb, keywords);
        }
    }
}

