/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.search.engines;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.cassite.search.Content;
import net.cassite.search.Engine;
import net.cassite.search.Method;
import net.cassite.search.Request;
import net.cassite.search.Result;
import net.cassite.search.Title;
import net.cassite.search.Url;
import net.cassite.search.Utils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class BingEngine
implements Engine {
    private static final String BASE_URL = "http://cn.bing.com/search?q=";
    private boolean allowEmptyTitle = false;
    private boolean allowEmptyContent = false;
    private boolean allowEmptyLink = false;
    private boolean allowEmptyCite = true;

    public BingEngine allowEmptyTitle(boolean allowEmptyTitle) {
        this.allowEmptyTitle = allowEmptyTitle;
        return this;
    }

    public BingEngine allowEmptyContent(boolean allowEmptyContent) {
        this.allowEmptyContent = allowEmptyContent;
        return this;
    }

    public BingEngine setAllowEmptyLink(boolean allowEmptyLink) {
        this.allowEmptyLink = allowEmptyLink;
        return this;
    }

    public BingEngine allowEmptyCite(boolean allowEmptyCite) {
        this.allowEmptyCite = allowEmptyCite;
        return this;
    }

    @Override
    public String buildURL(Request request) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String s : request.getKeywords()) {
            sb.append(s).append(" ");
        }
        if (request.getSite() != null) {
            sb.append("site:").append(request.getSite()).append(" ");
        }
        return BASE_URL + URLEncoder.encode(sb.toString().trim(), "UTF-8") + "&first=" + (request.getPage() * 10 + 1);
    }

    @Override
    public Method method() {
        return Method.GET;
    }

    @Override
    public List<Result> extract(Document document) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        Elements elems = document.select("#b_results>.b_algo");
        for (Element e : elems) {
            Element cite_elem;
            Element content_elem;
            String title = "";
            LinkedHashMap<Integer, String> title_keywords = new LinkedHashMap<Integer, String>();
            String content = "";
            LinkedHashMap<Integer, String> content_keywords = new LinkedHashMap<Integer, String>();
            String link = "";
            String cite = "";
            Element title_elem = e.select("h2>a").first();
            if (title_elem != null) {
                link = title_elem.attr("href").trim();
                StringBuilder title_sb = new StringBuilder();
                BingEngine.parseHtmlIntoResult(title_elem.childNodes(), title_sb, title_keywords);
                title = title_sb.toString().trim();
            }
            if ((content_elem = e.select(".b_caption>p").first()) != null) {
                StringBuilder content_sb = new StringBuilder();
                BingEngine.parseHtmlIntoResult(content_elem.childNodes(), content_sb, content_keywords);
                content = content.isEmpty() ? content_sb.toString().trim() : content + content_sb.toString().trim();
            }
            if ((cite_elem = e.select(".b_caption>.b_attribution>cite").first()) != null) {
                cite = cite_elem.html().trim();
            }
            if (title.isEmpty() && !this.allowEmptyTitle || content.isEmpty() && !this.allowEmptyContent || link.isEmpty() && !this.allowEmptyLink || cite.isEmpty() && !this.allowEmptyCite) continue;
            Result result = new Result();
            Content con = new Content();
            con.setContent(content);
            con.getKeywords().putAll(content_keywords);
            result.setContent(con);
            Title tit = new Title();
            tit.setTitle(title);
            tit.getKeyWord().putAll(title_keywords);
            result.setTitle(tit);
            Url u = new Url();
            u.setCite(cite);
            u.setLink(link);
            result.setUrl(u);
            results.add(result);
        }
        return results;
    }

    @Override
    public String UA() {
        return "Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30";
    }

    private static void parseHtmlIntoResult(List<Node> nodes, StringBuilder sb, Map<Integer, String> keywords) {
        for (Node child : nodes) {
            if (child instanceof TextNode) {
                sb.append(Utils.replaceHtmlEscape(((TextNode)child).text()));
                continue;
            }
            if (!(child instanceof Element)) continue;
            if (child.nodeName().equals("strong")) {
                String keyword = Utils.replaceHtmlEscape(((Element)child).html());
                keywords.put(sb.length(), keyword);
                sb.append(keyword);
                continue;
            }
            if (!child.attr("mb_ok_tag").isEmpty()) continue;
            BingEngine.parseHtmlIntoResult(child.childNodes(), sb, keywords);
        }
    }
}

