/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.search.engines;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.cassite.search.Content;
import net.cassite.search.Engine;
import net.cassite.search.Method;
import net.cassite.search.Request;
import net.cassite.search.Result;
import net.cassite.search.Title;
import net.cassite.search.Url;
import net.cassite.search.Utils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class BaiduEngine
implements Engine {
    private static final String BASE_URL = "http://m.baidu.com/s?word=";
    private boolean allowEmptyTitle = false;
    private boolean allowEmptyContent = false;
    private boolean allowJavaScriptLink = false;
    private boolean allowEmptyLink = false;
    private boolean allowEmptyCite = true;

    public BaiduEngine allowEmptyTitle(boolean allowEmptyTitle) {
        this.allowEmptyTitle = allowEmptyTitle;
        return this;
    }

    public BaiduEngine allowEmptyContent(boolean allowEmptyContent) {
        this.allowEmptyContent = allowEmptyContent;
        return this;
    }

    public BaiduEngine allowJavaScriptLink(boolean allowJavaScriptLink) {
        this.allowJavaScriptLink = allowJavaScriptLink;
        return this;
    }

    public BaiduEngine setAllowEmptyLink(boolean allowEmptyLink) {
        this.allowEmptyLink = allowEmptyLink;
        return this;
    }

    public BaiduEngine allowEmptyCite(boolean allowEmptyCite) {
        this.allowEmptyCite = allowEmptyCite;
        return this;
    }

    @Override
    public String buildURL(Request request) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String s : request.getKeywords()) {
            sb.append(s).append(" ");
        }
        if (request.getSite() != null) {
            sb.append("site:").append(request.getSite()).append(" ");
        }
        return BASE_URL + URLEncoder.encode(sb.toString().trim(), "UTF-8") + "&pn=" + request.getPage() * 10;
    }

    @Override
    public Method method() {
        return Method.GET;
    }

    @Override
    public List<Result> extract(Document document) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        Elements elems = document.select("#results>.result.c-result>.c-container");
        for (Element elem : elems) {
            Node txt;
            List childNodes;
            Element c_color_url;
            String title = "";
            LinkedHashMap<Integer, String> title_keywords = new LinkedHashMap<Integer, String>();
            String content = "";
            LinkedHashMap<Integer, String> content_keywords = new LinkedHashMap<Integer, String>();
            String url = "";
            for (Element e : elem.select(".c-blocka")) {
                Elements c_titles = e.select(".c-title");
                if (c_titles.isEmpty()) {
                    StringBuilder content_sb = new StringBuilder();
                    BaiduEngine.parseHtmlIntoResult(e.childNodes(), content_sb, content_keywords);
                    if (content.isEmpty()) {
                        content = content_sb.toString();
                        continue;
                    }
                    String newContent = content_sb.toString().trim();
                    if (newContent.isEmpty()) continue;
                    content = content + " " + newContent;
                    continue;
                }
                url = e.attr("href").trim();
                Element title_elem = c_titles.first();
                StringBuilder title_sb = new StringBuilder();
                BaiduEngine.parseHtmlIntoResult(title_elem.childNodes(), title_sb, title_keywords);
                title = title_sb.toString();
            }
            title = title.trim();
            content = content.trim();
            if (title.isEmpty() && !this.allowEmptyTitle || content.isEmpty() && !this.allowEmptyContent || url.startsWith("javascript:") && !this.allowJavaScriptLink || url.isEmpty() && !this.allowEmptyLink) continue;
            String cite = "";
            Element c_showurl_span = elem.select(".c-showurl>span").first();
            if (c_showurl_span != null) {
                cite = c_showurl_span.html().trim();
            }
            if (cite.isEmpty() && (c_color_url = elem.select(".c-color-url").first()) != null && !(childNodes = c_color_url.childNodes()).isEmpty() && (txt = (Node)childNodes.get(0)) instanceof TextNode) {
                cite = ((TextNode)txt).text();
            }
            if (cite.isEmpty() && !this.allowEmptyCite) continue;
            Result result = new Result();
            Content con = new Content();
            con.setContent(content);
            con.getKeywords().putAll(content_keywords);
            result.setContent(con);
            Title tit = new Title();
            tit.setTitle(title);
            tit.getKeyWord().putAll(title_keywords);
            result.setTitle(tit);
            Url u = new Url();
            u.setCite(cite);
            u.setLink(url);
            result.setUrl(u);
            results.add(result);
        }
        return results;
    }

    private static void parseHtmlIntoResult(List<Node> nodes, StringBuilder sb, Map<Integer, String> keywords) {
        for (Node child : nodes) {
            if (child instanceof TextNode) {
                sb.append(Utils.replaceHtmlEscape(((TextNode)child).text()));
                continue;
            }
            if (!(child instanceof Element)) continue;
            if (child.nodeName().equals("em")) {
                String keyword = Utils.replaceHtmlEscape(((Element)child).html());
                keywords.put(sb.length(), keyword);
                sb.append(keyword);
                continue;
            }
            if (child.nodeName().equals("i") || child.nodeName().equals("button")) continue;
            BaiduEngine.parseHtmlIntoResult(child.childNodes(), sb, keywords);
        }
    }

    @Override
    public String UA() {
        return "Mozilla/5.0 (Linux; U; Android 4.1; en-us; GT-N7100 Build/JRO03C) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30";
    }
}

