/*
 * Decompiled with CFR 0.152.
 */
package net.cassite.search;

import java.util.List;
import net.cassite.search.DocumentProvider;
import net.cassite.search.Engine;
import net.cassite.search.Request;
import net.cassite.search.Result;
import net.cassite.search.provider.JsoupDocProvider;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search {
    private static final Logger LOGGER = LoggerFactory.getLogger(Search.class);
    private final Engine engine;
    private DocumentProvider documentProvider = JsoupDocProvider.get();

    public Search documentProvider(DocumentProvider documentProvider) {
        if (documentProvider == null) {
            throw new NullPointerException();
        }
        this.documentProvider = documentProvider;
        return this;
    }

    public Search(Engine engine) {
        if (engine == null) {
            throw new NullPointerException();
        }
        this.engine = engine;
    }

    public List<Result> search(String keyword) throws Exception {
        Request request = new Request();
        request.getKeywords().add(keyword);
        return this.search(request);
    }

    public List<Result> search(Request request) throws Exception {
        LOGGER.debug("Engine : {}", (Object)this.engine);
        LOGGER.debug("Request : {}", (Object)request);
        if (request == null) {
            throw new NullPointerException();
        }
        for (String s : request.getKeywords()) {
            if (s != null) continue;
            throw new NullPointerException("keyword list contains null strings");
        }
        String url = this.engine.buildURL(request);
        LOGGER.debug("BuildURL Result : {}", (Object)url);
        if (url == null) {
            throw new NullPointerException();
        }
        DocumentProvider.Arguments arguments = new DocumentProvider.Arguments();
        arguments.method = this.engine.method();
        arguments.UA = this.engine.UA();
        arguments.url = url;
        long start = System.currentTimeMillis();
        Document document = this.documentProvider.provideWith(arguments);
        long end = System.currentTimeMillis();
        LOGGER.debug("Connection Time : {} ms", (Object)(end - start));
        start = System.currentTimeMillis();
        List<Result> res = this.engine.extract(document);
        end = System.currentTimeMillis();
        LOGGER.debug("Extract Time : {} ms", (Object)(end - start));
        LOGGER.debug("Extract Result : {}", res);
        if (res == null) {
            throw new NullPointerException("the result should not be null");
        }
        LOGGER.debug("Extract Result Size : {}", (Object)res.size());
        return res;
    }
}

