/*
 * Decompiled with CFR 0.152.
 */
package ru.infon.queuebox.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.c0f3.queuebox.mongo.MongoRoutedQueueStatistic;
import org.bson.Document;
import ru.infon.queuebox.QueueBox;
import ru.infon.queuebox.RoutedMessage;
import ru.infon.queuebox.common.PropertiesBox;
import ru.infon.queuebox.mongo.MongoConnection;
import ru.infon.queuebox.mongo.MongoRoutedQueueBehave;

public class MongoRoutedQueueBox<T extends RoutedMessage>
extends QueueBox<T> {
    public static final String PROPERTY_THREADS_COUNT = "queue.threads.count";
    private static final int DEFAULT_THREADS_COUNT = 10;
    private ExecutorService localExecutor;
    private final MongoCollection<Document> collection;
    private final int threadsCount;
    private final Class<T> packetClass;

    public MongoRoutedQueueBox(Properties properties, Class<T> packetCLass) {
        super(new PropertiesBox(properties), packetCLass);
        this.packetClass = packetCLass;
        MongoConnection connection = new MongoConnection(properties);
        this.collection = connection.getMongoCollection(Document.class);
        this.threadsCount = this.getProperties().tryGetIntProperty(PROPERTY_THREADS_COUNT, connection.getConnectionPoolSize());
    }

    public MongoRoutedQueueBox(MongoDatabase mongoDatabase, Properties properties, Class<T> packetCLass) {
        super(new PropertiesBox(properties), packetCLass);
        this.packetClass = packetCLass;
        properties.put("default.mongodb.database", "ignored-value");
        MongoConnection connection = new MongoConnection(properties);
        this.collection = mongoDatabase.getCollection(connection.getMongoCollectionName());
        this.threadsCount = this.getProperties().tryGetIntProperty(PROPERTY_THREADS_COUNT, 10);
    }

    @Override
    public void start() {
        this.withStatistic(new MongoRoutedQueueStatistic());
        if (this.behave == null) {
            this.withQueueBehave(new MongoRoutedQueueBehave<T>(this.collection, this.getProperties(), this.packetClass));
        }
        if (this.executor == null) {
            this.localExecutor = Executors.newFixedThreadPool(this.threadsCount + 1);
            this.withExecutorService(this.localExecutor);
        }
        super.start();
    }
}

