/*
 * Decompiled with CFR 0.152.
 */
package ru.infon.queuebox.mongo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.bson.Document;
import ru.infon.queuebox.QueueSerializer;

public class MongoJacksonSerializer<T>
implements QueueSerializer<T> {
    private Class<T> objectClass;
    private ObjectMapper mapper;

    public MongoJacksonSerializer(Class<T> objectClass) {
        this.objectClass = objectClass;
        this.mapper = new ObjectMapper();
    }

    @Override
    public Document serialize(T object) {
        JsonNode node = this.mapper.valueToTree(object);
        return (Document)this.mapper.convertValue((Object)node, Document.class);
    }

    @Override
    public T deserialize(Document document) {
        return (T)this.mapper.convertValue((Object)document, this.objectClass);
    }

    @Override
    public Class<T> getObjectClass() {
        return this.objectClass;
    }
}

