/*
 * Decompiled with CFR 0.152.
 */
package ru.infon.queuebox.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.internal.MongoClientImpl;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class MongoConnection {
    public static final String MONGO_DB_URL = "default.mongodb.uri";
    public static final String MONGO_DB_DB = "default.mongodb.database";
    public static final String MONGO_DB_USER = "default.mongodb.user";
    public static final String MONGO_DB_PASSWORD = "default.mongodb.password";
    public static final String MONGO_QUEUE_COLLECTION_NAME = "mongodb.queue.collection";
    private static final int DEFAULT_CONNECTIONS_COUNT = 10;
    private final AtomicReference<MongoClient> client = new AtomicReference();
    private final MongoClientSettings.Builder optionsBuilder;
    private String mongoDBName;
    private String mongoDBUser;
    private String mongoCollectionName;
    private char[] mongoDBPassword;
    private MongoClientSettings clientSettings;
    private final Object syncFlag = new Object();

    public MongoConnection(Properties properties) {
        this.optionsBuilder = MongoClientSettings.builder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.equals(MONGO_DB_URL)) {
                ConnectionString connectionString = new ConnectionString(value);
                this.optionsBuilder.applyConnectionString(connectionString);
                continue;
            }
            if (key.equals(MONGO_DB_DB)) {
                this.mongoDBName = value;
                continue;
            }
            if (key.equals(MONGO_DB_USER)) {
                this.mongoDBUser = value;
                continue;
            }
            if (key.startsWith(MONGO_DB_PASSWORD)) {
                this.mongoDBPassword = value.toCharArray();
                continue;
            }
            if (!key.startsWith(MONGO_QUEUE_COLLECTION_NAME)) continue;
            this.mongoCollectionName = value;
        }
        if (this.mongoDBName == null) {
            throw new RuntimeException("Mandatory property \"database\" not found");
        }
        WriteConcern writeConcern = WriteConcern.W1;
        writeConcern.withJournal(Boolean.valueOf(true));
        writeConcern.withWTimeout(0L, TimeUnit.MILLISECONDS);
        this.optionsBuilder.writeConcern(writeConcern);
    }

    private MongoClient initMongoClient() {
        if (this.mongoDBUser != null && this.mongoDBPassword != null) {
            this.optionsBuilder.credential(MongoCredential.createCredential((String)this.mongoDBUser, (String)this.mongoDBName, (char[])this.mongoDBPassword));
        }
        MongoDriverInformation driverInfo = MongoDriverInformation.builder().build();
        this.clientSettings = this.optionsBuilder.build();
        return new MongoClientImpl(this.clientSettings, driverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoClient lazyInitMongoClient() {
        MongoClient result = this.client.get();
        if (result == null) {
            Object object = this.syncFlag;
            synchronized (object) {
                result = this.client.get();
                if (result != null) {
                    return result;
                }
                result = this.initMongoClient();
                if (!this.client.compareAndSet(null, result)) {
                    throw new IllegalStateException("lazy MongoClient initialization failed");
                }
            }
        }
        return result;
    }

    public void close() {
        this.getMongoClient().close();
    }

    public int getConnectionPoolSize() {
        if (this.clientSettings != null) {
            return this.clientSettings.getConnectionPoolSettings().getMaxSize();
        }
        return 10;
    }

    private MongoClient getMongoClient() {
        return this.lazyInitMongoClient();
    }

    public String getDatabaseName() {
        return this.mongoDBName;
    }

    public String getMongoCollectionName() {
        return this.mongoCollectionName;
    }

    public MongoDatabase getDatabase() {
        return this.getMongoClient().getDatabase(this.getDatabaseName());
    }

    public <D> MongoCollection<D> getMongoCollection(Class<D> documentCLass) {
        return this.getDatabase().getCollection(this.getMongoCollectionName(), documentCLass);
    }
}

