/*
 * Decompiled with CFR 0.152.
 */
package net.c0f3.queuebox.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoQueueCoreIndexes<T> {
    public static final int INDEX_CREATION_ATTEMPTS = 5;
    private static final Logger LOGGER = Logger.getLogger(MongoQueueCoreIndexes.class.getCanonicalName());
    private final MongoCollection<T> collection;

    public MongoQueueCoreIndexes(MongoCollection<T> mongoCollection) {
        this.collection = mongoCollection;
    }

    private String generateIndexName() {
        return "queuebox-index-" + UUID.randomUUID().toString();
    }

    public void ensureGetIndex() {
        this.ensureGetIndex(new Document());
    }

    public void ensureGetIndex(Document beforeSort) {
        this.ensureGetIndex(beforeSort, new Document());
    }

    public void ensureGetIndex(Document beforeSort, Document afterSort) {
        Objects.requireNonNull(beforeSort);
        Objects.requireNonNull(afterSort);
        Document completeIndex = new Document("running", (Object)1);
        for (Map.Entry field : beforeSort.entrySet()) {
            if (!Objects.equals(field.getValue(), 1) && !Objects.equals(field.getValue(), -1)) {
                throw new IllegalArgumentException("field values must be either 1 or -1");
            }
            completeIndex.append("payload." + (String)field.getKey(), field.getValue());
        }
        completeIndex.append("priority", (Object)1).append("created", (Object)1);
        for (Map.Entry field : afterSort.entrySet()) {
            if (!Objects.equals(field.getValue(), 1) && !Objects.equals(field.getValue(), -1)) {
                throw new IllegalArgumentException("field values must be either 1 or -1");
            }
            completeIndex.append("payload." + (String)field.getKey(), field.getValue());
        }
        completeIndex.append("earliestGet", (Object)1);
        this.ensureIndex(completeIndex);
        this.ensureIndex(new Document("running", (Object)1).append("resetTimestamp", (Object)1));
    }

    public void ensureCountIndex(Document index, boolean includeRunning) {
        Objects.requireNonNull(index);
        Document completeIndex = new Document();
        if (includeRunning) {
            completeIndex.append("running", (Object)1);
        }
        for (Map.Entry field : index.entrySet()) {
            if (!Objects.equals(field.getValue(), 1) && !Objects.equals(field.getValue(), -1)) {
                throw new IllegalArgumentException("field values must be either 1 or -1");
            }
            completeIndex.append("payload." + (String)field.getKey(), field.getValue());
        }
        this.ensureIndex(completeIndex);
    }

    private void ensureIndex(Document indexDoc) {
        for (int i = 0; i < 5; ++i) {
            for (Document existingIndex : this.collection.listIndexes()) {
                if (!existingIndex.get((Object)"key").equals(indexDoc)) continue;
                LOGGER.info(String.format("found just created index %s", existingIndex.get((Object)"name")));
                return;
            }
            String name = this.generateIndexName();
            LOGGER.info(String.format("created index %s at %s attempt", name, i + 1));
            IndexOptions iOpts = new IndexOptions().background(true).name(name);
            this.collection.createIndex((Bson)indexDoc, iOpts);
        }
        throw new RuntimeException("could not create index after 5 attempts");
    }
}

