/*
 * Decompiled with CFR 0.152.
 */
package gaillard.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import net.c0f3.queuebox.mongo.MongoQueueCoreIndexes;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public final class MongoQueueCore {
    private final MongoQueueCoreIndexes indexes;
    private final MongoCollection<Document> collection;

    public MongoQueueCore(MongoCollection<Document> collection) {
        Objects.requireNonNull(collection);
        this.collection = collection;
        this.indexes = new MongoQueueCoreIndexes<Document>(collection);
    }

    public void ensureGetIndex() {
        this.indexes.ensureGetIndex(new Document());
    }

    public void ensureGetIndex(Document beforeSort) {
        this.indexes.ensureGetIndex(beforeSort);
    }

    public void ensureGetIndex(Document beforeSort, Document afterSort) {
        this.indexes.ensureGetIndex(beforeSort, afterSort);
    }

    public void ensureCountIndex(Document index, boolean includeRunning) {
        this.indexes.ensureCountIndex(index, includeRunning);
    }

    public Document get(Document query, int resetDuration) {
        return this.get(query, resetDuration, 3000, 200L);
    }

    public Document get(Document query, int resetDuration, int waitDuration) {
        return this.get(query, resetDuration, waitDuration, 200L);
    }

    public Document get(Document query, int resetDuration, int waitDuration, long pollDuration) {
        Objects.requireNonNull(query);
        this.collection.updateMany((Bson)new Document("running", (Object)true).append("resetTimestamp", (Object)new Document("$lte", (Object)new Date())), (Bson)new Document("$set", (Object)new Document("running", (Object)false)), new UpdateOptions().upsert(false));
        Document builtQuery = new Document("running", (Object)false);
        for (Map.Entry field : query.entrySet()) {
            builtQuery.append("payload." + (String)field.getKey(), field.getValue());
        }
        builtQuery.append("earliestGet", (Object)new Document("$lte", (Object)new Date()));
        Date resetTimestamp = Date.from(Instant.now().plusSeconds(resetDuration));
        Document sort = new Document("priority", (Object)1).append("created", (Object)1);
        Document update = new Document("$set", (Object)new Document("running", (Object)true).append("resetTimestamp", (Object)resetTimestamp));
        Document fields = new Document("payload", (Object)1);
        long nowTimestamp = System.currentTimeMillis();
        long endTimestamp = nowTimestamp + (long)Math.max(waitDuration, 0);
        while (nowTimestamp <= endTimestamp) {
            FindOneAndUpdateOptions opts = new FindOneAndUpdateOptions().sort((Bson)sort).upsert(false).returnDocument(ReturnDocument.AFTER).projection((Bson)fields);
            Document message = (Document)this.collection.findOneAndUpdate((Bson)builtQuery, (Bson)update, opts);
            if (message != null) {
                ObjectId id = message.getObjectId((Object)"_id");
                return ((Document)message.get((Object)"payload")).append("id", (Object)id);
            }
            this.trySleep(pollDuration);
            nowTimestamp = System.currentTimeMillis();
        }
        return null;
    }

    private void trySleep(long pollDuration) {
        if (pollDuration <= 0L) {
            return;
        }
        try {
            Thread.sleep(pollDuration);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public long count(Document query) {
        Objects.requireNonNull(query);
        Document completeQuery = new Document();
        for (Map.Entry field : query.entrySet()) {
            completeQuery.append("payload." + (String)field.getKey(), field.getValue());
        }
        return this.collection.countDocuments((Bson)completeQuery);
    }

    public long count(Document query, boolean running) {
        Objects.requireNonNull(query);
        Document completeQuery = new Document("running", (Object)running);
        for (Map.Entry field : query.entrySet()) {
            completeQuery.append("payload." + (String)field.getKey(), field.getValue());
        }
        return this.collection.countDocuments((Bson)completeQuery);
    }

    public void ack(Document message) {
        Objects.requireNonNull(message);
        Object id = message.get((Object)"id");
        if (id.getClass() != ObjectId.class) {
            throw new IllegalArgumentException("id must be an ObjectId");
        }
        this.collection.deleteOne((Bson)new Document("_id", id));
    }

    public void ackSend(Document message, Document payload) {
        this.ackSend(message, payload, new Date());
    }

    public void ackSend(Document message, Document payload, Date earliestGet) {
        this.ackSend(message, payload, earliestGet, 0.0);
    }

    public void ackSend(Document message, Document payload, Date earliestGet, double priority) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(payload);
        Objects.requireNonNull(earliestGet);
        if (Double.isNaN(priority)) {
            throw new IllegalArgumentException("priority was NaN");
        }
        Object id = message.get((Object)"id");
        if (id.getClass() != ObjectId.class) {
            throw new IllegalArgumentException("id must be an ObjectId");
        }
        Document newMessage = new Document("$set", (Object)new Document("payload", (Object)payload).append("running", (Object)false).append("resetTimestamp", (Object)new Date(Long.MAX_VALUE)).append("earliestGet", (Object)earliestGet).append("priority", (Object)priority).append("created", (Object)new Date()));
        this.collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)newMessage, new UpdateOptions().upsert(true));
    }

    public void requeue(Document message) {
        this.requeue(message, new Date());
    }

    public void requeue(Document message, Date earliestGet) {
        this.requeue(message, earliestGet, 0.0);
    }

    public void requeue(Document message, Date earliestGet, double priority) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(earliestGet);
        if (Double.isNaN(priority)) {
            throw new IllegalArgumentException("priority was NaN");
        }
        Object id = message.get((Object)"id");
        if (id.getClass() != ObjectId.class) {
            throw new IllegalArgumentException("id must be an ObjectId");
        }
        Document forRequeue = new Document((Map)message);
        forRequeue.remove((Object)"id");
        this.ackSend(message, forRequeue, earliestGet, priority);
    }

    public void send(Document payload) {
        this.send(payload, new Date());
    }

    public void send(Document payload, Date earliestGet) {
        this.send(payload, earliestGet, 0.0);
    }

    public void send(Document payload, Date earliestGet, double priority) {
        Objects.requireNonNull(payload);
        Objects.requireNonNull(earliestGet);
        if (Double.isNaN(priority)) {
            throw new IllegalArgumentException("priority was NaN");
        }
        Document message = new Document("payload", (Object)payload).append("running", (Object)false).append("resetTimestamp", (Object)new Date(Long.MAX_VALUE)).append("earliestGet", (Object)earliestGet).append("priority", (Object)priority).append("created", (Object)new Date());
        this.collection.insertOne((Object)message);
    }
}

