/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.models

import org.openapitools.client.models.CaptionModel
import org.openapitools.client.models.ChapterModel
import org.openapitools.client.models.MetaTagModel
import org.openapitools.client.models.MomentModel
import org.openapitools.client.models.TranscodingMessageModel
import org.openapitools.client.models.VideoModelStatus

import com.google.gson.annotations.SerializedName

/**
 * Represents a video and its metadata including title, upload date, dimensions, encoding status, and more.
 *
 * @param videoLibraryId The ID of the video library that the video belongs to.
 * @param guid The unique identifier of the video.
 * @param title The title of the video.
 * @param dateUploaded The date and time when the video was uploaded.
 * @param views The number of views the video has received.
 * @param isPublic Determines if the video is publicly accessible.
 * @param length The duration of the video in seconds.
 * @param status 
 * @param framerate The framerate of the video.
 * @param rotation The rotation (in degrees) of the video if applicable.
 * @param width The width of the original video in pixels.
 * @param height The height of the original video in pixels.
 * @param availableResolutions A comma-separated list of resolutions available for the video.
 * @param outputCodecs A comma-separated list of output codecs used for video encoding.
 * @param thumbnailCount The number of thumbnails generated for the video.
 * @param encodeProgress The current encoding progress of the video as a percentage.
 * @param storageSize The total storage size of the video file in bytes.
 * @param captions A list of captions available for the video.
 * @param hasMP4Fallback Indicates if MP4 fallback files are available for the video.
 * @param collectionId The identifier of the collection that the video belongs to.
 * @param thumbnailFileName The file name of the thumbnail stored on the server.
 * @param averageWatchTime The average watch time of the video in seconds.
 * @param totalWatchTime The total accumulated watch time of the video in seconds.
 * @param category The automatically detected category of the video.
 * @param chapters A list of chapters within the video.
 * @param moments A list of significant moments or events in the video.
 * @param metaTags A list of metadata tags associated with the video.
 * @param transcodingMessages Messages generated during transcoding that indicate warnings or errors.
 */


data class VideoModel (

    /* The ID of the video library that the video belongs to. */
    @SerializedName("videoLibraryId")
    val videoLibraryId: kotlin.Long? = null,

    /* The unique identifier of the video. */
    @SerializedName("guid")
    val guid: kotlin.String? = null,

    /* The title of the video. */
    @SerializedName("title")
    val title: kotlin.String? = null,

    /* The date and time when the video was uploaded. */
    @SerializedName("dateUploaded")
    val dateUploaded: kotlin.String? = null,

    /* The number of views the video has received. */
    @SerializedName("views")
    val views: kotlin.Long? = null,

    /* Determines if the video is publicly accessible. */
    @SerializedName("isPublic")
    val isPublic: kotlin.Boolean? = null,

    /* The duration of the video in seconds. */
    @SerializedName("length")
    val length: kotlin.Int? = null,

    @SerializedName("status")
    val status: net.bunny.api.model.VideoModelStatus? = null,

    /* The framerate of the video. */
    @SerializedName("framerate")
    val framerate: kotlin.Double? = null,

    /* The rotation (in degrees) of the video if applicable. */
    @SerializedName("rotation")
    val rotation: kotlin.Int? = null,

    /* The width of the original video in pixels. */
    @SerializedName("width")
    val width: kotlin.Int? = null,

    /* The height of the original video in pixels. */
    @SerializedName("height")
    val height: kotlin.Int? = null,

    /* A comma-separated list of resolutions available for the video. */
    @SerializedName("availableResolutions")
    val availableResolutions: kotlin.String? = null,

    /* A comma-separated list of output codecs used for video encoding. */
    @SerializedName("outputCodecs")
    val outputCodecs: kotlin.String? = null,

    /* The number of thumbnails generated for the video. */
    @SerializedName("thumbnailCount")
    val thumbnailCount: kotlin.Int? = null,

    /* The current encoding progress of the video as a percentage. */
    @SerializedName("encodeProgress")
    val encodeProgress: kotlin.Int? = null,

    /* The total storage size of the video file in bytes. */
    @SerializedName("storageSize")
    val storageSize: kotlin.Long? = null,

    /* A list of captions available for the video. */
    @SerializedName("captions")
    val captions: kotlin.collections.List<CaptionModel>? = null,

    /* Indicates if MP4 fallback files are available for the video. */
    @SerializedName("hasMP4Fallback")
    val hasMP4Fallback: kotlin.Boolean? = null,

    /* The identifier of the collection that the video belongs to. */
    @SerializedName("collectionId")
    val collectionId: kotlin.String? = null,

    /* The file name of the thumbnail stored on the server. */
    @SerializedName("thumbnailFileName")
    val thumbnailFileName: kotlin.String? = null,

    /* The average watch time of the video in seconds. */
    @SerializedName("averageWatchTime")
    val averageWatchTime: kotlin.Long? = null,

    /* The total accumulated watch time of the video in seconds. */
    @SerializedName("totalWatchTime")
    val totalWatchTime: kotlin.Long? = null,

    /* The automatically detected category of the video. */
    @SerializedName("category")
    val category: kotlin.String? = null,

    /* A list of chapters within the video. */
    @SerializedName("chapters")
    val chapters: kotlin.collections.List<ChapterModel>? = null,

    /* A list of significant moments or events in the video. */
    @SerializedName("moments")
    val moments: kotlin.collections.List<MomentModel>? = null,

    /* A list of metadata tags associated with the video. */
    @SerializedName("metaTags")
    val metaTags: kotlin.collections.List<MetaTagModel>? = null,

    /* Messages generated during transcoding that indicate warnings or errors. */
    @SerializedName("transcodingMessages")
    val transcodingMessages: kotlin.collections.List<TranscodingMessageModel>? = null

)

