/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package net.bunny.api.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import org.openapitools.client.models.VideoOEmbedModel

import com.google.gson.annotations.SerializedName

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class OEmbedApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://video.bunnycdn.com")
        }
    }

    /**
     * Get OEmbed Data
     * Retrieves OEmbed information for a given video URL. This includes embed HTML, thumbnail URL, and metadata such as title and provider details.
     * @param url The URL for which to retrieve OEmbed information. (optional)
     * @param maxWidth Optional maximum width of the embed. (optional)
     * @param maxHeight Optional maximum height of the embed. (optional)
     * @param token Authentication token if required. (optional, default to "")
     * @param expires Expiration timestamp for the provided token. (optional, default to 0L)
     * @return VideoOEmbedModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun oEmbedGetOEmbed(url: kotlin.String? = null, maxWidth: kotlin.Int? = null, maxHeight: kotlin.Int? = null, token: kotlin.String? = "", expires: kotlin.Long? = 0L) : VideoOEmbedModel {
        val localVarResponse = oEmbedGetOEmbedWithHttpInfo(url = url, maxWidth = maxWidth, maxHeight = maxHeight, token = token, expires = expires)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoOEmbedModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get OEmbed Data
     * Retrieves OEmbed information for a given video URL. This includes embed HTML, thumbnail URL, and metadata such as title and provider details.
     * @param url The URL for which to retrieve OEmbed information. (optional)
     * @param maxWidth Optional maximum width of the embed. (optional)
     * @param maxHeight Optional maximum height of the embed. (optional)
     * @param token Authentication token if required. (optional, default to "")
     * @param expires Expiration timestamp for the provided token. (optional, default to 0L)
     * @return ApiResponse<VideoOEmbedModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun oEmbedGetOEmbedWithHttpInfo(url: kotlin.String?, maxWidth: kotlin.Int?, maxHeight: kotlin.Int?, token: kotlin.String?, expires: kotlin.Long?) : ApiResponse<VideoOEmbedModel?> {
        val localVariableConfig = oEmbedGetOEmbedRequestConfig(url = url, maxWidth = maxWidth, maxHeight = maxHeight, token = token, expires = expires)

        return request<Unit, VideoOEmbedModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation oEmbedGetOEmbed
     *
     * @param url The URL for which to retrieve OEmbed information. (optional)
     * @param maxWidth Optional maximum width of the embed. (optional)
     * @param maxHeight Optional maximum height of the embed. (optional)
     * @param token Authentication token if required. (optional, default to "")
     * @param expires Expiration timestamp for the provided token. (optional, default to 0L)
     * @return RequestConfig
     */
    fun oEmbedGetOEmbedRequestConfig(url: kotlin.String?, maxWidth: kotlin.Int?, maxHeight: kotlin.Int?, token: kotlin.String?, expires: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (url != null) {
                    put("url", listOf(url.toString()))
                }
                if (maxWidth != null) {
                    put("maxWidth", listOf(maxWidth.toString()))
                }
                if (maxHeight != null) {
                    put("maxHeight", listOf(maxHeight.toString()))
                }
                if (token != null) {
                    put("token", listOf(token.toString()))
                }
                if (expires != null) {
                    put("expires", listOf(expires.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/OEmbed",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
