/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package net.bunny.api.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import org.openapitools.client.models.EncoderOutputCodec
import org.openapitools.client.models.PaginationListOfVideoModel
import org.openapitools.client.models.StatusModel
import org.openapitools.client.models.StatusModelOfVideoResolutionsInfoModel
import org.openapitools.client.models.VideoAddCaptionRequest
import org.openapitools.client.models.VideoCreateVideoRequest
import org.openapitools.client.models.VideoFetchNewVideoRequest
import org.openapitools.client.models.VideoHeatmapModel
import org.openapitools.client.models.VideoModel
import org.openapitools.client.models.VideoPlayDataModel
import org.openapitools.client.models.VideoStatisticsModel
import org.openapitools.client.models.VideoTranscribeVideoRequest
import org.openapitools.client.models.VideoUpdateVideoRequest

import com.google.gson.annotations.SerializedName

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class ManageVideosApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://video.bunnycdn.com")
        }
    }

    /**
     * Add Caption
     * Adds caption data to the specified video for the given language. The caption file should be provided as a base64 encoded string.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param srclang The ISO 639-1 language code for the caption (e.g., &#39;en&#39;, &#39;fr&#39;).
     * @param videoAddCaptionRequest Caption model including language, label, and base64 encoded captions file.
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoAddCaption(libraryId: kotlin.Long, videoId: kotlin.String, srclang: kotlin.String, videoAddCaptionRequest: VideoAddCaptionRequest) : StatusModel {
        val localVarResponse = videoAddCaptionWithHttpInfo(libraryId = libraryId, videoId = videoId, srclang = srclang, videoAddCaptionRequest = videoAddCaptionRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Add Caption
     * Adds caption data to the specified video for the given language. The caption file should be provided as a base64 encoded string.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param srclang The ISO 639-1 language code for the caption (e.g., &#39;en&#39;, &#39;fr&#39;).
     * @param videoAddCaptionRequest Caption model including language, label, and base64 encoded captions file.
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoAddCaptionWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, srclang: kotlin.String, videoAddCaptionRequest: VideoAddCaptionRequest) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoAddCaptionRequestConfig(libraryId = libraryId, videoId = videoId, srclang = srclang, videoAddCaptionRequest = videoAddCaptionRequest)

        return request<VideoAddCaptionRequest, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoAddCaption
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param srclang The ISO 639-1 language code for the caption (e.g., &#39;en&#39;, &#39;fr&#39;).
     * @param videoAddCaptionRequest Caption model including language, label, and base64 encoded captions file.
     * @return RequestConfig
     */
    fun videoAddCaptionRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, srclang: kotlin.String, videoAddCaptionRequest: VideoAddCaptionRequest) : RequestConfig<VideoAddCaptionRequest> {
        val localVariableBody = videoAddCaptionRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}/captions/{srclang}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())).replace("{"+"srclang"+"}", encodeURIComponent(srclang.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Create Video
     * Creates a new video entry in the specified library. Provide the video details, such as title and optional thumbnail extraction time, in the request body.
     * @param libraryId The ID of the video library where the video will be created.
     * @param videoCreateVideoRequest Video model containing details for the new video. Title is required.
     * @return VideoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoCreateVideo(libraryId: kotlin.Long, videoCreateVideoRequest: VideoCreateVideoRequest) : VideoModel {
        val localVarResponse = videoCreateVideoWithHttpInfo(libraryId = libraryId, videoCreateVideoRequest = videoCreateVideoRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Create Video
     * Creates a new video entry in the specified library. Provide the video details, such as title and optional thumbnail extraction time, in the request body.
     * @param libraryId The ID of the video library where the video will be created.
     * @param videoCreateVideoRequest Video model containing details for the new video. Title is required.
     * @return ApiResponse<VideoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoCreateVideoWithHttpInfo(libraryId: kotlin.Long, videoCreateVideoRequest: VideoCreateVideoRequest) : ApiResponse<VideoModel?> {
        val localVariableConfig = videoCreateVideoRequestConfig(libraryId = libraryId, videoCreateVideoRequest = videoCreateVideoRequest)

        return request<VideoCreateVideoRequest, VideoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoCreateVideo
     *
     * @param libraryId The ID of the video library where the video will be created.
     * @param videoCreateVideoRequest Video model containing details for the new video. Title is required.
     * @return RequestConfig
     */
    fun videoCreateVideoRequestConfig(libraryId: kotlin.Long, videoCreateVideoRequest: VideoCreateVideoRequest) : RequestConfig<VideoCreateVideoRequest> {
        val localVariableBody = videoCreateVideoRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete Caption
     * Deletes the caption for the specified language from the video.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param srclang The ISO 639-1 language code of the caption to be deleted.
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoDeleteCaption(libraryId: kotlin.Long, videoId: kotlin.String, srclang: kotlin.String) : StatusModel {
        val localVarResponse = videoDeleteCaptionWithHttpInfo(libraryId = libraryId, videoId = videoId, srclang = srclang)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete Caption
     * Deletes the caption for the specified language from the video.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param srclang The ISO 639-1 language code of the caption to be deleted.
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoDeleteCaptionWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, srclang: kotlin.String) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoDeleteCaptionRequestConfig(libraryId = libraryId, videoId = videoId, srclang = srclang)

        return request<Unit, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoDeleteCaption
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param srclang The ISO 639-1 language code of the caption to be deleted.
     * @return RequestConfig
     */
    fun videoDeleteCaptionRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, srclang: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/library/{libraryId}/videos/{videoId}/captions/{srclang}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())).replace("{"+"srclang"+"}", encodeURIComponent(srclang.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Cleanup Unconfigured Resolutions
     * Cleans up unconfigured resolutions for the specified video. Query parameters allow you to specify which resolutions to delete and whether to perform a dry run without actual file deletion.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param resolutionsToDelete Comma separated list of resolutions to delete. (optional)
     * @param deleteNonConfiguredResolutions If true, deletes resolutions that are not configured. (optional, default to false)
     * @param deleteOriginal If true, deletes the original video file. (optional, default to false)
     * @param deleteMp4Files If true, deletes MP4 fallback files. (optional, default to false)
     * @param dryRun If set to true, no files will be actually deleted; only informational data is returned. (optional, default to false)
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoDeleteResolutions(libraryId: kotlin.Long, videoId: kotlin.String, resolutionsToDelete: kotlin.String? = null, deleteNonConfiguredResolutions: kotlin.Boolean? = false, deleteOriginal: kotlin.Boolean? = false, deleteMp4Files: kotlin.Boolean? = false, dryRun: kotlin.Boolean? = false) : StatusModel {
        val localVarResponse = videoDeleteResolutionsWithHttpInfo(libraryId = libraryId, videoId = videoId, resolutionsToDelete = resolutionsToDelete, deleteNonConfiguredResolutions = deleteNonConfiguredResolutions, deleteOriginal = deleteOriginal, deleteMp4Files = deleteMp4Files, dryRun = dryRun)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Cleanup Unconfigured Resolutions
     * Cleans up unconfigured resolutions for the specified video. Query parameters allow you to specify which resolutions to delete and whether to perform a dry run without actual file deletion.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param resolutionsToDelete Comma separated list of resolutions to delete. (optional)
     * @param deleteNonConfiguredResolutions If true, deletes resolutions that are not configured. (optional, default to false)
     * @param deleteOriginal If true, deletes the original video file. (optional, default to false)
     * @param deleteMp4Files If true, deletes MP4 fallback files. (optional, default to false)
     * @param dryRun If set to true, no files will be actually deleted; only informational data is returned. (optional, default to false)
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoDeleteResolutionsWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, resolutionsToDelete: kotlin.String?, deleteNonConfiguredResolutions: kotlin.Boolean?, deleteOriginal: kotlin.Boolean?, deleteMp4Files: kotlin.Boolean?, dryRun: kotlin.Boolean?) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoDeleteResolutionsRequestConfig(libraryId = libraryId, videoId = videoId, resolutionsToDelete = resolutionsToDelete, deleteNonConfiguredResolutions = deleteNonConfiguredResolutions, deleteOriginal = deleteOriginal, deleteMp4Files = deleteMp4Files, dryRun = dryRun)

        return request<Unit, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoDeleteResolutions
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param resolutionsToDelete Comma separated list of resolutions to delete. (optional)
     * @param deleteNonConfiguredResolutions If true, deletes resolutions that are not configured. (optional, default to false)
     * @param deleteOriginal If true, deletes the original video file. (optional, default to false)
     * @param deleteMp4Files If true, deletes MP4 fallback files. (optional, default to false)
     * @param dryRun If set to true, no files will be actually deleted; only informational data is returned. (optional, default to false)
     * @return RequestConfig
     */
    fun videoDeleteResolutionsRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, resolutionsToDelete: kotlin.String?, deleteNonConfiguredResolutions: kotlin.Boolean?, deleteOriginal: kotlin.Boolean?, deleteMp4Files: kotlin.Boolean?, dryRun: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (resolutionsToDelete != null) {
                    put("resolutionsToDelete", listOf(resolutionsToDelete.toString()))
                }
                if (deleteNonConfiguredResolutions != null) {
                    put("deleteNonConfiguredResolutions", listOf(deleteNonConfiguredResolutions.toString()))
                }
                if (deleteOriginal != null) {
                    put("deleteOriginal", listOf(deleteOriginal.toString()))
                }
                if (deleteMp4Files != null) {
                    put("deleteMp4Files", listOf(deleteMp4Files.toString()))
                }
                if (dryRun != null) {
                    put("dryRun", listOf(dryRun.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}/resolutions/cleanup".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete Video
     * Deletes the specified video permanently from the video library.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to be deleted.
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoDeleteVideo(libraryId: kotlin.Long, videoId: kotlin.String) : StatusModel {
        val localVarResponse = videoDeleteVideoWithHttpInfo(libraryId = libraryId, videoId = videoId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete Video
     * Deletes the specified video permanently from the video library.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to be deleted.
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoDeleteVideoWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoDeleteVideoRequestConfig(libraryId = libraryId, videoId = videoId)

        return request<Unit, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoDeleteVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to be deleted.
     * @return RequestConfig
     */
    fun videoDeleteVideoRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/library/{libraryId}/videos/{videoId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Fetch Video
     * Fetches a video from a remote URL and adds it to the specified library. Optional parameters allow you to specify a collection and the time (in ms) to extract a thumbnail.
     * @param libraryId The ID of the video library.
     * @param videoFetchNewVideoRequest Fetch video request model containing the URL and optional headers for the fetch operation.
     * @param collectionId Optional collection ID to assign the fetched video to. (optional)
     * @param thumbnailTime Optional video time in milliseconds to extract the main video thumbnail. (optional)
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoFetchNewVideo(libraryId: kotlin.Long, videoFetchNewVideoRequest: VideoFetchNewVideoRequest, collectionId: kotlin.String? = null, thumbnailTime: kotlin.Int? = null) : StatusModel {
        val localVarResponse = videoFetchNewVideoWithHttpInfo(libraryId = libraryId, videoFetchNewVideoRequest = videoFetchNewVideoRequest, collectionId = collectionId, thumbnailTime = thumbnailTime)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Fetch Video
     * Fetches a video from a remote URL and adds it to the specified library. Optional parameters allow you to specify a collection and the time (in ms) to extract a thumbnail.
     * @param libraryId The ID of the video library.
     * @param videoFetchNewVideoRequest Fetch video request model containing the URL and optional headers for the fetch operation.
     * @param collectionId Optional collection ID to assign the fetched video to. (optional)
     * @param thumbnailTime Optional video time in milliseconds to extract the main video thumbnail. (optional)
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoFetchNewVideoWithHttpInfo(libraryId: kotlin.Long, videoFetchNewVideoRequest: VideoFetchNewVideoRequest, collectionId: kotlin.String?, thumbnailTime: kotlin.Int?) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoFetchNewVideoRequestConfig(libraryId = libraryId, videoFetchNewVideoRequest = videoFetchNewVideoRequest, collectionId = collectionId, thumbnailTime = thumbnailTime)

        return request<VideoFetchNewVideoRequest, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoFetchNewVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoFetchNewVideoRequest Fetch video request model containing the URL and optional headers for the fetch operation.
     * @param collectionId Optional collection ID to assign the fetched video to. (optional)
     * @param thumbnailTime Optional video time in milliseconds to extract the main video thumbnail. (optional)
     * @return RequestConfig
     */
    fun videoFetchNewVideoRequestConfig(libraryId: kotlin.Long, videoFetchNewVideoRequest: VideoFetchNewVideoRequest, collectionId: kotlin.String?, thumbnailTime: kotlin.Int?) : RequestConfig<VideoFetchNewVideoRequest> {
        val localVariableBody = videoFetchNewVideoRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (collectionId != null) {
                    put("collectionId", listOf(collectionId.toString()))
                }
                if (thumbnailTime != null) {
                    put("thumbnailTime", listOf(thumbnailTime.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/fetch".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get Video
     * Retrieves detailed metadata for the specified video, including status, dimensions, encoding progress, and more.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return VideoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoGetVideo(libraryId: kotlin.Long, videoId: kotlin.String) : VideoModel {
        val localVarResponse = videoGetVideoWithHttpInfo(libraryId = libraryId, videoId = videoId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Video
     * Retrieves detailed metadata for the specified video, including status, dimensions, encoding progress, and more.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return ApiResponse<VideoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoGetVideoWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String) : ApiResponse<VideoModel?> {
        val localVariableConfig = videoGetVideoRequestConfig(libraryId = libraryId, videoId = videoId)

        return request<Unit, VideoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoGetVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return RequestConfig
     */
    fun videoGetVideoRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/videos/{videoId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Get Video Heatmap
     * Retrieves the heatmap data for the specified video, indicating the percentage of watch time across the video&#39;s duration.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return VideoHeatmapModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoGetVideoHeatmap(libraryId: kotlin.Long, videoId: kotlin.String) : VideoHeatmapModel {
        val localVarResponse = videoGetVideoHeatmapWithHttpInfo(libraryId = libraryId, videoId = videoId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoHeatmapModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Video Heatmap
     * Retrieves the heatmap data for the specified video, indicating the percentage of watch time across the video&#39;s duration.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return ApiResponse<VideoHeatmapModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoGetVideoHeatmapWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String) : ApiResponse<VideoHeatmapModel?> {
        val localVariableConfig = videoGetVideoHeatmapRequestConfig(libraryId = libraryId, videoId = videoId)

        return request<Unit, VideoHeatmapModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoGetVideoHeatmap
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return RequestConfig
     */
    fun videoGetVideoHeatmapRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/videos/{videoId}/heatmap".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get Video Play Data
     * Retrieves playback data for the specified video including video URLs, captions path, authentication tokens, and player settings.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param token Authentication token for accessing the video playback data. (optional, default to "")
     * @param expires Expiration timestamp for the provided token. (optional, default to 0L)
     * @return VideoPlayDataModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoGetVideoPlayData(libraryId: kotlin.Long, videoId: kotlin.String, token: kotlin.String? = "", expires: kotlin.Long? = 0L) : VideoPlayDataModel {
        val localVarResponse = videoGetVideoPlayDataWithHttpInfo(libraryId = libraryId, videoId = videoId, token = token, expires = expires)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoPlayDataModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Video Play Data
     * Retrieves playback data for the specified video including video URLs, captions path, authentication tokens, and player settings.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param token Authentication token for accessing the video playback data. (optional, default to "")
     * @param expires Expiration timestamp for the provided token. (optional, default to 0L)
     * @return ApiResponse<VideoPlayDataModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoGetVideoPlayDataWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, token: kotlin.String?, expires: kotlin.Long?) : ApiResponse<VideoPlayDataModel?> {
        val localVariableConfig = videoGetVideoPlayDataRequestConfig(libraryId = libraryId, videoId = videoId, token = token, expires = expires)

        return request<Unit, VideoPlayDataModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoGetVideoPlayData
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param token Authentication token for accessing the video playback data. (optional, default to "")
     * @param expires Expiration timestamp for the provided token. (optional, default to 0L)
     * @return RequestConfig
     */
    fun videoGetVideoPlayDataRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, token: kotlin.String?, expires: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (token != null) {
                    put("token", listOf(token.toString()))
                }
                if (expires != null) {
                    put("expires", listOf(expires.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/videos/{videoId}/play".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * Video Resolutions Info
     * Retrieves information about the available and configured resolutions for the specified video. This includes data on storage resolutions and MP4 fallback files if available.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return StatusModelOfVideoResolutionsInfoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoGetVideoResolutions(libraryId: kotlin.Long, videoId: kotlin.String) : StatusModelOfVideoResolutionsInfoModel {
        val localVarResponse = videoGetVideoResolutionsWithHttpInfo(libraryId = libraryId, videoId = videoId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModelOfVideoResolutionsInfoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Video Resolutions Info
     * Retrieves information about the available and configured resolutions for the specified video. This includes data on storage resolutions and MP4 fallback files if available.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return ApiResponse<StatusModelOfVideoResolutionsInfoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoGetVideoResolutionsWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String) : ApiResponse<StatusModelOfVideoResolutionsInfoModel?> {
        val localVariableConfig = videoGetVideoResolutionsRequestConfig(libraryId = libraryId, videoId = videoId)

        return request<Unit, StatusModelOfVideoResolutionsInfoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoGetVideoResolutions
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @return RequestConfig
     */
    fun videoGetVideoResolutionsRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/videos/{videoId}/resolutions".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get Video Statistics
     * Retrieves statistical data for videos in the specified library. Supports filtering by date range, hourly grouping, and filtering by video GUID.
     * @param libraryId The ID of the video library.
     * @param dateFrom Optional start date (ISO 8601 format) for the statistics. Defaults to the last 30 days if not provided. (optional)
     * @param dateTo Optional end date (ISO 8601 format) for the statistics. Defaults to the last 30 days if not provided. (optional)
     * @param hourly If true, returns statistics data grouped by hour. (optional, default to false)
     * @param videoGuid Optional GUID of a specific video to retrieve statistics for. (optional)
     * @return VideoStatisticsModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoGetVideoStatistics(libraryId: kotlin.Long, dateFrom: kotlin.String? = null, dateTo: kotlin.String? = null, hourly: kotlin.Boolean? = false, videoGuid: kotlin.String? = null) : VideoStatisticsModel {
        val localVarResponse = videoGetVideoStatisticsWithHttpInfo(libraryId = libraryId, dateFrom = dateFrom, dateTo = dateTo, hourly = hourly, videoGuid = videoGuid)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoStatisticsModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Video Statistics
     * Retrieves statistical data for videos in the specified library. Supports filtering by date range, hourly grouping, and filtering by video GUID.
     * @param libraryId The ID of the video library.
     * @param dateFrom Optional start date (ISO 8601 format) for the statistics. Defaults to the last 30 days if not provided. (optional)
     * @param dateTo Optional end date (ISO 8601 format) for the statistics. Defaults to the last 30 days if not provided. (optional)
     * @param hourly If true, returns statistics data grouped by hour. (optional, default to false)
     * @param videoGuid Optional GUID of a specific video to retrieve statistics for. (optional)
     * @return ApiResponse<VideoStatisticsModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoGetVideoStatisticsWithHttpInfo(libraryId: kotlin.Long, dateFrom: kotlin.String?, dateTo: kotlin.String?, hourly: kotlin.Boolean?, videoGuid: kotlin.String?) : ApiResponse<VideoStatisticsModel?> {
        val localVariableConfig = videoGetVideoStatisticsRequestConfig(libraryId = libraryId, dateFrom = dateFrom, dateTo = dateTo, hourly = hourly, videoGuid = videoGuid)

        return request<Unit, VideoStatisticsModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoGetVideoStatistics
     *
     * @param libraryId The ID of the video library.
     * @param dateFrom Optional start date (ISO 8601 format) for the statistics. Defaults to the last 30 days if not provided. (optional)
     * @param dateTo Optional end date (ISO 8601 format) for the statistics. Defaults to the last 30 days if not provided. (optional)
     * @param hourly If true, returns statistics data grouped by hour. (optional, default to false)
     * @param videoGuid Optional GUID of a specific video to retrieve statistics for. (optional)
     * @return RequestConfig
     */
    fun videoGetVideoStatisticsRequestConfig(libraryId: kotlin.Long, dateFrom: kotlin.String?, dateTo: kotlin.String?, hourly: kotlin.Boolean?, videoGuid: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (dateFrom != null) {
                    put("dateFrom", listOf(parseDateToQueryString(dateFrom)))
                }
                if (dateTo != null) {
                    put("dateTo", listOf(parseDateToQueryString(dateTo)))
                }
                if (hourly != null) {
                    put("hourly", listOf(hourly.toString()))
                }
                if (videoGuid != null) {
                    put("videoGuid", listOf(videoGuid.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/statistics".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * List Videos
     * Retrieves a paginated list of videos from the specified video library. Supports filtering by search term, collection, and ordering by date.
     * @param libraryId The ID of the video library.
     * @param page The page number to retrieve. (optional, default to 1)
     * @param itemsPerPage The number of videos per page. (optional, default to 100)
     * @param search A search term to filter videos by title or metadata. (optional, default to "")
     * @param collection The ID of the collection to filter videos by. (optional, default to "")
     * @param orderBy Specifies the field by which to order the video list. (optional, default to "date")
     * @return PaginationListOfVideoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoList(libraryId: kotlin.Long, page: kotlin.Int? = 1, itemsPerPage: kotlin.Int? = 100, search: kotlin.String? = "", collection: kotlin.String? = "", orderBy: kotlin.String? = "date") : PaginationListOfVideoModel {
        val localVarResponse = videoListWithHttpInfo(libraryId = libraryId, page = page, itemsPerPage = itemsPerPage, search = search, collection = collection, orderBy = orderBy)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PaginationListOfVideoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * List Videos
     * Retrieves a paginated list of videos from the specified video library. Supports filtering by search term, collection, and ordering by date.
     * @param libraryId The ID of the video library.
     * @param page The page number to retrieve. (optional, default to 1)
     * @param itemsPerPage The number of videos per page. (optional, default to 100)
     * @param search A search term to filter videos by title or metadata. (optional, default to "")
     * @param collection The ID of the collection to filter videos by. (optional, default to "")
     * @param orderBy Specifies the field by which to order the video list. (optional, default to "date")
     * @return ApiResponse<PaginationListOfVideoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoListWithHttpInfo(libraryId: kotlin.Long, page: kotlin.Int?, itemsPerPage: kotlin.Int?, search: kotlin.String?, collection: kotlin.String?, orderBy: kotlin.String?) : ApiResponse<PaginationListOfVideoModel?> {
        val localVariableConfig = videoListRequestConfig(libraryId = libraryId, page = page, itemsPerPage = itemsPerPage, search = search, collection = collection, orderBy = orderBy)

        return request<Unit, PaginationListOfVideoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoList
     *
     * @param libraryId The ID of the video library.
     * @param page The page number to retrieve. (optional, default to 1)
     * @param itemsPerPage The number of videos per page. (optional, default to 100)
     * @param search A search term to filter videos by title or metadata. (optional, default to "")
     * @param collection The ID of the collection to filter videos by. (optional, default to "")
     * @param orderBy Specifies the field by which to order the video list. (optional, default to "date")
     * @return RequestConfig
     */
    fun videoListRequestConfig(libraryId: kotlin.Long, page: kotlin.Int?, itemsPerPage: kotlin.Int?, search: kotlin.String?, collection: kotlin.String?, orderBy: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (itemsPerPage != null) {
                    put("itemsPerPage", listOf(itemsPerPage.toString()))
                }
                if (search != null) {
                    put("search", listOf(search.toString()))
                }
                if (collection != null) {
                    put("collection", listOf(collection.toString()))
                }
                if (orderBy != null) {
                    put("orderBy", listOf(orderBy.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/videos".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Add output codec to video
     * Adds a specified output codec to the video. This enables additional encoding options for the video file.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param outputCodecId The output codec to add (e.g., x264, vp9, hevc, av1).
     * @return VideoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoReencodeUsingCodec(libraryId: kotlin.Long, videoId: kotlin.String, outputCodecId: EncoderOutputCodec) : VideoModel {
        val localVarResponse = videoReencodeUsingCodecWithHttpInfo(libraryId = libraryId, videoId = videoId, outputCodecId = outputCodecId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Add output codec to video
     * Adds a specified output codec to the video. This enables additional encoding options for the video file.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param outputCodecId The output codec to add (e.g., x264, vp9, hevc, av1).
     * @return ApiResponse<VideoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoReencodeUsingCodecWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, outputCodecId: EncoderOutputCodec) : ApiResponse<VideoModel?> {
        val localVariableConfig = videoReencodeUsingCodecRequestConfig(libraryId = libraryId, videoId = videoId, outputCodecId = outputCodecId)

        return request<Unit, VideoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoReencodeUsingCodec
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param outputCodecId The output codec to add (e.g., x264, vp9, hevc, av1).
     * @return RequestConfig
     */
    fun videoReencodeUsingCodecRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, outputCodecId: EncoderOutputCodec) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/library/{libraryId}/videos/{videoId}/outputs/{outputCodecId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())).replace("{"+"outputCodecId"+"}", encodeURIComponent(outputCodecId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Reencode Video
     * Initiates a re-encoding process for the specified video. This operation can be used to adjust encoding settings or to fix issues with the original encoding.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to reencode.
     * @return VideoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoReencodeVideo(libraryId: kotlin.Long, videoId: kotlin.String) : VideoModel {
        val localVarResponse = videoReencodeVideoWithHttpInfo(libraryId = libraryId, videoId = videoId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Reencode Video
     * Initiates a re-encoding process for the specified video. This operation can be used to adjust encoding settings or to fix issues with the original encoding.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to reencode.
     * @return ApiResponse<VideoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoReencodeVideoWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String) : ApiResponse<VideoModel?> {
        val localVariableConfig = videoReencodeVideoRequestConfig(libraryId = libraryId, videoId = videoId)

        return request<Unit, VideoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoReencodeVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to reencode.
     * @return RequestConfig
     */
    fun videoReencodeVideoRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}/reencode".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Repackage Video
     * Repackages the video, with an option to retain original files for faster future operations. This process may adjust resolution outputs and file formats.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to repackage.
     * @param keepOriginalFiles If true, previous file versions are kept in storage, allowing for faster future repackaging. Default is true. (optional, default to true)
     * @return VideoModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoRepackage(libraryId: kotlin.Long, videoId: kotlin.String, keepOriginalFiles: kotlin.Boolean? = true) : VideoModel {
        val localVarResponse = videoRepackageWithHttpInfo(libraryId = libraryId, videoId = videoId, keepOriginalFiles = keepOriginalFiles)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as VideoModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Repackage Video
     * Repackages the video, with an option to retain original files for faster future operations. This process may adjust resolution outputs and file formats.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to repackage.
     * @param keepOriginalFiles If true, previous file versions are kept in storage, allowing for faster future repackaging. Default is true. (optional, default to true)
     * @return ApiResponse<VideoModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoRepackageWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, keepOriginalFiles: kotlin.Boolean?) : ApiResponse<VideoModel?> {
        val localVariableConfig = videoRepackageRequestConfig(libraryId = libraryId, videoId = videoId, keepOriginalFiles = keepOriginalFiles)

        return request<Unit, VideoModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoRepackage
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to repackage.
     * @param keepOriginalFiles If true, previous file versions are kept in storage, allowing for faster future repackaging. Default is true. (optional, default to true)
     * @return RequestConfig
     */
    fun videoRepackageRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, keepOriginalFiles: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (keepOriginalFiles != null) {
                    put("keepOriginalFiles", listOf(keepOriginalFiles.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}/repackage".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Set Thumbnail
     * Sets or updates the thumbnail image for the specified video using the provided thumbnail URL.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param thumbnailUrl The URL of the thumbnail image to set for the video. (optional)
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoSetThumbnail(libraryId: kotlin.Long, videoId: kotlin.String, thumbnailUrl: kotlin.String? = null) : StatusModel {
        val localVarResponse = videoSetThumbnailWithHttpInfo(libraryId = libraryId, videoId = videoId, thumbnailUrl = thumbnailUrl)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Set Thumbnail
     * Sets or updates the thumbnail image for the specified video using the provided thumbnail URL.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param thumbnailUrl The URL of the thumbnail image to set for the video. (optional)
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoSetThumbnailWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, thumbnailUrl: kotlin.String?) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoSetThumbnailRequestConfig(libraryId = libraryId, videoId = videoId, thumbnailUrl = thumbnailUrl)

        return request<Unit, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoSetThumbnail
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video.
     * @param thumbnailUrl The URL of the thumbnail image to set for the video. (optional)
     * @return RequestConfig
     */
    fun videoSetThumbnailRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, thumbnailUrl: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (thumbnailUrl != null) {
                    put("thumbnailUrl", listOf(thumbnailUrl.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}/thumbnail".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Transcribe Video
     * Initiates the transcription process for the specified video. You can optionally override the video library transcription settings using the provided request body.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to transcribe.
     * @param language The ISO 639-1 language code of the video source. This parameter is used only if not overridden by the request body. (optional)
     * @param force If true, forces the transcription process even if the video has been transcribed before. (optional, default to false)
     * @param videoTranscribeVideoRequest Optional transcription settings that override the default video library settings. (optional)
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoTranscribeVideo(libraryId: kotlin.Long, videoId: kotlin.String, language: kotlin.String? = null, force: kotlin.Boolean? = false, videoTranscribeVideoRequest: VideoTranscribeVideoRequest? = null) : StatusModel {
        val localVarResponse = videoTranscribeVideoWithHttpInfo(libraryId = libraryId, videoId = videoId, language = language, force = force, videoTranscribeVideoRequest = videoTranscribeVideoRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Transcribe Video
     * Initiates the transcription process for the specified video. You can optionally override the video library transcription settings using the provided request body.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to transcribe.
     * @param language The ISO 639-1 language code of the video source. This parameter is used only if not overridden by the request body. (optional)
     * @param force If true, forces the transcription process even if the video has been transcribed before. (optional, default to false)
     * @param videoTranscribeVideoRequest Optional transcription settings that override the default video library settings. (optional)
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoTranscribeVideoWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, language: kotlin.String?, force: kotlin.Boolean?, videoTranscribeVideoRequest: VideoTranscribeVideoRequest?) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoTranscribeVideoRequestConfig(libraryId = libraryId, videoId = videoId, language = language, force = force, videoTranscribeVideoRequest = videoTranscribeVideoRequest)

        return request<VideoTranscribeVideoRequest, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoTranscribeVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to transcribe.
     * @param language The ISO 639-1 language code of the video source. This parameter is used only if not overridden by the request body. (optional)
     * @param force If true, forces the transcription process even if the video has been transcribed before. (optional, default to false)
     * @param videoTranscribeVideoRequest Optional transcription settings that override the default video library settings. (optional)
     * @return RequestConfig
     */
    fun videoTranscribeVideoRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, language: kotlin.String?, force: kotlin.Boolean?, videoTranscribeVideoRequest: VideoTranscribeVideoRequest?) : RequestConfig<VideoTranscribeVideoRequest> {
        val localVariableBody = videoTranscribeVideoRequest
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (language != null) {
                    put("language", listOf(language.toString()))
                }
                if (force != null) {
                    put("force", listOf(force.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}/transcribe".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Update Video
     * Updates metadata and other details for the specified video. Provide updated fields in the request body using the UpdateVideoModel.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to update.
     * @param videoUpdateVideoRequest Video model containing the fields to update.
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoUpdateVideo(libraryId: kotlin.Long, videoId: kotlin.String, videoUpdateVideoRequest: VideoUpdateVideoRequest) : StatusModel {
        val localVarResponse = videoUpdateVideoWithHttpInfo(libraryId = libraryId, videoId = videoId, videoUpdateVideoRequest = videoUpdateVideoRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Update Video
     * Updates metadata and other details for the specified video. Provide updated fields in the request body using the UpdateVideoModel.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to update.
     * @param videoUpdateVideoRequest Video model containing the fields to update.
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoUpdateVideoWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, videoUpdateVideoRequest: VideoUpdateVideoRequest) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoUpdateVideoRequestConfig(libraryId = libraryId, videoId = videoId, videoUpdateVideoRequest = videoUpdateVideoRequest)

        return request<VideoUpdateVideoRequest, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoUpdateVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier of the video to update.
     * @param videoUpdateVideoRequest Video model containing the fields to update.
     * @return RequestConfig
     */
    fun videoUpdateVideoRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, videoUpdateVideoRequest: VideoUpdateVideoRequest) : RequestConfig<VideoUpdateVideoRequest> {
        val localVariableBody = videoUpdateVideoRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/videos/{videoId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Upload Video
     * Uploads a new video file to the specified video library. Additional query parameters allow customization of encoding options such as JIT encoding, enabled resolutions, and output codecs.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier to assign to the new video.
     * @param jitEnabled Determines whether JIT encoding should be enabled for this video. Works only when Premium Encoding is enabled; overrides library settings. (optional)
     * @param enabledResolutions A comma-separated list of resolutions to enable for encoding. Options include: 240p, 360p, 480p, 720p, 1080p, 1440p, 2160p. (optional, default to "")
     * @param enabledOutputCodecs Specifies the codecs that will be used to encode the video. Overrides library settings. Available values: x264, vp9. (optional, default to "")
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun videoUploadVideo(libraryId: kotlin.Long, videoId: kotlin.String, jitEnabled: kotlin.Boolean? = null, enabledResolutions: kotlin.String? = "", enabledOutputCodecs: kotlin.String? = "") : StatusModel {
        val localVarResponse = videoUploadVideoWithHttpInfo(libraryId = libraryId, videoId = videoId, jitEnabled = jitEnabled, enabledResolutions = enabledResolutions, enabledOutputCodecs = enabledOutputCodecs)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Upload Video
     * Uploads a new video file to the specified video library. Additional query parameters allow customization of encoding options such as JIT encoding, enabled resolutions, and output codecs.
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier to assign to the new video.
     * @param jitEnabled Determines whether JIT encoding should be enabled for this video. Works only when Premium Encoding is enabled; overrides library settings. (optional)
     * @param enabledResolutions A comma-separated list of resolutions to enable for encoding. Options include: 240p, 360p, 480p, 720p, 1080p, 1440p, 2160p. (optional, default to "")
     * @param enabledOutputCodecs Specifies the codecs that will be used to encode the video. Overrides library settings. Available values: x264, vp9. (optional, default to "")
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun videoUploadVideoWithHttpInfo(libraryId: kotlin.Long, videoId: kotlin.String, jitEnabled: kotlin.Boolean?, enabledResolutions: kotlin.String?, enabledOutputCodecs: kotlin.String?) : ApiResponse<StatusModel?> {
        val localVariableConfig = videoUploadVideoRequestConfig(libraryId = libraryId, videoId = videoId, jitEnabled = jitEnabled, enabledResolutions = enabledResolutions, enabledOutputCodecs = enabledOutputCodecs)

        return request<Unit, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation videoUploadVideo
     *
     * @param libraryId The ID of the video library.
     * @param videoId The unique identifier to assign to the new video.
     * @param jitEnabled Determines whether JIT encoding should be enabled for this video. Works only when Premium Encoding is enabled; overrides library settings. (optional)
     * @param enabledResolutions A comma-separated list of resolutions to enable for encoding. Options include: 240p, 360p, 480p, 720p, 1080p, 1440p, 2160p. (optional, default to "")
     * @param enabledOutputCodecs Specifies the codecs that will be used to encode the video. Overrides library settings. Available values: x264, vp9. (optional, default to "")
     * @return RequestConfig
     */
    fun videoUploadVideoRequestConfig(libraryId: kotlin.Long, videoId: kotlin.String, jitEnabled: kotlin.Boolean?, enabledResolutions: kotlin.String?, enabledOutputCodecs: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (jitEnabled != null) {
                    put("jitEnabled", listOf(jitEnabled.toString()))
                }
                if (enabledResolutions != null) {
                    put("enabledResolutions", listOf(enabledResolutions.toString()))
                }
                if (enabledOutputCodecs != null) {
                    put("enabledOutputCodecs", listOf(enabledOutputCodecs.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/library/{libraryId}/videos/{videoId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"videoId"+"}", encodeURIComponent(videoId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
