/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package net.bunny.api.api

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import org.openapitools.client.models.CollectionModel
import org.openapitools.client.models.CollectionUpdateCollectionRequest
import org.openapitools.client.models.PaginationListOfCollectionModel
import org.openapitools.client.models.StatusModel

import com.google.gson.annotations.SerializedName

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

class ManageCollectionsApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://video.bunnycdn.com")
        }
    }

    /**
     * Create Collection
     * Creates a new collection in the specified video library using the provided collection details.
     * @param libraryId The ID of the video library where the new collection will be created.
     * @param collectionUpdateCollectionRequest Collection model containing the details for the new collection.
     * @return CollectionModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun collectionCreateCollection(libraryId: kotlin.Long, collectionUpdateCollectionRequest: CollectionUpdateCollectionRequest) : CollectionModel {
        val localVarResponse = collectionCreateCollectionWithHttpInfo(libraryId = libraryId, collectionUpdateCollectionRequest = collectionUpdateCollectionRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CollectionModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Create Collection
     * Creates a new collection in the specified video library using the provided collection details.
     * @param libraryId The ID of the video library where the new collection will be created.
     * @param collectionUpdateCollectionRequest Collection model containing the details for the new collection.
     * @return ApiResponse<CollectionModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun collectionCreateCollectionWithHttpInfo(libraryId: kotlin.Long, collectionUpdateCollectionRequest: CollectionUpdateCollectionRequest) : ApiResponse<CollectionModel?> {
        val localVariableConfig = collectionCreateCollectionRequestConfig(libraryId = libraryId, collectionUpdateCollectionRequest = collectionUpdateCollectionRequest)

        return request<CollectionUpdateCollectionRequest, CollectionModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation collectionCreateCollection
     *
     * @param libraryId The ID of the video library where the new collection will be created.
     * @param collectionUpdateCollectionRequest Collection model containing the details for the new collection.
     * @return RequestConfig
     */
    fun collectionCreateCollectionRequestConfig(libraryId: kotlin.Long, collectionUpdateCollectionRequest: CollectionUpdateCollectionRequest) : RequestConfig<CollectionUpdateCollectionRequest> {
        val localVariableBody = collectionUpdateCollectionRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/collections".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete Collection
     * Deletes the specified collection permanently from the video library.
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection to be deleted.
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun collectionDeleteCollection(libraryId: kotlin.Long, collectionId: kotlin.String) : StatusModel {
        val localVarResponse = collectionDeleteCollectionWithHttpInfo(libraryId = libraryId, collectionId = collectionId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete Collection
     * Deletes the specified collection permanently from the video library.
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection to be deleted.
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun collectionDeleteCollectionWithHttpInfo(libraryId: kotlin.Long, collectionId: kotlin.String) : ApiResponse<StatusModel?> {
        val localVariableConfig = collectionDeleteCollectionRequestConfig(libraryId = libraryId, collectionId = collectionId)

        return request<Unit, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation collectionDeleteCollection
     *
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection to be deleted.
     * @return RequestConfig
     */
    fun collectionDeleteCollectionRequestConfig(libraryId: kotlin.Long, collectionId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/library/{libraryId}/collections/{collectionId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"collectionId"+"}", encodeURIComponent(collectionId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get Collection
     * Retrieves details of a specific collection. Use the query parameter &#39;includeThumbnails&#39; to include preview images if available.
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection.
     * @param includeThumbnails If true, the response will include preview image URLs for the collection. (optional, default to false)
     * @return CollectionModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun collectionGetCollection(libraryId: kotlin.Long, collectionId: kotlin.String, includeThumbnails: kotlin.Boolean? = false) : CollectionModel {
        val localVarResponse = collectionGetCollectionWithHttpInfo(libraryId = libraryId, collectionId = collectionId, includeThumbnails = includeThumbnails)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CollectionModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Collection
     * Retrieves details of a specific collection. Use the query parameter &#39;includeThumbnails&#39; to include preview images if available.
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection.
     * @param includeThumbnails If true, the response will include preview image URLs for the collection. (optional, default to false)
     * @return ApiResponse<CollectionModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun collectionGetCollectionWithHttpInfo(libraryId: kotlin.Long, collectionId: kotlin.String, includeThumbnails: kotlin.Boolean?) : ApiResponse<CollectionModel?> {
        val localVariableConfig = collectionGetCollectionRequestConfig(libraryId = libraryId, collectionId = collectionId, includeThumbnails = includeThumbnails)

        return request<Unit, CollectionModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation collectionGetCollection
     *
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection.
     * @param includeThumbnails If true, the response will include preview image URLs for the collection. (optional, default to false)
     * @return RequestConfig
     */
    fun collectionGetCollectionRequestConfig(libraryId: kotlin.Long, collectionId: kotlin.String, includeThumbnails: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (includeThumbnails != null) {
                    put("includeThumbnails", listOf(includeThumbnails.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/collections/{collectionId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"collectionId"+"}", encodeURIComponent(collectionId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get Collection List
     * Retrieves a paginated list of collections for the specified video library. Optional query parameters allow for filtering, pagination, and ordering the results.
     * @param libraryId The ID of the video library.
     * @param page The page number to retrieve. (optional, default to 1)
     * @param itemsPerPage The number of items per page. (optional, default to 100)
     * @param search A search term to filter collections by name or other metadata. (optional, default to "")
     * @param orderBy Specifies the field by which to order the results. (optional, default to "date")
     * @param includeThumbnails If true, includes thumbnail image URLs in the response. (optional, default to false)
     * @return PaginationListOfCollectionModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun collectionList(libraryId: kotlin.Long, page: kotlin.Int? = 1, itemsPerPage: kotlin.Int? = 100, search: kotlin.String? = "", orderBy: kotlin.String? = "date", includeThumbnails: kotlin.Boolean? = false) : PaginationListOfCollectionModel {
        val localVarResponse = collectionListWithHttpInfo(libraryId = libraryId, page = page, itemsPerPage = itemsPerPage, search = search, orderBy = orderBy, includeThumbnails = includeThumbnails)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PaginationListOfCollectionModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Collection List
     * Retrieves a paginated list of collections for the specified video library. Optional query parameters allow for filtering, pagination, and ordering the results.
     * @param libraryId The ID of the video library.
     * @param page The page number to retrieve. (optional, default to 1)
     * @param itemsPerPage The number of items per page. (optional, default to 100)
     * @param search A search term to filter collections by name or other metadata. (optional, default to "")
     * @param orderBy Specifies the field by which to order the results. (optional, default to "date")
     * @param includeThumbnails If true, includes thumbnail image URLs in the response. (optional, default to false)
     * @return ApiResponse<PaginationListOfCollectionModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun collectionListWithHttpInfo(libraryId: kotlin.Long, page: kotlin.Int?, itemsPerPage: kotlin.Int?, search: kotlin.String?, orderBy: kotlin.String?, includeThumbnails: kotlin.Boolean?) : ApiResponse<PaginationListOfCollectionModel?> {
        val localVariableConfig = collectionListRequestConfig(libraryId = libraryId, page = page, itemsPerPage = itemsPerPage, search = search, orderBy = orderBy, includeThumbnails = includeThumbnails)

        return request<Unit, PaginationListOfCollectionModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation collectionList
     *
     * @param libraryId The ID of the video library.
     * @param page The page number to retrieve. (optional, default to 1)
     * @param itemsPerPage The number of items per page. (optional, default to 100)
     * @param search A search term to filter collections by name or other metadata. (optional, default to "")
     * @param orderBy Specifies the field by which to order the results. (optional, default to "date")
     * @param includeThumbnails If true, includes thumbnail image URLs in the response. (optional, default to false)
     * @return RequestConfig
     */
    fun collectionListRequestConfig(libraryId: kotlin.Long, page: kotlin.Int?, itemsPerPage: kotlin.Int?, search: kotlin.String?, orderBy: kotlin.String?, includeThumbnails: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (itemsPerPage != null) {
                    put("itemsPerPage", listOf(itemsPerPage.toString()))
                }
                if (search != null) {
                    put("search", listOf(search.toString()))
                }
                if (orderBy != null) {
                    put("orderBy", listOf(orderBy.toString()))
                }
                if (includeThumbnails != null) {
                    put("includeThumbnails", listOf(includeThumbnails.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/library/{libraryId}/collections".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Update Collection
     * Updates an existing collection. Provide the new collection details in the request body using the UpdateCollectionModel.
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection to be updated.
     * @param collectionUpdateCollectionRequest Collection model containing the fields to be updated.
     * @return StatusModel
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun collectionUpdateCollection(libraryId: kotlin.Long, collectionId: kotlin.String, collectionUpdateCollectionRequest: CollectionUpdateCollectionRequest) : StatusModel {
        val localVarResponse = collectionUpdateCollectionWithHttpInfo(libraryId = libraryId, collectionId = collectionId, collectionUpdateCollectionRequest = collectionUpdateCollectionRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusModel
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Update Collection
     * Updates an existing collection. Provide the new collection details in the request body using the UpdateCollectionModel.
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection to be updated.
     * @param collectionUpdateCollectionRequest Collection model containing the fields to be updated.
     * @return ApiResponse<StatusModel?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun collectionUpdateCollectionWithHttpInfo(libraryId: kotlin.Long, collectionId: kotlin.String, collectionUpdateCollectionRequest: CollectionUpdateCollectionRequest) : ApiResponse<StatusModel?> {
        val localVariableConfig = collectionUpdateCollectionRequestConfig(libraryId = libraryId, collectionId = collectionId, collectionUpdateCollectionRequest = collectionUpdateCollectionRequest)

        return request<CollectionUpdateCollectionRequest, StatusModel>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation collectionUpdateCollection
     *
     * @param libraryId The ID of the video library containing the collection.
     * @param collectionId The unique identifier of the collection to be updated.
     * @param collectionUpdateCollectionRequest Collection model containing the fields to be updated.
     * @return RequestConfig
     */
    fun collectionUpdateCollectionRequestConfig(libraryId: kotlin.Long, collectionId: kotlin.String, collectionUpdateCollectionRequest: CollectionUpdateCollectionRequest) : RequestConfig<CollectionUpdateCollectionRequest> {
        val localVariableBody = collectionUpdateCollectionRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/library/{libraryId}/collections/{collectionId}".replace("{"+"libraryId"+"}", encodeURIComponent(libraryId.toString())).replace("{"+"collectionId"+"}", encodeURIComponent(collectionId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
