/*
 * Decompiled with CFR 0.152.
 */
package net.brunomendola.querity.test;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.brunomendola.querity.api.Condition;
import net.brunomendola.querity.api.Operator;
import net.brunomendola.querity.api.Querity;
import net.brunomendola.querity.api.Query;
import net.brunomendola.querity.api.Sort;
import net.brunomendola.querity.test.DatabaseSeeder;
import net.brunomendola.querity.test.domain.Location;
import net.brunomendola.querity.test.domain.Order;
import net.brunomendola.querity.test.domain.OrderItem;
import net.brunomendola.querity.test.domain.Person;
import net.brunomendola.querity.test.domain.PersonRepository;
import net.brunomendola.querity.test.domain.ProductCategory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public abstract class QuerityGenericSpringTestSuite<T extends Person<K, ?, ?, ? extends Order<? extends OrderItem>>, K extends Comparable<K>> {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_LAST_NAME = "lastName";
    public static final String PROPERTY_FIRST_NAME = "firstName";
    public static final String PROPERTY_BIRTH_DATE = "birthDate";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_CHILDREN = "children";
    public static final String PROPERTY_MARRIED = "married";
    public static final String PROPERTY_ADDRESS_CITY = "address.city";
    public static final String PROPERTY_VISITED_LOCATIONS_COUNTRY = "visitedLocations.country";
    public static final String PROPERTY_VISITED_LOCATIONS_CITIES = "visitedLocations.cities";
    public static final String PROPERTY_FAVOURITE_PRODUCT_CATEGORY = "favouriteProductCategory";
    @Autowired
    private DatabaseSeeder<T> databaseSeeder;
    private List<T> entities;
    private T entity1;
    private T entity2;
    @Autowired
    PersonRepository<T, K> repository;
    @Autowired
    Querity querity;

    @BeforeEach
    void setUp() {
        this.entities = this.databaseSeeder.getEntities();
        Assertions.assertThat(this.entities).isNotEmpty();
        this.entity1 = this.getEntityFromList(20);
        this.entity2 = this.getEntityFromList(30);
    }

    protected abstract Class<T> getEntityClass();

    private T getEntityFromList(int skip) {
        return (T)this.entities.stream().filter(e -> e.getLastName() != null).filter(e -> e.getLastName().length() >= 5).filter(e -> e.getBirthDate() != null).filter(e -> e.getChildren() > 0).filter(e -> !e.getVisitedLocations().isEmpty()).filter(e -> !((Location)e.getVisitedLocations().get(0)).getCities().isEmpty()).filter(e -> !e.getOrders().isEmpty()).skip(skip).limit(1L).findAny().orElseThrow(() -> new IllegalStateException("No entities found"));
    }

    protected <C> Comparator<C> getStringComparator(Function<C, String> extractValueFunction) {
        return Comparator.comparing(extractValueFunction, this.getSortComparator());
    }

    protected <C extends Comparable<? super C>> Comparator<C> getSortComparator() {
        return Comparator.nullsLast(Comparator.naturalOrder());
    }

    @Nested
    class CountTests {
        CountTests() {
        }

        @Test
        void givenNullQuery_whenCount_thenReturnAllTheElementsCount() {
            Long count = QuerityGenericSpringTestSuite.this.querity.count(QuerityGenericSpringTestSuite.this.getEntityClass(), null);
            Assertions.assertThat((Long)count).isEqualTo((long)QuerityGenericSpringTestSuite.this.entities.size());
        }

        @Test
        void givenEmptyFilter_whenCount_thenReturnAllTheElementsCount() {
            Long count = QuerityGenericSpringTestSuite.this.querity.count(QuerityGenericSpringTestSuite.this.getEntityClass(), (Condition)Querity.and((Condition[])new Condition[0]));
            Assertions.assertThat((Long)count).isEqualTo((long)QuerityGenericSpringTestSuite.this.entities.size());
        }

        @Test
        void givenFilterWithStringEqualsCondition_whenCount_thenReturnOnlyFilteredElementsCount() {
            Long count = QuerityGenericSpringTestSuite.this.querity.count(QuerityGenericSpringTestSuite.this.getEntityClass(), (Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()));
            Assertions.assertThat((Long)count).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(e -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(e.getLastName())).count());
        }
    }

    @Nested
    class SortingTests {
        SortingTests() {
        }

        @Test
        void givenSortByFieldAscending_whenFilterAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME), Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericSpringTestSuite.this.getStringComparator(p -> p.getLastName()).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericSpringTestSuite.this.entities.size());
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().sorted(comparator).collect(Collectors.toList()));
        }

        @Test
        void givenSortByDateField_whenFilterAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_BIRTH_DATE), Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = Comparator.comparing(p -> p.getBirthDate(), QuerityGenericSpringTestSuite.this.getSortComparator()).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().sorted(comparator).collect(Collectors.toList()));
        }

        @Test
        void givenSortByFieldDescending_whenFilterAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Sort.Direction)Sort.Direction.DESC), Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericSpringTestSuite.this.getStringComparator(p -> p.getLastName()).reversed().thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericSpringTestSuite.this.entities.size());
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().sorted(comparator).collect(Collectors.toList()));
        }

        @Test
        void givenSortByNestedField_whenFilterAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_ADDRESS_CITY), Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericSpringTestSuite.this.getStringComparator(p -> p.getAddress().getCity()).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericSpringTestSuite.this.entities.size());
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().sorted(comparator).collect(Collectors.toList()));
        }

        @Test
        void givenSortByMultipleFields_whenFilterAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME), Querity.sortBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME)}).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericSpringTestSuite.this.getStringComparator(p -> p.getLastName()).thenComparing(p -> p.getFirstName());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().sorted(comparator).collect(Collectors.toList()));
        }
    }

    @Nested
    class PaginationTests {
        PaginationTests() {
        }

        @Test
        void givenPagination_whenFilterAll_thenReturnThePageElements() {
            Query query = Querity.query().pagination(Integer.valueOf(2), Integer.valueOf(3)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().skip(3L).limit(3L).collect(Collectors.toList()));
        }
    }

    @Nested
    class FilteringTests {
        FilteringTests() {
        }

        @Test
        void givenNullQuery_whenFilterAll_thenReturnAllTheElements() {
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), null);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericSpringTestSuite.this.entities.size());
        }

        @Test
        void givenEmptyFilter_whenFilterAll_thenReturnAllTheElements() {
            Query query = Querity.query().build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo((Object)QuerityGenericSpringTestSuite.this.entities);
        }

        @Test
        void givenFilterByIdEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_ID, (Operator)Operator.EQUALS, QuerityGenericSpringTestSuite.this.entity1.getId())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(1);
            Assertions.assertThat(((Person)result.get(0)).getId()).isEqualTo(QuerityGenericSpringTestSuite.this.entity1.getId());
        }

        @Test
        void givenFilterWithStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithIntegerEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_CHILDREN, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getChildren())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(QuerityGenericSpringTestSuite.this.entity1.getChildren())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithIntegerAsStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_CHILDREN, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getChildren())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(QuerityGenericSpringTestSuite.this.entity1.getChildren())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithDateEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_BIRTH_DATE, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getBirthDate())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getBirthDate() != null && p.getBirthDate().isEqual(QuerityGenericSpringTestSuite.this.entity1.getBirthDate())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithDateAsStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_BIRTH_DATE, (Operator)Operator.EQUALS, (Object)this.formatDate(QuerityGenericSpringTestSuite.this.entity1.getBirthDate()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getBirthDate() != null && p.getBirthDate().isEqual(QuerityGenericSpringTestSuite.this.entity1.getBirthDate())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBooleanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_MARRIED, (Operator)Operator.EQUALS, (Object)true)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(Person::isMarried).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBooleanAsStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_MARRIED, (Operator)Operator.EQUALS, (Object)Boolean.TRUE.toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(Person::isMarried).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithIntegerEqualsConditionAsString_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_CHILDREN, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getChildren().toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(QuerityGenericSpringTestSuite.this.entity1.getChildren())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBigDecimalEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) == 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBigDecimalEqualsConditionAsString_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) == 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBigDecimalGreaterThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) > 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotBigDecimalGreaterThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) <= 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBigDecimalGreaterThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN_EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) >= 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotBigDecimalGreaterThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN_EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) < 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBigDecimalLesserThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) < 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotBigDecimalLesserThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) >= 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithBigDecimalLesserThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN_EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) <= 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotBigDecimalLesserThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN_EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericSpringTestSuite.this.entity1.getHeight()) > 0).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringNotEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> !QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotStringNotEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringStartsWithCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            String prefix = QuerityGenericSpringTestSuite.this.entity1.getLastName().substring(0, 3);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.STARTS_WITH, (Object)prefix)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().startsWith(prefix)).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringEndsWithCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            String suffix = QuerityGenericSpringTestSuite.this.entity1.getLastName().substring(3);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.ENDS_WITH, (Object)suffix)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().endsWith(suffix)).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringContainsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            String substring = QuerityGenericSpringTestSuite.this.entity1.getLastName().substring(1, 3);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.CONTAINS, (Object)substring)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().contains(substring)).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringNotContainsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            String substring = QuerityGenericSpringTestSuite.this.entity1.getLastName().substring(1, 3);
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.CONTAINS, (Object)substring))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() == null || !p.getLastName().contains(substring)).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringIsNullCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IS_NULL)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() == null).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringIsNotNullCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IS_NOT_NULL)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() != null).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotStringIsNotNullCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IS_NOT_NULL))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getLastName() == null).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithTwoStringEqualsConditionsWithAndLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getFirstName())})).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName()) && QuerityGenericSpringTestSuite.this.entity1.getFirstName().equals(p.getFirstName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithTwoStringEqualsConditionsWithOrLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity2.getLastName())})).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName()) || QuerityGenericSpringTestSuite.this.entity2.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNestedConditions_whenFindAll_thenReturnListOfEntity() {
            Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()), Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getFirstName()), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity2.getFirstName())})})).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName()) && (QuerityGenericSpringTestSuite.this.entity1.getFirstName().equals(p.getFirstName()) || QuerityGenericSpringTestSuite.this.entity2.getFirstName().equals(p.getFirstName()))).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringEqualsConditionOnNestedField_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_ADDRESS_CITY, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getAddress().getCity())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getAddress().getCity().equals(p.getAddress().getCity())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringEqualsConditionOnNestedCollectionItemField_whenFilterAll_thenReturnOnlyFilteredElements() {
            String visitedCountry = ((Location)QuerityGenericSpringTestSuite.this.entity1.getVisitedLocations().get(0)).getCountry();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_VISITED_LOCATIONS_COUNTRY, (Operator)Operator.EQUALS, (Object)visitedCountry)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getVisitedLocations().stream().map(Location::getCountry).anyMatch(visitedCountry::equals)).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringEqualsConditionOnNestedCollectionItemStringListField_whenFilterAll_thenReturnOnlyFilteredElements() {
            String visitedCity = ((Location)QuerityGenericSpringTestSuite.this.entity1.getVisitedLocations().get(0)).getCities().get(0);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_VISITED_LOCATIONS_CITIES, (Operator)Operator.EQUALS, (Object)visitedCity)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getVisitedLocations().stream().anyMatch(l -> l.getCities().contains(visitedCity))).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithTwoStringEqualsConditionOnNestedCollectionItemFieldsWithAndLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
            String visitedCountry = ((Location)QuerityGenericSpringTestSuite.this.entity1.getVisitedLocations().get(0)).getCountry();
            String visitedCity = ((Location)QuerityGenericSpringTestSuite.this.entity1.getVisitedLocations().get(0)).getCities().get(0);
            Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_VISITED_LOCATIONS_COUNTRY, (Operator)Operator.EQUALS, (Object)visitedCountry), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_VISITED_LOCATIONS_CITIES, (Operator)Operator.EQUALS, (Object)visitedCity)})).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getVisitedLocations().stream().anyMatch(l -> visitedCountry.equals(l.getCountry()) && l.getCities().contains(visitedCity))).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithStringEqualsConditionOnDoubleNestedCollectionItemField_whenFilterAll_thenReturnOnlyFilteredElements() {
            String sku = ((OrderItem)((Order)QuerityGenericSpringTestSuite.this.entity1.getOrders().get(0)).getItems().get(0)).getSku();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)"orders.items.sku", (Operator)Operator.EQUALS, (Object)sku)).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(this.findByOrderContainingItemMatching(i -> i.getSku().equals(sku)));
        }

        @Test
        void givenFilterWithEnumEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            ProductCategory category = QuerityGenericSpringTestSuite.this.entity1.getFavouriteProductCategory();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FAVOURITE_PRODUCT_CATEGORY, (Operator)Operator.EQUALS, (Object)category.name())).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(e -> e.getFavouriteProductCategory().equals((Object)category)).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotConditionWithStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> !QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithTwoNestedNotConditionsWithStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName())))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotConditionWithTwoStringEqualsConditionsWithAndLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getFirstName())}))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> !QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName()) || !QuerityGenericSpringTestSuite.this.entity1.getFirstName().equals(p.getFirstName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotConditionWithTwoStringEqualsConditionsWithOrLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity2.getLastName())}))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> !QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName()) && !QuerityGenericSpringTestSuite.this.entity2.getLastName().equals(p.getLastName())).collect(Collectors.toList()));
        }

        @Test
        void givenFilterWithNotConditionWithNestedConditions_whenFindAll_thenReturnListOfEntity() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getLastName()), Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity1.getFirstName()), Querity.filterBy((String)QuerityGenericSpringTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericSpringTestSuite.this.entity2.getFirstName())})}))).build();
            List result = QuerityGenericSpringTestSuite.this.querity.findAll(QuerityGenericSpringTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> !QuerityGenericSpringTestSuite.this.entity1.getLastName().equals(p.getLastName()) || !QuerityGenericSpringTestSuite.this.entity1.getFirstName().equals(p.getFirstName()) && !QuerityGenericSpringTestSuite.this.entity2.getFirstName().equals(p.getFirstName())).collect(Collectors.toList()));
        }

        private List<T> findByOrderContainingItemMatching(Predicate<OrderItem> matchPredicate) {
            return QuerityGenericSpringTestSuite.this.entities.stream().filter(p -> p.getOrders().stream().map(Order::getItems).flatMap(Collection::stream).anyMatch(matchPredicate)).collect(Collectors.toList());
        }

        private String formatDate(LocalDate birthDate) {
            return birthDate.format(DateTimeFormatter.ISO_DATE);
        }
    }
}

